/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.conjure.java.lib.internal.ConjureCollections;
import com.palantir.docker.compose.events.ClusterWaitType;
import com.palantir.docker.compose.events.Task;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ClusterWaitEvent {
    private final Task task;
    private final List<String> serviceNames;
    private final ClusterWaitType type;
    private volatile int memoizedHashCode;

    private ClusterWaitEvent(Task task, List<String> serviceNames, ClusterWaitType type) {
        ClusterWaitEvent.validateFields(task, serviceNames, type);
        this.task = task;
        this.serviceNames = Collections.unmodifiableList(serviceNames);
        this.type = type;
    }

    @JsonProperty(value="task")
    public Task getTask() {
        return this.task;
    }

    @JsonProperty(value="serviceNames")
    public List<String> getServiceNames() {
        return this.serviceNames;
    }

    @JsonProperty(value="type")
    public ClusterWaitType getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ClusterWaitEvent && this.equalTo((ClusterWaitEvent)other);
    }

    private boolean equalTo(ClusterWaitEvent other) {
        return this.task.equals(other.task) && this.serviceNames.equals(other.serviceNames) && this.type.equals(other.type);
    }

    public int hashCode() {
        if (this.memoizedHashCode == 0) {
            this.memoizedHashCode = Objects.hash(this.task, this.serviceNames, this.type);
        }
        return this.memoizedHashCode;
    }

    public String toString() {
        return "ClusterWaitEvent" + '{' + "task" + ": " + this.task + ", " + "serviceNames" + ": " + this.serviceNames + ", " + "type" + ": " + this.type + '}';
    }

    public static ClusterWaitEvent of(Task task, List<String> serviceNames, ClusterWaitType type) {
        return ClusterWaitEvent.builder().task(task).serviceNames(serviceNames).type(type).build();
    }

    private static void validateFields(Task task, List<String> serviceNames, ClusterWaitType type) {
        List<String> missingFields = null;
        missingFields = ClusterWaitEvent.addFieldIfMissing(missingFields, task, "task");
        missingFields = ClusterWaitEvent.addFieldIfMissing(missingFields, serviceNames, "serviceNames");
        if ((missingFields = ClusterWaitEvent.addFieldIfMissing(missingFields, type, "type")) != null) {
            throw new SafeIllegalArgumentException("Some required fields have not been set", new Arg[]{SafeArg.of((String)"missingFields", missingFields)});
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<String>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Task task;
        private List<String> serviceNames = new ArrayList<String>();
        private ClusterWaitType type;

        private Builder() {
        }

        public Builder from(ClusterWaitEvent other) {
            this.task(other.getTask());
            this.serviceNames(other.getServiceNames());
            this.type(other.getType());
            return this;
        }

        @JsonSetter(value="task")
        public Builder task(Task task) {
            this.task = (Task)Preconditions.checkNotNull((Object)task, (String)"task cannot be null");
            return this;
        }

        @JsonSetter(value="serviceNames", nulls=Nulls.SKIP)
        public Builder serviceNames(Iterable<String> serviceNames) {
            this.serviceNames.clear();
            ConjureCollections.addAll(this.serviceNames, (Iterable)((Iterable)Preconditions.checkNotNull(serviceNames, (String)"serviceNames cannot be null")));
            return this;
        }

        public Builder addAllServiceNames(Iterable<String> serviceNames) {
            ConjureCollections.addAll(this.serviceNames, (Iterable)((Iterable)Preconditions.checkNotNull(serviceNames, (String)"serviceNames cannot be null")));
            return this;
        }

        public Builder serviceNames(String serviceNames) {
            this.serviceNames.add(serviceNames);
            return this;
        }

        @JsonSetter(value="type")
        public Builder type(ClusterWaitType type) {
            this.type = (ClusterWaitType)Preconditions.checkNotNull((Object)type, (String)"type cannot be null");
            return this;
        }

        public ClusterWaitEvent build() {
            return new ClusterWaitEvent(this.task, this.serviceNames, this.type);
        }
    }
}

