/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins.javaversions;

import com.palantir.baseline.plugins.javaversions.BaselineJavaToolchain;
import com.palantir.baseline.plugins.javaversions.BaselineJavaVersionExtension;
import com.palantir.baseline.plugins.javaversions.BaselineJavaVersionsExtension;
import com.palantir.baseline.plugins.javaversions.CheckClasspathCompatible;
import com.palantir.baseline.plugins.javaversions.ChosenJavaVersion;
import com.palantir.baseline.plugins.javaversions.JavaToolchains;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.external.javadoc.CoreJavadocOptions;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.util.GradleVersion;

public final class BaselineJavaVersion
implements Plugin<Project> {
    public static final String EXTENSION_NAME = "javaVersion";
    public static final Logger log = Logging.getLogger((String)BaselineJavaVersion.class.getName());

    public void apply(Project project) {
        final BaselineJavaVersionExtension extension = (BaselineJavaVersionExtension)project.getExtensions().create(EXTENSION_NAME, BaselineJavaVersionExtension.class, new Object[]{project});
        project.getPluginManager().withPlugin("java", unused -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            JavaToolchainService toolchainService = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
            javaPluginExtension.toolchain((Action)new Action<JavaToolchainSpec>(){

                public void execute(JavaToolchainSpec javaToolchainSpec) {
                    javaToolchainSpec.getLanguageVersion().set(extension.runtime().map(ChosenJavaVersion::javaLanguageVersion));
                }
            });
            BaselineJavaVersionsExtension rootExtension = (BaselineJavaVersionsExtension)project.getRootProject().getExtensions().getByType(BaselineJavaVersionsExtension.class);
            JavaToolchains baselineConfiguredJavaToolchains = new JavaToolchains(project, rootExtension);
            BaselineJavaVersion.configureCompilationTasks(project, extension.target(), baselineConfiguredJavaToolchains, rootExtension, toolchainService);
            BaselineJavaVersion.configureExecutionTasks(project, extension.runtime(), baselineConfiguredJavaToolchains, rootExtension, toolchainService);
            TaskProvider checkJavaVersions = project.getTasks().register("checkJavaVersions", CheckJavaVersionsTask.class, task -> {
                task.getTargetVersion().set(extension.target());
                task.getRuntimeVersion().set(extension.runtime());
            });
            TaskProvider checkRuntimeClasspathCompatible = project.getTasks().register("checkRuntimeClasspathCompatible", CheckClasspathCompatible.class, task -> {
                task.getClasspathName().set((Object)"runtime");
                task.getJavaVersion().set(extension.runtime());
                task.getClasspath().setFrom((Iterable)project.getConfigurations().getByName("runtimeClasspath"));
            });
            project.getTasks().named("check").configure(check -> check.dependsOn(new Object[]{checkJavaVersions, checkRuntimeClasspathCompatible}));
        });
    }

    private static void configureCompilationTasks(Project project, final Property<ChosenJavaVersion> target, JavaToolchains baselineConfiguredJavaToolchains, BaselineJavaVersionsExtension rootExtension, JavaToolchainService javaToolchainService) {
        project.getTasks().withType(JavaCompile.class).configureEach(javaCompileTask -> {
            BaselineJavaVersion.setJavaCompiler(javaCompileTask, rootExtension, baselineConfiguredJavaToolchains, javaToolchainService, target);
            javaCompileTask.getOptions().getCompilerArgumentProviders().add(new EnablePreviewArgumentProvider((Provider<ChosenJavaVersion>)target));
            javaCompileTask.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    ((JavaCompile)task).setSourceCompatibility(((ChosenJavaVersion)target.get()).javaLanguageVersion().toString());
                }
            });
        });
        project.getTasks().withType(Javadoc.class).configureEach(javadocTask -> {
            BaselineJavaVersion.setJavaDocTool(javadocTask, rootExtension, baselineConfiguredJavaToolchains, javaToolchainService, target);
            javadocTask.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    CoreJavadocOptions options = (CoreJavadocOptions)((Javadoc)task).getOptions();
                    if (((ChosenJavaVersion)target.get()).enablePreview()) {
                        options.addBooleanOption("-enable-preview", true);
                        options.setSource(((ChosenJavaVersion)target.get()).javaLanguageVersion().toString());
                    }
                }
            });
        });
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.5")) >= 0) {
            project.getTasks().withType(Checkstyle.class).configureEach(checkstyle -> checkstyle.getJavaLauncher().set(BaselineJavaVersion.getJavaLauncher(rootExtension, baselineConfiguredJavaToolchains, javaToolchainService, target)));
        }
        project.getTasks().withType(GroovyCompile.class).configureEach(groovyCompileTask -> {
            groovyCompileTask.getJavaLauncher().set(BaselineJavaVersion.getJavaLauncher(rootExtension, baselineConfiguredJavaToolchains, javaToolchainService, target));
            groovyCompileTask.getOptions().getCompilerArgumentProviders().add(new EnablePreviewArgumentProvider((Provider<ChosenJavaVersion>)target));
            groovyCompileTask.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    ((GroovyCompile)task).setSourceCompatibility(((ChosenJavaVersion)target.get()).javaLanguageVersion().toString());
                }
            });
        });
        project.getTasks().withType(ScalaCompile.class).configureEach(scalaCompileTask -> {
            scalaCompileTask.getJavaLauncher().set(BaselineJavaVersion.getJavaLauncher(rootExtension, baselineConfiguredJavaToolchains, javaToolchainService, target));
            scalaCompileTask.getOptions().getCompilerArgumentProviders().add(new EnablePreviewArgumentProvider((Provider<ChosenJavaVersion>)target));
            scalaCompileTask.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    ((ScalaCompile)task).setSourceCompatibility(((ChosenJavaVersion)target.get()).javaLanguageVersion().toString());
                }
            });
        });
        project.getTasks().withType(ScalaDoc.class).configureEach(scalaDoc -> scalaDoc.getJavaLauncher().set(BaselineJavaVersion.getJavaLauncher(rootExtension, baselineConfiguredJavaToolchains, javaToolchainService, target)));
    }

    private static void configureExecutionTasks(Project project, Property<ChosenJavaVersion> runtime, JavaToolchains baselineConfiguredJavaToolchains, BaselineJavaVersionsExtension rootExtension, JavaToolchainService javaToolchainService) {
        project.getTasks().withType(JavaExec.class).configureEach(javaExec -> {
            javaExec.getJavaLauncher().set(BaselineJavaVersion.getJavaLauncher(rootExtension, baselineConfiguredJavaToolchains, javaToolchainService, runtime));
            javaExec.getJvmArgumentProviders().add(new EnablePreviewArgumentProvider((Provider<ChosenJavaVersion>)runtime));
        });
        project.getTasks().withType(Test.class).configureEach(test -> {
            test.getJavaLauncher().set(BaselineJavaVersion.getJavaLauncher(rootExtension, baselineConfiguredJavaToolchains, javaToolchainService, runtime));
            test.getJvmArgumentProviders().add(new EnablePreviewArgumentProvider((Provider<ChosenJavaVersion>)runtime));
        });
    }

    private static void setJavaCompiler(JavaCompile javaCompileTask, BaselineJavaVersionsExtension rootExtension, JavaToolchains baselineConfiguredJavaToolchains, JavaToolchainService javaToolchainService, Property<ChosenJavaVersion> version) {
        if (((Boolean)rootExtension.getSetupJdkToolchains().get()).booleanValue()) {
            log.debug("Using baselineConfiguredJavaToolchains to configure the javaCompileTask");
            javaCompileTask.getJavaCompiler().set(baselineConfiguredJavaToolchains.forVersion((Provider<ChosenJavaVersion>)version).flatMap(BaselineJavaToolchain::javaCompiler));
            return;
        }
        log.debug("Using detected javaToolchains to configure the javaCompileTask");
        javaCompileTask.getJavaCompiler().set(javaToolchainService.compilerFor(spec -> spec.getLanguageVersion().set(version.map(ChosenJavaVersion::javaLanguageVersion))));
    }

    private static void setJavaDocTool(Javadoc javadocTask, BaselineJavaVersionsExtension rootExtension, JavaToolchains baselineConfiguredJavaToolchains, JavaToolchainService javaToolchainService, Property<ChosenJavaVersion> version) {
        if (((Boolean)rootExtension.getSetupJdkToolchains().get()).booleanValue()) {
            log.debug("Using baselineConfiguredJavaToolchains to configure javaDocTool");
            javadocTask.getJavadocTool().set(baselineConfiguredJavaToolchains.forVersion((Provider<ChosenJavaVersion>)version).flatMap(BaselineJavaToolchain::javadocTool));
            return;
        }
        log.debug("Using detected javaToolchains to configure javaDocTool");
        javadocTask.getJavadocTool().set(javaToolchainService.javadocToolFor(spec -> spec.getLanguageVersion().set(version.map(ChosenJavaVersion::javaLanguageVersion))));
    }

    private static Provider<JavaLauncher> getJavaLauncher(BaselineJavaVersionsExtension rootExtension, JavaToolchains baselineConfiguredJavaToolchains, JavaToolchainService javaToolchainService, Property<ChosenJavaVersion> version) {
        if (((Boolean)rootExtension.getSetupJdkToolchains().get()).booleanValue()) {
            log.debug("Using baselineConfiguredJavaToolchains to configure JavaLauncher");
            return baselineConfiguredJavaToolchains.forVersion((Provider<ChosenJavaVersion>)version).flatMap(BaselineJavaToolchain::javaLauncher);
        }
        log.debug("Using detected javaToolchains to configure JavaLauncher");
        return javaToolchainService.launcherFor(spec -> spec.getLanguageVersion().set(version.map(ChosenJavaVersion::javaLanguageVersion)));
    }

    private static class EnablePreviewArgumentProvider
    implements CommandLineArgumentProvider {
        public static final String FLAG = "--enable-preview";
        private final Provider<ChosenJavaVersion> provider;

        private EnablePreviewArgumentProvider(Provider<ChosenJavaVersion> provider) {
            this.provider = provider;
        }

        public Iterable<String> asArguments() {
            return ((ChosenJavaVersion)this.provider.get()).enablePreview() ? Collections.singletonList(FLAG) : Collections.emptyList();
        }
    }

    @CacheableTask
    public static class CheckJavaVersionsTask
    extends DefaultTask {
        private final Property<ChosenJavaVersion> targetVersion;
        private final Property<ChosenJavaVersion> runtimeVersion;

        @Inject
        public CheckJavaVersionsTask() {
            this.setGroup("Verification");
            this.setDescription("Ensures configured java versions are compatible: The runtime version must be greater than or equal to the target version.");
            this.targetVersion = this.getProject().getObjects().property(ChosenJavaVersion.class);
            this.runtimeVersion = this.getProject().getObjects().property(ChosenJavaVersion.class);
        }

        @Input
        public Property<ChosenJavaVersion> getTargetVersion() {
            return this.targetVersion;
        }

        @Input
        public Property<ChosenJavaVersion> getRuntimeVersion() {
            return this.runtimeVersion;
        }

        @TaskAction
        public final void checkJavaVersions() {
            ChosenJavaVersion target = (ChosenJavaVersion)this.getTargetVersion().get();
            ChosenJavaVersion runtime = (ChosenJavaVersion)this.getRuntimeVersion().get();
            this.getLogger().debug("BaselineJavaVersion configured project {} with target version {} and runtime version {}", new Object[]{this.getProject(), target, runtime});
            if (target.enablePreview() && !target.equals(runtime)) {
                throw new GradleException(String.format("Runtime Java version (%s) must be exactly the same as the compilation target (%s), because --enable-preview is enabled. Otherwise Java will fail to start. See https://openjdk.org/jeps/12.", runtime, target));
            }
            if (target.javaLanguageVersion().asInt() > runtime.javaLanguageVersion().asInt()) {
                throw new GradleException(String.format("The requested compilation target Java version (%s) must not exceed the requested runtime Java version (%s)", target, runtime));
            }
        }
    }
}

