/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import groovy.util.Node;
import groovy.util.XmlNodePrinter;
import groovy.util.XmlParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

final class XmlUtils {
    private XmlUtils() {
    }

    static void updateXmlFileIfExists(File configurationFile, Consumer<Node> configure) {
        if (!configurationFile.exists()) {
            return;
        }
        XmlUtils.createOrUpdateXmlFile(configurationFile, configure);
    }

    static void createOrUpdateXmlFile(File configurationFile, Consumer<Node> configure) {
        XmlUtils.createOrUpdateXmlFile(configurationFile, configure, () -> new Node(null, (Object)"project", (Map)ImmutableMap.of((Object)"version", (Object)"4")));
    }

    static void createOrUpdateXmlFile(File configurationFile, Consumer<Node> configure, Supplier<Node> defaultRootNode) {
        Node rootNode;
        if (configurationFile.isFile()) {
            try {
                rootNode = new XmlParser().parse(configurationFile);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException("Couldn't parse existing configuration file: " + configurationFile, e);
            }
        } else {
            rootNode = defaultRootNode.get();
        }
        configure.accept(rootNode);
        configurationFile.getParentFile().mkdirs();
        try (BufferedWriter writer = Files.newWriter((File)configurationFile, (Charset)StandardCharsets.UTF_8);
             PrintWriter printWriter = new PrintWriter(writer);){
            XmlNodePrinter nodePrinter = new XmlNodePrinter(printWriter);
            nodePrinter.setPreserveWhitespace(true);
            nodePrinter.print(rootNode);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write back to configuration file: " + configurationFile, e);
        }
    }
}

