/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.util;

import com.google.common.base.Preconditions;
import com.palantir.baseline.util.VersionsProps_ParsedVersionsProps_Builder;
import com.palantir.baseline.util.VersionsProps_VersionForce_Builder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class VersionsProps {
    private static final Pattern VERSION_FORCE_REGEX = Pattern.compile("([^:=\\s]+:[^:=\\s]+)\\s*=\\s*([^\\s]+)");

    private VersionsProps() {
    }

    public static ParsedVersionsProps readVersionsProps(File propsFile) {
        ParsedVersionsProps parsedVersionsProps;
        block8: {
            Preconditions.checkArgument((boolean)propsFile.exists(), (Object)("No " + propsFile.toPath() + " file found"));
            Stream<String> lines = Files.lines(propsFile.toPath());
            try {
                parsedVersionsProps = VersionsProps.readVersionsProps(lines);
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading " + propsFile.toPath() + " file", e);
                }
            }
            lines.close();
        }
        return parsedVersionsProps;
    }

    static ParsedVersionsProps readVersionsProps(Stream<String> linesStream) {
        List lines = linesStream.map(String::trim).collect(Collectors.toList());
        ParsedVersionsProps.Builder builder = new ParsedVersionsProps.Builder().addAllLines((Iterable)lines);
        boolean active = true;
        for (int index = 0; index < lines.size(); ++index) {
            int commentIndex;
            String line;
            Matcher matcher;
            String line0 = (String)lines.get(index);
            if (line0.equals("# linter:ON")) {
                active = true;
            } else if (line0.equals("# linter:OFF")) {
                active = false;
            }
            if (!active || !(matcher = VERSION_FORCE_REGEX.matcher(line = ((commentIndex = line0.indexOf("#")) >= 0 ? line0.substring(0, commentIndex) : line0).trim())).matches()) continue;
            String propName = matcher.group(1);
            String propVersion = matcher.group(2);
            VersionForce force = new VersionForce.Builder().name(propName).version(propVersion).build();
            builder.putNamesToLocationMap(force.name(), index);
            builder.addForces(force);
        }
        return builder.build();
    }

    public static void writeVersionsProps(ParsedVersionsProps parsedVersionsProps, Stream<String> forcesToRemove, File propsFile) {
        List<String> lines = parsedVersionsProps.lines();
        Set indicesToSkip = forcesToRemove.map(parsedVersionsProps.namesToLocationMap()::get).map(Preconditions::checkNotNull).collect(Collectors.toSet());
        try (BufferedWriter writer0 = Files.newBufferedWriter(propsFile.toPath(), StandardOpenOption.TRUNCATE_EXISTING);
             PrintWriter writer = new PrintWriter(writer0);){
            for (int index = 0; index < lines.size(); ++index) {
                if (indicesToSkip.contains(index)) continue;
                writer.println(lines.get(index));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface VersionForce {
        public String name();

        public String version();

        public static VersionForce of(String name, String version) {
            return new Builder().name(name).version(version).build();
        }

        public Builder toBuilder();

        public static class Builder
        extends VersionsProps_VersionForce_Builder {
        }
    }

    public static interface ParsedVersionsProps {
        public List<String> lines();

        public Map<String, Integer> namesToLocationMap();

        public List<VersionForce> forces();

        public Builder toBuilder();

        public static class Builder
        extends VersionsProps_ParsedVersionsProps_Builder {
        }
    }
}

