/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins.javaversions;

import com.palantir.baseline.plugins.javaversions.JavaInstallationMetadataUtils;
import javax.inject.Inject;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.WorkResult;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.internal.DefaultToolchainJavaCompiler;
import org.gradle.jvm.toolchain.internal.JavaCompilerFactory;
import org.gradle.language.base.internal.compile.CompileSpec;

final class BaselineJavaCompiler
extends DefaultToolchainJavaCompiler {
    private static final Logger log = Logging.getLogger(BaselineJavaCompiler.class);
    private final JavaCompilerFactory compilerFactory;
    private final JavaInstallationMetadata javaInstallationMetadata;

    BaselineJavaCompiler(JavaCompilerFactory compilerFactory, JavaInstallationMetadata javaInstallationMetadata) {
        super(null, compilerFactory);
        this.compilerFactory = compilerFactory;
        this.javaInstallationMetadata = javaInstallationMetadata;
    }

    public JavaInstallationMetadata getMetadata() {
        return this.javaInstallationMetadata;
    }

    public RegularFile getExecutablePath() {
        return JavaInstallationMetadataUtils.findExecutable(this.javaInstallationMetadata, "javac");
    }

    public <T extends CompileSpec> WorkResult execute(T spec) {
        log.info("Compiling with toolchain '{}'.", (Object)this.javaInstallationMetadata.getInstallationPath().getAsFile());
        Class<?> specType = spec.getClass();
        return this.compilerFactory.create(specType).execute(spec);
    }

    public static BaselineJavaCompiler create(ObjectFactory objectFactory, JavaInstallationMetadata javaInstallationMetadata) {
        return new BaselineJavaCompiler(((JavaCompilerFactoryGrabber)objectFactory.newInstance(JavaCompilerFactoryGrabber.class, new Object[0])).getJavaCompilerFactory(), javaInstallationMetadata);
    }

    static interface JavaCompilerFactoryGrabber {
        @Inject
        public JavaCompilerFactory getJavaCompilerFactory();
    }
}

