/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins.javaversions;

import com.palantir.baseline.plugins.javaversions.BaselineJavaVersionsExtensionSetters;
import com.palantir.baseline.plugins.javaversions.ChosenJavaVersion;
import com.palantir.gradle.utils.lazilyconfiguredmapping.LazilyConfiguredMapping;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public class BaselineJavaVersionsExtension
implements BaselineJavaVersionsExtensionSetters {
    private final Property<JavaLanguageVersion> libraryTarget;
    private final Property<ChosenJavaVersion> distributionTarget;
    private final Property<ChosenJavaVersion> runtime;
    private final LazilyConfiguredMapping<JavaLanguageVersion, AtomicReference<JavaInstallationMetadata>, Project> jdks = new LazilyConfiguredMapping(AtomicReference::new);

    @Inject
    public BaselineJavaVersionsExtension(Project project) {
        this.libraryTarget = project.getObjects().property(JavaLanguageVersion.class);
        this.distributionTarget = project.getObjects().property(ChosenJavaVersion.class);
        this.runtime = project.getObjects().property(ChosenJavaVersion.class);
        this.distributionTarget.convention(this.libraryTarget.map(ChosenJavaVersion::of));
        this.runtime.convention(this.distributionTarget);
        this.libraryTarget.finalizeValueOnRead();
        this.distributionTarget.finalizeValueOnRead();
        this.runtime.finalizeValueOnRead();
    }

    public final Property<JavaLanguageVersion> libraryTarget() {
        return this.libraryTarget;
    }

    @Override
    public final void setLibraryTarget(int value) {
        this.libraryTarget.set((Object)JavaLanguageVersion.of((int)value));
    }

    @Override
    public final void setLibraryTarget(String value) {
        ChosenJavaVersion version = ChosenJavaVersion.fromString(value);
        if (version.enablePreview()) {
            throw new GradleException("Because code compiled with preview features cannot be run on newer JVMs, (Java 15 preview cannot be run on Java 17, e.g.) it is unsuitable for use on projects that are published as libraries.");
        }
        this.libraryTarget.set((Object)version.javaLanguageVersion());
    }

    public final Property<ChosenJavaVersion> distributionTarget() {
        return this.distributionTarget;
    }

    @Override
    public final void setDistributionTarget(int value) {
        this.distributionTarget.set((Object)ChosenJavaVersion.of(value));
    }

    @Override
    public final void setDistributionTarget(String value) {
        this.distributionTarget.set((Object)ChosenJavaVersion.fromString(value));
    }

    public final Property<ChosenJavaVersion> runtime() {
        return this.runtime;
    }

    @Override
    public final void setRuntime(int value) {
        this.runtime.set((Object)ChosenJavaVersion.of(value));
    }

    @Override
    public final void setRuntime(String value) {
        this.runtime.set((Object)ChosenJavaVersion.fromString(value));
    }

    public final Optional<JavaInstallationMetadata> jdkMetadataFor(JavaLanguageVersion javaLanguageVersion, Project project) {
        return this.jdks.get((Object)javaLanguageVersion, (Object)project).map(AtomicReference::get);
    }

    public final void jdk(JavaLanguageVersion javaLanguageVersion, JavaInstallationMetadata javaInstallationMetadata) {
        this.jdks.put((Object)javaLanguageVersion, ref -> ref.set(javaInstallationMetadata));
    }

    public final void jdks(LazyJdks lazyJdks) {
        this.jdks.put((javaLanguageVersion, project) -> lazyJdks.jdkFor((JavaLanguageVersion)javaLanguageVersion, (Project)project).map(javaInstallationMetadata -> ref -> ref.set(javaInstallationMetadata)));
    }

    public static interface LazyJdks {
        public Optional<JavaInstallationMetadata> jdkFor(JavaLanguageVersion var1, Project var2);
    }
}

