/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins.javaversions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.palantir.baseline.plugins.javaversions.BaselineJavaVersion;
import com.palantir.baseline.plugins.javaversions.BaselineJavaVersionExtension;
import com.palantir.baseline.plugins.javaversions.BaselineJavaVersionsExtension;
import com.palantir.baseline.plugins.javaversions.ChosenJavaVersion;
import com.palantir.baseline.plugins.javaversions.SubprojectBaselineJavaVersionsExtension;
import java.util.Objects;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BaselineJavaVersions
implements Plugin<Project> {
    private static final Logger log = LoggerFactory.getLogger(BaselineJavaVersions.class);
    public static final String EXTENSION_NAME = "javaVersions";
    public static final GradleVersion MIN_GRADLE_VERSION = GradleVersion.version((String)"7.0");
    private static final ImmutableSet<String> LIBRARY_PLUGINS = ImmutableSet.of((Object)"nebula.maven-publish", (Object)"com.palantir.shadow-jar", (Object)"com.palantir.external-publish-jar");

    public void apply(Project project) {
        if (!Objects.equals(project, project.getRootProject())) {
            throw new GradleException("BaselineJavaVersions may only be applied to the root project");
        }
        GradleVersion currentGradleVersion = GradleVersion.current();
        if (currentGradleVersion.compareTo(MIN_GRADLE_VERSION) < 0) {
            throw new GradleException(String.format("BaselineJavaVersions requires %s. %s is not supported", MIN_GRADLE_VERSION, currentGradleVersion));
        }
        BaselineJavaVersionsExtension rootExtension = (BaselineJavaVersionsExtension)project.getExtensions().create(EXTENSION_NAME, BaselineJavaVersionsExtension.class, new Object[]{project});
        project.subprojects(proj -> proj.getExtensions().create(EXTENSION_NAME, SubprojectBaselineJavaVersionsExtension.class, new Object[]{proj}));
        project.allprojects(proj -> proj.getPluginManager().withPlugin("java", unused -> {
            proj.getPluginManager().apply(BaselineJavaVersion.class);
            BaselineJavaVersionExtension projectVersions = (BaselineJavaVersionExtension)proj.getExtensions().getByType(BaselineJavaVersionExtension.class);
            Provider suggestedTarget = proj.provider(() -> BaselineJavaVersions.isLibrary(proj, projectVersions) ? ChosenJavaVersion.of((JavaLanguageVersion)rootExtension.libraryTarget().get()) : (ChosenJavaVersion)rootExtension.distributionTarget().get());
            projectVersions.target().convention(suggestedTarget);
            projectVersions.runtime().convention(rootExtension.runtime());
        }));
    }

    private static boolean isLibrary(Project project, BaselineJavaVersionExtension projectVersions) {
        Property<Boolean> libraryOverride = projectVersions.overrideLibraryAutoDetection();
        if (libraryOverride.isPresent()) {
            log.debug("Project '{}' is considered a library because it has been overridden with library = true", (Object)project.getDisplayName());
            return (Boolean)libraryOverride.get();
        }
        for (String plugin : LIBRARY_PLUGINS) {
            if (!project.getPluginManager().hasPlugin(plugin)) continue;
            log.debug("Project '{}' is considered a library because the '{}' plugin is applied", (Object)project.getDisplayName(), (Object)plugin);
            return true;
        }
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().findByType(PublishingExtension.class);
        if (publishing == null) {
            log.debug("Project '{}' is considered a distribution, not a library, because it doesn't define any publishing extensions", (Object)project.getDisplayName());
            return false;
        }
        ImmutableList jarPublications = (ImmutableList)publishing.getPublications().stream().filter(pub -> BaselineJavaVersions.isLibraryPublication(project, pub)).map(Named::getName).collect(ImmutableList.toImmutableList());
        if (jarPublications.isEmpty()) {
            log.debug("Project '{}' is considered a distribution because it does not publish jars", (Object)project.getDisplayName());
            return false;
        }
        log.debug("Project '{}' is considered a library because it publishes jars: {}", (Object)project.getDisplayName(), (Object)jarPublications);
        return true;
    }

    private static boolean isLibraryPublication(Project project, Publication publication) {
        if (publication instanceof MavenPublication) {
            MavenPublication mavenPublication = (MavenPublication)publication;
            return mavenPublication.getArtifacts().stream().anyMatch(artifact -> "jar".equals(artifact.getExtension()));
        }
        if (publication instanceof IvyPublication) {
            IvyPublication ivyPublication = (IvyPublication)publication;
            return ivyPublication.getArtifacts().stream().anyMatch(artifact -> "jar".equals(artifact.getExtension()));
        }
        log.warn("Unknown publication '{}' of type '{}'. Assuming project {} is a library", new Object[]{publication, publication.getClass().getName(), project.getName()});
        return true;
    }
}

