/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins.javaversions;

import com.palantir.baseline.plugins.javaversions.BaselineJavaToolchain;
import com.palantir.baseline.plugins.javaversions.BaselineJavaVersionsExtension;
import com.palantir.baseline.plugins.javaversions.ChosenJavaVersion;
import com.palantir.baseline.plugins.javaversions.ConfiguredJavaToolchain;
import com.palantir.baseline.plugins.javaversions.JavaInstallationMetadataWrapper;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;

public final class JavaToolchains {
    private final Project project;
    private final BaselineJavaVersionsExtension baselineJavaVersionsExtension;

    public JavaToolchains(Project project, BaselineJavaVersionsExtension baselineJavaVersionsExtension) {
        this.project = project;
        this.baselineJavaVersionsExtension = baselineJavaVersionsExtension;
    }

    public Provider<BaselineJavaToolchain> forVersion(Provider<ChosenJavaVersion> javaLanguageVersionProvider) {
        return javaLanguageVersionProvider.map(chosenJavaVersion -> {
            Provider configuredJdkMetadata = this.project.provider(() -> this.baselineJavaVersionsExtension.jdkMetadataFor(chosenJavaVersion.javaLanguageVersion(), this.project).orElseGet(() -> ((JavaLauncher)((JavaToolchainService)this.project.getExtensions().getByType(JavaToolchainService.class)).launcherFor(javaToolchainSpec -> javaToolchainSpec.getLanguageVersion().set((Object)chosenJavaVersion.javaLanguageVersion())).get()).getMetadata()));
            return new ConfiguredJavaToolchain(this.project.getObjects(), (Provider<JavaInstallationMetadata>)this.project.provider(() -> new JavaInstallationMetadataWrapper(chosenJavaVersion.javaLanguageVersion(), (Provider<JavaInstallationMetadata>)configuredJdkMetadata)));
        });
    }
}

