/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.spotless.FormatterStep;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import com.palantir.baseline.plugins.AbstractBaselinePlugin;
import com.palantir.baseline.plugins.BaselineCheckstyle;
import com.palantir.baseline.plugins.LazyFormatterStep;
import com.palantir.baseline.plugins.MultiLicenseHeaderStep;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

class BaselineFormat
extends AbstractBaselinePlugin {
    private static final String ECLIPSE_FORMATTING = "com.palantir.baseline-format.eclipse";
    private static final String PJF_PROPERTY = "com.palantir.baseline-format.palantir-java-format";
    private static final String GENERATED_MARKER = File.separator + "generated";
    private static final String PJF_PLUGIN = "com.palantir.java-format";

    BaselineFormat() {
    }

    public void apply(Project project) {
        this.project = project;
        project.getPluginManager().apply("com.diffplug.spotless");
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        SpotlessExtension spotlessExtension = (SpotlessExtension)project.getExtensions().getByType(SpotlessExtension.class);
        spotlessExtension.setEnforceCheck(false);
        if (!"false".equals(project.findProperty("com.palantir.baseline-format.copyright"))) {
            this.configureCopyrightStep(project, spotlessExtension);
        }
        if ("true".equals(project.findProperty("com.palantir.baseline-format.gradle-files"))) {
            BaselineFormat.configureBuildGradleFormatter(project, spotlessExtension);
        }
        TaskProvider formatTask = project.getTasks().register("format", task -> task.setGroup("Formatting"));
        project.afterEvaluate(p -> {
            formatTask.configure(t -> t.dependsOn(new Object[]{"spotlessApply"}));
            project.getTasks().named("check").configure(t -> t.dependsOn(new Object[]{project.getTasks().named("spotlessCheck")}));
            project.getPluginManager().withPlugin("com.palantir.baseline-config", baselineConfig -> project.getTasks().matching(t -> t.getName().startsWith("spotless")).configureEach(t -> t.mustRunAfter(new Object[]{"baselineUpdateConfig"})));
        });
        project.getPluginManager().withPlugin("java", plugin -> BaselineFormat.configureSpotlessJava(project, spotlessExtension));
    }

    private static void configureBuildGradleFormatter(Project project, SpotlessExtension spotlessExtension) {
        Path buildDir = project.getRootProject().getBuildDir().toPath();
        Path configFile = buildDir.resolve("baseline-format").resolve("greclipse.properties");
        try {
            URL url = Resources.getResource(BaselineCheckstyle.class, (String)"/greclipse.properties");
            Preconditions.checkNotNull((Object)url, (Object)"Unable to find resource");
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            Files.write(configFile, Resources.toByteArray((URL)url), StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy greclipse.properties resource to " + configFile, e);
        }
        spotlessExtension.groovyGradle(ext -> ext.greclipse().configFile(new Object[]{configFile.toAbsolutePath()}));
    }

    private FormatterStep createLazyLicenseHeaderStep(Project project) {
        return new LazyFormatterStep(MultiLicenseHeaderStep.name(), () -> {
            List<String> headers = this.computeCopyrightHeaders(project);
            return MultiLicenseHeaderStep.createFromHeaders(headers);
        });
    }

    private void configureCopyrightStep(Project project, SpotlessExtension spotlessExtension) {
        project.getPluginManager().withPlugin("java", javaPlugin -> spotlessExtension.java(java -> java.addStep(this.createLazyLicenseHeaderStep(project))));
        project.getPluginManager().withPlugin("groovy", groovyPlugin -> spotlessExtension.groovy(groovy -> groovy.addStep(this.createLazyLicenseHeaderStep(project))));
    }

    private List<String> computeCopyrightHeaders(Project project) {
        Stream<Path> files;
        File copyrightDir = project.getRootProject().file((Object)(this.getConfigDir() + "/copyright"));
        try {
            files = Files.list(copyrightDir.toPath()).sorted(Comparator.comparing(Path::getFileName));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't list copyright directory: " + copyrightDir);
        }
        return files.map(BaselineFormat::computeCopyrightComment).collect(Collectors.toList());
    }

    private static String computeCopyrightComment(Path copyrightFile) {
        try {
            return new String(Files.readAllBytes(copyrightFile), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read copyright file " + copyrightFile, e);
        }
    }

    private static void configureSpotlessJava(Project project, SpotlessExtension spotlessExtension) {
        if (BaselineFormat.palantirJavaFormatterState(project) == FormatterState.ON) {
            project.getPlugins().apply(PJF_PLUGIN);
        }
        if (BaselineFormat.eclipseFormattingEnabled(project)) {
            project.getPluginManager().withPlugin(PJF_PLUGIN, plugin -> {
                throw new GradleException("Can't use both eclipse and palantir-java-format at the same time, please delete one of com.palantir.baseline-format.eclipse or com.palantir.baseline-format.palantir-java-format from your gradle.properties");
            });
        }
        Path eclipseXml = BaselineFormat.eclipseConfigFile(project);
        spotlessExtension.java(java -> {
            ConfigurableFileCollection allJavaFiles = project.files(new Object[0]);
            ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(sourceSet -> allJavaFiles.from(new Object[]{sourceSet.getAllJava().filter(file -> !file.toString().contains(GENERATED_MARKER))}));
            java.target(new Object[]{allJavaFiles});
            if (!project.getPluginManager().hasPlugin(PJF_PLUGIN)) {
                java.removeUnusedImports();
            }
            java.importOrder(new String[]{""});
            if (BaselineFormat.eclipseFormattingEnabled(project)) {
                java.eclipse().configFile(new Object[]{project.file((Object)eclipseXml.toString())});
            }
            java.trimTrailingWhitespace();
        });
        project.afterEvaluate(p -> {
            if (BaselineFormat.eclipseFormattingEnabled(project) && !Files.exists(eclipseXml, new LinkOption[0])) {
                TaskProvider spotlessJava = project.getTasks().named("spotlessJava");
                spotlessJava.configure(t -> t.dependsOn(new Object[]{":baselineUpdateConfig"}));
            }
            project.getTasks().withType(JavaCompile.class).configureEach(javaCompile -> {
                Task spotlessJava = project.getTasks().getByName("spotlessJava");
                spotlessJava.mustRunAfter(new Object[]{javaCompile});
            });
        });
    }

    static boolean eclipseFormattingEnabled(Project project) {
        return project.hasProperty(ECLIPSE_FORMATTING);
    }

    static FormatterState palantirJavaFormatterState(Project project) {
        if (!project.hasProperty(PJF_PROPERTY)) {
            return FormatterState.OFF;
        }
        Object propertyValue = project.property(PJF_PROPERTY);
        if ("started".equals(propertyValue)) {
            return FormatterState.STARTED_CONVERTING;
        }
        if ("true".equals(propertyValue) || "".equals(propertyValue)) {
            return FormatterState.ON;
        }
        throw new RuntimeException(String.format("Unexpected value for %s: %s.%nExpected one of [started, true].", PJF_PROPERTY, propertyValue));
    }

    static Path eclipseConfigFile(Project project) {
        return project.getRootDir().toPath().resolve(".baseline/spotless/eclipse.xml");
    }

    static enum FormatterState {
        OFF,
        STARTED_CONVERTING,
        ON;

    }
}

