/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.plugins;

import com.diffplug.spotless.FormatterStep;
import com.google.common.base.Suppliers;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.function.Supplier;
import javax.annotation.Nullable;

class LazyFormatterStep
implements FormatterStep {
    private final String name;
    private transient Supplier<FormatterStep> delegate;

    LazyFormatterStep(String name, Supplier<FormatterStep> delegate) {
        this.name = name;
        this.delegate = Suppliers.memoize(delegate::get);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String format(String rawUnix, File file) throws Exception {
        return this.delegate.get().format(rawUnix, file);
    }

    public final void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeObject(this.delegate.get());
    }

    public void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        FormatterStep serialized = (FormatterStep)input.readObject();
        this.delegate = () -> serialized;
    }
}

