/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.source;

import android.media.MediaExtractor;
import android.media.MediaMetadataRetriever;
import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.source.DefaultDataSource;
import java.io.FileDescriptor;
import java.io.IOException;

public class FileDescriptorDataSource
extends DefaultDataSource {
    @NonNull
    private final FileDescriptor descriptor;
    private final long offset;
    private final long length;

    public FileDescriptorDataSource(@NonNull FileDescriptor descriptor) {
        this(descriptor, 0L, 0x7FFFFFFFFFFFFFFL);
    }

    public FileDescriptorDataSource(@NonNull FileDescriptor descriptor, long offset, long length) {
        this.descriptor = descriptor;
        this.offset = offset;
        this.length = length > 0L ? length : 0x7FFFFFFFFFFFFFFL;
    }

    @Override
    protected void initializeExtractor(@NonNull MediaExtractor extractor) throws IOException {
        extractor.setDataSource(this.descriptor, this.offset, this.length);
    }

    @Override
    protected void initializeRetriever(@NonNull MediaMetadataRetriever retriever) {
        retriever.setDataSource(this.descriptor, this.offset, this.length);
    }
}

