/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.source;

import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.source.DataSource;

public class DataSourceWrapper
implements DataSource {
    private DataSource mSource;

    protected DataSourceWrapper(@NonNull DataSource source2) {
        this.mSource = source2;
    }

    protected DataSourceWrapper() {
        this.mSource = null;
    }

    @NonNull
    protected DataSource getSource() {
        return this.mSource;
    }

    protected void setSource(@NonNull DataSource source2) {
        this.mSource = source2;
    }

    @Override
    public int getOrientation() {
        return this.mSource.getOrientation();
    }

    @Override
    @Nullable
    public double[] getLocation() {
        return this.mSource.getLocation();
    }

    @Override
    public long getDurationUs() {
        return this.mSource.getDurationUs();
    }

    @Override
    @Nullable
    public MediaFormat getTrackFormat(@NonNull TrackType type) {
        return this.mSource.getTrackFormat(type);
    }

    @Override
    public void selectTrack(@NonNull TrackType type) {
        this.mSource.selectTrack(type);
    }

    @Override
    public long seekTo(long desiredPositionUs) {
        return this.mSource.seekTo(desiredPositionUs);
    }

    @Override
    public boolean canReadTrack(@NonNull TrackType type) {
        return this.mSource.canReadTrack(type);
    }

    @Override
    public void readTrack(@NonNull DataSource.Chunk chunk) {
        this.mSource.readTrack(chunk);
    }

    @Override
    public long getPositionUs() {
        return this.mSource.getPositionUs();
    }

    @Override
    public boolean isDrained() {
        return this.mSource.isDrained();
    }

    @Override
    public void releaseTrack(@NonNull TrackType type) {
        this.mSource.releaseTrack(type);
    }

    @Override
    public boolean isInitialized() {
        return this.mSource != null && this.mSource.isInitialized();
    }

    @Override
    public void initialize() {
        if (!this.isInitialized()) {
            if (this.mSource == null) {
                throw new NullPointerException("DataSourceWrapper's source is not set!");
            }
            this.mSource.initialize();
        }
    }

    @Override
    public void deinitialize() {
        this.mSource.deinitialize();
    }
}

