/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.transcode;

import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.Codecs;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.Segment;
import com.otaliastudios.transcoder.internal.Segments;
import com.otaliastudios.transcoder.internal.Timer;
import com.otaliastudios.transcoder.internal.Tracks;
import com.otaliastudios.transcoder.internal.pipeline.Pipeline;
import com.otaliastudios.transcoder.internal.pipeline.PipelinesKt;
import com.otaliastudios.transcoder.internal.transcode.DefaultTranscodeEngine;
import com.otaliastudios.transcoder.internal.transcode.TranscodeEngine;
import com.otaliastudios.transcoder.internal.utils.EosKt;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.resample.AudioResampler;
import com.otaliastudios.transcoder.sink.DataSink;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.strategy.TrackStrategy;
import com.otaliastudios.transcoder.stretch.AudioStretcher;
import com.otaliastudios.transcoder.time.TimeInterpolator;
import com.otaliastudios.transcoder.validator.Validator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u001e\u001a\u00020\u001fH\u0016J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u001c\u0010)\u001a\u00020\u001f2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u001f0+H\u0016J\b\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/otaliastudios/transcoder/internal/transcode/DefaultTranscodeEngine;", "Lcom/otaliastudios/transcoder/internal/transcode/TranscodeEngine;", "dataSources", "Lcom/otaliastudios/transcoder/internal/DataSources;", "dataSink", "Lcom/otaliastudios/transcoder/sink/DataSink;", "strategies", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "Lcom/otaliastudios/transcoder/strategy/TrackStrategy;", "validator", "Lcom/otaliastudios/transcoder/validator/Validator;", "videoRotation", "", "audioStretcher", "Lcom/otaliastudios/transcoder/stretch/AudioStretcher;", "audioResampler", "Lcom/otaliastudios/transcoder/resample/AudioResampler;", "interpolator", "Lcom/otaliastudios/transcoder/time/TimeInterpolator;", "(Lcom/otaliastudios/transcoder/internal/DataSources;Lcom/otaliastudios/transcoder/sink/DataSink;Lcom/otaliastudios/transcoder/internal/utils/TrackMap;Lcom/otaliastudios/transcoder/validator/Validator;ILcom/otaliastudios/transcoder/stretch/AudioStretcher;Lcom/otaliastudios/transcoder/resample/AudioResampler;Lcom/otaliastudios/transcoder/time/TimeInterpolator;)V", "codecs", "Lcom/otaliastudios/transcoder/internal/Codecs;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "segments", "Lcom/otaliastudios/transcoder/internal/Segments;", "timer", "Lcom/otaliastudios/transcoder/internal/Timer;", "tracks", "Lcom/otaliastudios/transcoder/internal/Tracks;", "cleanup", "", "createPipeline", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "index", "status", "Lcom/otaliastudios/transcoder/common/TrackStatus;", "outputFormat", "Landroid/media/MediaFormat;", "transcode", "progress", "Lkotlin/Function1;", "", "validate", "", "Companion", "lib_release"})
public final class DefaultTranscodeEngine
extends TranscodeEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataSources dataSources;
    @NotNull
    private final DataSink dataSink;
    @NotNull
    private final Validator validator;
    private final int videoRotation;
    @NotNull
    private final AudioStretcher audioStretcher;
    @NotNull
    private final AudioResampler audioResampler;
    @NotNull
    private final Logger log;
    @NotNull
    private final Tracks tracks;
    @NotNull
    private final Segments segments;
    @NotNull
    private final Timer timer;
    @NotNull
    private final Codecs codecs;
    private static final long WAIT_MS = 10L;
    private static final long PROGRESS_LOOPS = 10L;

    public DefaultTranscodeEngine(@NotNull DataSources dataSources, @NotNull DataSink dataSink, @NotNull TrackMap<TrackStrategy> strategies, @NotNull Validator validator, int videoRotation, @NotNull AudioStretcher audioStretcher, @NotNull AudioResampler audioResampler, @NotNull TimeInterpolator interpolator2) {
        Intrinsics.checkNotNullParameter((Object)dataSources, (String)"dataSources");
        Intrinsics.checkNotNullParameter((Object)dataSink, (String)"dataSink");
        Intrinsics.checkNotNullParameter(strategies, (String)"strategies");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter((Object)audioStretcher, (String)"audioStretcher");
        Intrinsics.checkNotNullParameter((Object)audioResampler, (String)"audioResampler");
        Intrinsics.checkNotNullParameter((Object)interpolator2, (String)"interpolator");
        this.dataSources = dataSources;
        this.dataSink = dataSink;
        this.validator = validator;
        this.videoRotation = videoRotation;
        this.audioStretcher = audioStretcher;
        this.audioResampler = audioResampler;
        this.log = new Logger("TranscodeEngine");
        this.tracks = new Tracks(strategies, this.dataSources, this.videoRotation, false);
        this.segments = new Segments(this.dataSources, this.tracks, (Function4<? super TrackType, ? super Integer, ? super TrackStatus, ? super MediaFormat, Pipeline>)((Function4)new Function4<TrackType, Integer, TrackStatus, MediaFormat, Pipeline>((Object)this){

            @NotNull
            public final Pipeline invoke(@NotNull TrackType p0, int p1, @NotNull TrackStatus p2, @NotNull MediaFormat p3) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                Intrinsics.checkNotNullParameter((Object)((Object)p2), (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                return DefaultTranscodeEngine.access$createPipeline((DefaultTranscodeEngine)this.receiver, p0, p1, p2, p3);
            }
        }));
        this.timer = new Timer(interpolator2, this.dataSources, this.tracks, (TrackMap<Integer>)this.segments.getCurrentIndex());
        this.codecs = new Codecs(this.dataSources, this.tracks, (TrackMap<Integer>)this.segments.getCurrentIndex());
        this.log.i("Created Tracks, Segments, Timer...");
        this.dataSink.setOrientation(0);
        double[] location2 = (double[])SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.dataSources.all()), (Function1)location.1.INSTANCE));
        if (location2 != null) {
            this.dataSink.setLocation(location2[0], location2[1]);
        }
        this.dataSink.setTrackStatus(TrackType.VIDEO, this.tracks.getAll().getVideo());
        this.dataSink.setTrackStatus(TrackType.AUDIO, this.tracks.getAll().getAudio());
        this.log.i("Set up the DataSink...");
    }

    private final Pipeline createPipeline(TrackType type, int index, TrackStatus status, MediaFormat outputFormat) {
        Pipeline pipeline;
        this.log.w("createPipeline(" + (Object)((Object)type) + ", " + index + ", " + (Object)((Object)status) + "), format=" + outputFormat);
        TimeInterpolator interpolator2 = this.timer.interpolator(type, index);
        Object sources = this.dataSources.get(type);
        DataSource source2 = EosKt.forcingEos((DataSource)sources.get(index), (Function0<Boolean>)((Function0)new Function0<Boolean>(this, type){
            final /* synthetic */ DefaultTranscodeEngine this$0;
            final /* synthetic */ TrackType $type;
            {
                this.this$0 = $receiver;
                this.$type = $type;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return ((Number)DefaultTranscodeEngine.access$getTimer$p(this.this$0).getPositionUs().get(this.$type)).longValue() > DefaultTranscodeEngine.access$getTimer$p(this.this$0).getTotalDurationUs() + 100L;
            }
        }));
        DataSink sink2 = EosKt.ignoringEos(this.dataSink, (Function0<Boolean>)((Function0)new Function0<Boolean>(index, (List<? extends DataSource>)sources){
            final /* synthetic */ int $index;
            final /* synthetic */ List<DataSource> $sources;
            {
                this.$index = $index;
                this.$sources = $sources;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$index < CollectionsKt.getLastIndex(this.$sources);
            }
        }));
        TrackStatus trackStatus = status;
        int n = WhenMappings.$EnumSwitchMapping$0[trackStatus.ordinal()];
        switch (n) {
            case 1: {
                pipeline = PipelinesKt.EmptyPipeline();
                break;
            }
            case 2: {
                pipeline = PipelinesKt.EmptyPipeline();
                break;
            }
            case 3: {
                pipeline = PipelinesKt.PassThroughPipeline(type, source2, sink2, interpolator2);
                break;
            }
            case 4: {
                pipeline = PipelinesKt.RegularPipeline(type, source2, sink2, interpolator2, outputFormat, this.codecs, this.videoRotation, this.audioStretcher, this.audioResampler);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pipeline;
    }

    @Override
    public boolean validate() {
        if (!this.validator.validate(this.tracks.getAll().getVideo(), this.tracks.getAll().getAudio())) {
            this.log.i("Validator has decided that the input is fine and transcoding is not necessary.");
            return false;
        }
        return true;
    }

    @Override
    public void transcode(@NotNull Function1<? super Double, Unit> progress2) {
        Intrinsics.checkNotNullParameter(progress2, (String)"progress");
        long loop = 0L;
        this.log.i("transcode(): about to start, durationUs=" + this.timer.getTotalDurationUs() + ", audioUs=" + this.timer.getDurationUs().audioOrNull() + ", videoUs=" + this.timer.getDurationUs().videoOrNull());
        while (true) {
            boolean bl;
            Segment audio = this.segments.next(TrackType.AUDIO);
            Segment video = this.segments.next(TrackType.VIDEO);
            Segment segment = audio;
            boolean bl2 = segment == null ? false : (bl = segment.advance());
            segment = video;
            boolean advanced = bl2 | (segment == null ? false : (bl = segment.advance()));
            boolean completed = !advanced && !this.segments.hasNext();
            this.log.v("transcode(): executed step=" + loop + " advanced=" + advanced + " completed=" + completed);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (completed) break;
            if (!advanced) {
                Thread.sleep(WAIT_MS);
            }
            if (++loop % PROGRESS_LOOPS != 0L) continue;
            double audioProgress = ((Number)this.timer.getProgress().getAudio()).doubleValue();
            double videoProgress = ((Number)this.timer.getProgress().getVideo()).doubleValue();
            this.log.v("transcode(): got progress, video=" + videoProgress + " audio=" + audioProgress);
            progress2.invoke((Object)((videoProgress + audioProgress) / (double)this.tracks.getActive().getSize()));
        }
        progress2.invoke((Object)1.0);
        this.dataSink.stop();
    }

    @Override
    public void cleanup() {
        boolean bl;
        Object object;
        DefaultTranscodeEngine defaultTranscodeEngine = this;
        boolean bl2 = false;
        try {
            object = Result.Companion;
            DefaultTranscodeEngine $this$cleanup_u24lambda_u2d0 = defaultTranscodeEngine;
            boolean bl3 = false;
            $this$cleanup_u24lambda_u2d0.segments.release();
            $this$cleanup_u24lambda_u2d0 = Unit.INSTANCE;
            bl3 = false;
            object = Result.constructor-impl((Object)$this$cleanup_u24lambda_u2d0);
        }
        catch (Throwable $this$cleanup_u24lambda_u2d0) {
            Result.Companion bl3 = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$cleanup_u24lambda_u2d0));
        }
        defaultTranscodeEngine = this;
        bl2 = false;
        try {
            object = Result.Companion;
            DefaultTranscodeEngine $this$cleanup_u24lambda_u2d1 = defaultTranscodeEngine;
            boolean bl4 = false;
            $this$cleanup_u24lambda_u2d1.dataSink.release();
            $this$cleanup_u24lambda_u2d1 = Unit.INSTANCE;
            bl4 = false;
            object = Result.constructor-impl((Object)$this$cleanup_u24lambda_u2d1);
        }
        catch (Throwable $this$cleanup_u24lambda_u2d1) {
            Result.Companion bl4 = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$cleanup_u24lambda_u2d1));
        }
        defaultTranscodeEngine = this;
        bl2 = false;
        try {
            object = Result.Companion;
            DefaultTranscodeEngine $this$cleanup_u24lambda_u2d2 = defaultTranscodeEngine;
            boolean bl5 = false;
            $this$cleanup_u24lambda_u2d2.dataSources.release();
            $this$cleanup_u24lambda_u2d2 = Unit.INSTANCE;
            bl5 = false;
            object = Result.constructor-impl((Object)$this$cleanup_u24lambda_u2d2);
        }
        catch (Throwable $this$cleanup_u24lambda_u2d2) {
            Result.Companion bl5 = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$cleanup_u24lambda_u2d2));
        }
        defaultTranscodeEngine = this;
        bl2 = false;
        try {
            object = Result.Companion;
            DefaultTranscodeEngine $this$cleanup_u24lambda_u2d3 = defaultTranscodeEngine;
            boolean bl6 = false;
            $this$cleanup_u24lambda_u2d3.codecs.release();
            Unit unit = Unit.INSTANCE;
            boolean bl7 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public static final /* synthetic */ Timer access$getTimer$p(DefaultTranscodeEngine $this) {
        return $this.timer;
    }

    public static final /* synthetic */ Pipeline access$createPipeline(DefaultTranscodeEngine $this, TrackType type, int index, TrackStatus status, MediaFormat outputFormat) {
        return $this.createPipeline(type, index, status, outputFormat);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/otaliastudios/transcoder/internal/transcode/DefaultTranscodeEngine$Companion;", "", "()V", "PROGRESS_LOOPS", "", "WAIT_MS", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackStatus.values().length];
            nArray[TrackStatus.ABSENT.ordinal()] = 1;
            nArray[TrackStatus.REMOVING.ordinal()] = 2;
            nArray[TrackStatus.PASS_THROUGH.ordinal()] = 3;
            nArray[TrackStatus.COMPRESSING.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

