/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.thumbnails;

import android.graphics.Bitmap;
import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.Segment;
import com.otaliastudios.transcoder.internal.Segments;
import com.otaliastudios.transcoder.internal.Timer;
import com.otaliastudios.transcoder.internal.Tracks;
import com.otaliastudios.transcoder.internal.codec.Decoder;
import com.otaliastudios.transcoder.internal.data.Reader;
import com.otaliastudios.transcoder.internal.data.Seeker;
import com.otaliastudios.transcoder.internal.pipeline.Channel;
import com.otaliastudios.transcoder.internal.pipeline.Pipeline;
import com.otaliastudios.transcoder.internal.pipeline.PipelineKt;
import com.otaliastudios.transcoder.internal.pipeline.PipelinesKt;
import com.otaliastudios.transcoder.internal.thumbnails.DefaultThumbnailsEngine;
import com.otaliastudios.transcoder.internal.thumbnails.ThumbnailsEngine;
import com.otaliastudios.transcoder.internal.utils.EosKt;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.internal.video.VideoRenderer;
import com.otaliastudios.transcoder.internal.video.VideoSnapshots;
import com.otaliastudios.transcoder.resize.Resizer;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.strategy.DefaultVideoStrategy;
import com.otaliastudios.transcoder.strategy.RemoveTrackStrategy;
import com.otaliastudios.transcoder.thumbnail.Thumbnail;
import com.otaliastudios.transcoder.thumbnail.ThumbnailRequest;
import com.otaliastudios.transcoder.time.DefaultTimeInterpolator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 &2\u00020\u0001:\u0002&'B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u0014H\u0016J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u0010%\u001a\u00020\u00142\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/otaliastudios/transcoder/internal/thumbnails/DefaultThumbnailsEngine;", "Lcom/otaliastudios/transcoder/internal/thumbnails/ThumbnailsEngine;", "dataSources", "Lcom/otaliastudios/transcoder/internal/DataSources;", "rotation", "", "resizer", "Lcom/otaliastudios/transcoder/resize/Resizer;", "requests", "", "Lcom/otaliastudios/transcoder/thumbnail/ThumbnailRequest;", "(Lcom/otaliastudios/transcoder/internal/DataSources;ILcom/otaliastudios/transcoder/resize/Resizer;Ljava/util/List;)V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "positions", "Lkotlin/Pair;", "", "progress", "Lkotlin/Function1;", "Lcom/otaliastudios/transcoder/thumbnail/Thumbnail;", "", "segments", "Lcom/otaliastudios/transcoder/internal/Segments;", "timer", "Lcom/otaliastudios/transcoder/internal/Timer;", "tracks", "Lcom/otaliastudios/transcoder/internal/Tracks;", "cleanup", "createPipeline", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "index", "status", "Lcom/otaliastudios/transcoder/common/TrackStatus;", "outputFormat", "Landroid/media/MediaFormat;", "thumbnails", "Companion", "Stub", "lib_release"})
public final class DefaultThumbnailsEngine
extends ThumbnailsEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataSources dataSources;
    private final int rotation;
    @NotNull
    private final Logger log;
    @NotNull
    private final Tracks tracks;
    @NotNull
    private final Segments segments;
    @NotNull
    private final Timer timer;
    @NotNull
    private final List<Pair<Long, ThumbnailRequest>> positions;
    private Function1<? super Thumbnail, Unit> progress;
    private static final long WAIT_MS = 10L;
    private static final long PROGRESS_LOOPS = 10L;

    /*
     * WARNING - void declaration
     */
    public DefaultThumbnailsEngine(@NotNull DataSources dataSources, int rotation, @NotNull Resizer resizer, @NotNull List<? extends ThumbnailRequest> requests) {
        void $this$sortedBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)dataSources, (String)"dataSources");
        Intrinsics.checkNotNullParameter((Object)resizer, (String)"resizer");
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        this.dataSources = dataSources;
        this.rotation = rotation;
        this.log = new Logger("ThumbnailsEngine");
        this.tracks = new Tracks(TrackMapKt.trackMapOf(new DefaultVideoStrategy.Builder().frameRate(120).addResizer(resizer).build(), new RemoveTrackStrategy()), this.dataSources, this.rotation, true);
        this.segments = new Segments(this.dataSources, this.tracks, (Function4<? super TrackType, ? super Integer, ? super TrackStatus, ? super MediaFormat, Pipeline>)((Function4)new Function4<TrackType, Integer, TrackStatus, MediaFormat, Pipeline>((Object)this){

            @NotNull
            public final Pipeline invoke(@NotNull TrackType p0, int p1, @NotNull TrackStatus p2, @NotNull MediaFormat p3) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                Intrinsics.checkNotNullParameter((Object)((Object)p2), (String)"p2");
                Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
                return DefaultThumbnailsEngine.access$createPipeline((DefaultThumbnailsEngine)this.receiver, p0, p1, p2, p3);
            }
        }));
        this.timer = new Timer(new DefaultTimeInterpolator(), this.dataSources, this.tracks, (TrackMap<Integer>)this.segments.getCurrentIndex());
        this.log.i("Created Tracks, Segments, Timer...");
        Iterable iterable = requests;
        DefaultThumbnailsEngine defaultThumbnailsEngine = this;
        boolean $i$f$flatMap = false;
        void var7_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            ThumbnailRequest request = (ThumbnailRequest)element$iv$iv;
            boolean bl = false;
            long duration = this.timer.getTotalDurationUs();
            Iterable $this$map$iv = request.locate(duration);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)((long)it), (Object)request);
                collection.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        $this$flatMap$iv = list;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        defaultThumbnailsEngine.positions = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)a;
                boolean bl2 = false;
                Comparable comparable = (Long)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = (Long)it.getFirst();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Pipeline createPipeline(TrackType type, int index, TrackStatus status, MediaFormat outputFormat) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        this.log.i("Creating pipeline #" + index + ". absoluteUs=" + CollectionsKt.joinToString$default((Iterable)this.positions, null, null, null, (int)0, null, (Function1)createPipeline.1.INSTANCE, (int)31, null));
        Iterable $this$mapNotNull$iv = this.positions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Stub stub;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair $dstr$positionUs$request = (Pair)element$iv$iv;
            boolean bl2 = false;
            long positionUs2 = ((Number)$dstr$positionUs$request.component1()).longValue();
            ThumbnailRequest request = (ThumbnailRequest)$dstr$positionUs$request.component2();
            Long localizedUs = this.timer.localize(type, index, positionUs2);
            Long l = localizedUs;
            if (l == null) {
                stub = null;
            } else {
                Long l2 = l;
                boolean bl3 = false;
                boolean bl4 = false;
                long it = ((Number)l2).longValue();
                boolean bl5 = false;
                stub = new Stub(request, positionUs2, localizedUs);
            }
            if (stub == null) continue;
            Stub stub2 = stub;
            boolean bl6 = false;
            boolean bl7 = false;
            Stub it$iv$iv = stub2;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List stubs = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (stubs.isEmpty()) {
            return PipelinesKt.EmptyPipeline();
        }
        DataSource source2 = EosKt.forcingEos((DataSource)this.dataSources.get(type).get(index), (Function0<Boolean>)((Function0)new Function0<Boolean>((List<Stub>)stubs){
            final /* synthetic */ List<Stub> $stubs;
            {
                this.$stubs = $stubs;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$stubs.isEmpty();
            }
        }));
        Iterable $this$map$iv = stubs;
        boolean $i$f$map = false;
        Iterable $i$f$mapNotNullTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv = (Stub)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            Long l = it.getLocalizedUs();
            collection.add(l);
        }
        List positions = (List)destination$iv$iv2;
        this.log.i("Requests for step #" + index + ": " + CollectionsKt.joinToString$default((Iterable)positions, null, null, null, (int)0, null, null, (int)63, null) + " [duration=" + source2.getDurationUs() + ']');
        return Pipeline.Companion.build$lib_release("Thumbnails", (Function0)new Function0<Pipeline.Builder<?, Channel>>(source2, positions, type, this, outputFormat, stubs){
            final /* synthetic */ DataSource $source;
            final /* synthetic */ List<Long> $positions;
            final /* synthetic */ TrackType $type;
            final /* synthetic */ DefaultThumbnailsEngine this$0;
            final /* synthetic */ MediaFormat $outputFormat;
            final /* synthetic */ List<Stub> $stubs;
            {
                this.$source = $source;
                this.$positions = $positions;
                this.$type = $type;
                this.this$0 = $receiver;
                this.$outputFormat = $outputFormat;
                this.$stubs = $stubs;
                super(0);
            }

            @NotNull
            public final Pipeline.Builder<?, Channel> invoke() {
                Pipeline.Builder<NewData, NewChannel> builder = PipelineKt.plus(new Seeker(this.$source, this.$positions, (Function1<? super Long, Boolean>)((Function1)new Function1<Long, Boolean>(this.$stubs){
                    final /* synthetic */ List<Stub> $stubs;
                    {
                        this.$stubs = $stubs;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(long it) {
                        Stub stub = (Stub)CollectionsKt.firstOrNull(this.$stubs);
                        return stub == null ? false : it == stub.getLocalizedUs();
                    }
                })), new Reader(this.$source, this.$type));
                MediaFormat mediaFormat = this.$source.getTrackFormat(this.$type);
                Intrinsics.checkNotNull((Object)mediaFormat);
                MediaFormat mediaFormat2 = mediaFormat;
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat2, (String)"source.getTrackFormat(type)!!");
                return builder.plus(new Decoder(mediaFormat2, false)).plus(new VideoRenderer(this.$source.getOrientation(), DefaultThumbnailsEngine.access$getRotation$p(this.this$0), this.$outputFormat, true)).plus(new VideoSnapshots(this.$outputFormat, this.$positions, 50000L, (Function2<? super Long, ? super Bitmap, Unit>)((Function2)new Function2<Long, Bitmap, Unit>(this.$stubs, this.this$0){
                    final /* synthetic */ List<Stub> $stubs;
                    final /* synthetic */ DefaultThumbnailsEngine this$0;
                    {
                        this.$stubs = $stubs;
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(long pos, @NotNull Bitmap bitmap) {
                        Function1 function1;
                        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                        Stub stub = (Stub)CollectionsKt.removeFirst(this.$stubs);
                        stub.setActualLocalizedUs(pos);
                        DefaultThumbnailsEngine.access$getLog$p(this.this$0).i("Got snapshot. positionUs=" + stub.getPositionUs() + " localizedUs=" + stub.getLocalizedUs() + " actualLocalizedUs=" + stub.getActualLocalizedUs() + " deltaUs=" + (stub.getLocalizedUs() - stub.getActualLocalizedUs()));
                        Thumbnail thumbnail = new Thumbnail(stub.getRequest(), stub.getPositionUs(), bitmap);
                        Function1 function12 = DefaultThumbnailsEngine.access$getProgress$p(this.this$0);
                        if (function12 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"progress");
                            function1 = null;
                        } else {
                            function1 = function12;
                        }
                        function1.invoke((Object)thumbnail);
                    }
                })));
            }
        });
    }

    @Override
    public void thumbnails(@NotNull Function1<? super Thumbnail, Unit> progress2) {
        Intrinsics.checkNotNullParameter(progress2, (String)"progress");
        this.progress = progress2;
        while (true) {
            boolean completed;
            boolean bl;
            Segment segment;
            boolean advanced = (segment = this.segments.next(TrackType.VIDEO)) == null ? false : (bl = segment.advance());
            boolean bl2 = completed = !advanced && !this.segments.hasNext();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (completed) break;
            if (advanced) continue;
            Thread.sleep(WAIT_MS);
        }
    }

    @Override
    public void cleanup() {
        boolean bl;
        Object object;
        DefaultThumbnailsEngine defaultThumbnailsEngine = this;
        boolean bl2 = false;
        try {
            object = Result.Companion;
            DefaultThumbnailsEngine $this$cleanup_u24lambda_u2d6 = defaultThumbnailsEngine;
            boolean bl3 = false;
            $this$cleanup_u24lambda_u2d6.segments.release();
            $this$cleanup_u24lambda_u2d6 = Unit.INSTANCE;
            bl3 = false;
            object = Result.constructor-impl((Object)$this$cleanup_u24lambda_u2d6);
        }
        catch (Throwable $this$cleanup_u24lambda_u2d6) {
            Result.Companion bl3 = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$cleanup_u24lambda_u2d6));
        }
        defaultThumbnailsEngine = this;
        bl2 = false;
        try {
            object = Result.Companion;
            DefaultThumbnailsEngine $this$cleanup_u24lambda_u2d7 = defaultThumbnailsEngine;
            boolean bl4 = false;
            $this$cleanup_u24lambda_u2d7.dataSources.release();
            Unit unit = Unit.INSTANCE;
            boolean bl5 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    public static final /* synthetic */ int access$getRotation$p(DefaultThumbnailsEngine $this) {
        return $this.rotation;
    }

    public static final /* synthetic */ Logger access$getLog$p(DefaultThumbnailsEngine $this) {
        return $this.log;
    }

    public static final /* synthetic */ Function1 access$getProgress$p(DefaultThumbnailsEngine $this) {
        return $this.progress;
    }

    public static final /* synthetic */ Pipeline access$createPipeline(DefaultThumbnailsEngine $this, TrackType type, int index, TrackStatus status, MediaFormat outputFormat) {
        return $this.createPipeline(type, index, status, outputFormat);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/otaliastudios/transcoder/internal/thumbnails/DefaultThumbnailsEngine$Stub;", "", "request", "Lcom/otaliastudios/transcoder/thumbnail/ThumbnailRequest;", "positionUs", "", "localizedUs", "(Lcom/otaliastudios/transcoder/thumbnail/ThumbnailRequest;JJ)V", "actualLocalizedUs", "getActualLocalizedUs", "()J", "setActualLocalizedUs", "(J)V", "getLocalizedUs", "getPositionUs", "getRequest", "()Lcom/otaliastudios/transcoder/thumbnail/ThumbnailRequest;", "lib_release"})
    private static final class Stub {
        @NotNull
        private final ThumbnailRequest request;
        private final long positionUs;
        private final long localizedUs;
        private long actualLocalizedUs;

        public Stub(@NotNull ThumbnailRequest request, long positionUs2, long localizedUs) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.request = request;
            this.positionUs = positionUs2;
            this.actualLocalizedUs = this.localizedUs = localizedUs;
        }

        @NotNull
        public final ThumbnailRequest getRequest() {
            return this.request;
        }

        public final long getPositionUs() {
            return this.positionUs;
        }

        public final long getLocalizedUs() {
            return this.localizedUs;
        }

        public final long getActualLocalizedUs() {
            return this.actualLocalizedUs;
        }

        public final void setActualLocalizedUs(long l) {
            this.actualLocalizedUs = l;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/otaliastudios/transcoder/internal/thumbnails/DefaultThumbnailsEngine$Companion;", "", "()V", "PROGRESS_LOOPS", "", "WAIT_MS", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

