/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.codec;

import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.codec.DecoderChannel;
import com.otaliastudios.transcoder.internal.codec.DecoderData;
import com.otaliastudios.transcoder.internal.codec.DecoderTimerData;
import com.otaliastudios.transcoder.internal.pipeline.DataStep;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.time.TimeInterpolator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/otaliastudios/transcoder/internal/codec/DecoderTimer;", "Lcom/otaliastudios/transcoder/internal/pipeline/DataStep;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderData;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderChannel;", "track", "Lcom/otaliastudios/transcoder/common/TrackType;", "interpolator", "Lcom/otaliastudios/transcoder/time/TimeInterpolator;", "(Lcom/otaliastudios/transcoder/common/TrackType;Lcom/otaliastudios/transcoder/time/TimeInterpolator;)V", "lastRawTimeUs", "", "Ljava/lang/Long;", "lastTimeUs", "step", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "state", "Lcom/otaliastudios/transcoder/internal/pipeline/State$Ok;", "fresh", "", "lib_release"})
public final class DecoderTimer
extends DataStep<DecoderData, DecoderChannel> {
    @NotNull
    private final TrackType track;
    @NotNull
    private final TimeInterpolator interpolator;
    @Nullable
    private Long lastTimeUs;
    @Nullable
    private Long lastRawTimeUs;

    public DecoderTimer(@NotNull TrackType track, @NotNull TimeInterpolator interpolator2) {
        Intrinsics.checkNotNullParameter((Object)((Object)track), (String)"track");
        Intrinsics.checkNotNullParameter((Object)interpolator2, (String)"interpolator");
        this.track = track;
        this.interpolator = interpolator2;
    }

    @Override
    @NotNull
    public State<DecoderData> step(@NotNull State.Ok<DecoderData> state, boolean fresh) {
        double d;
        Intrinsics.checkNotNullParameter(state, (String)"state");
        if (state instanceof State.Eos) {
            return state;
        }
        boolean bl = !(state.getValue() instanceof DecoderTimerData);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Can't apply DecoderTimer twice.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long rawTimeUs = state.getValue().getTimeUs();
        long timeUs = this.interpolator.interpolate(this.track, rawTimeUs);
        if (this.lastTimeUs == null) {
            d = 1.0;
        } else {
            Long l = this.lastTimeUs;
            Intrinsics.checkNotNull((Object)l);
            long durationUs2 = timeUs - l;
            Long l2 = this.lastRawTimeUs;
            Intrinsics.checkNotNull((Object)l2);
            long rawDurationUs = rawTimeUs - l2;
            d = (double)durationUs2 / (double)rawDurationUs;
        }
        double timeStretch = d;
        this.lastTimeUs = timeUs;
        this.lastRawTimeUs = rawTimeUs;
        return new State.Ok<DecoderTimerData>(new DecoderTimerData(state.getValue().getBuffer(), rawTimeUs, timeUs, timeStretch, state.getValue().getRelease()));
    }
}

