/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.media.MediaFormatProvider;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.strategy.TrackStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J4\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\r0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eH\u0002J \u0010 \u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\bH\u0002R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/otaliastudios/transcoder/internal/Tracks;", "", "strategies", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "Lcom/otaliastudios/transcoder/strategy/TrackStrategy;", "sources", "Lcom/otaliastudios/transcoder/internal/DataSources;", "videoRotation", "", "forceCompression", "", "(Lcom/otaliastudios/transcoder/internal/utils/TrackMap;Lcom/otaliastudios/transcoder/internal/DataSources;IZ)V", "active", "Lcom/otaliastudios/transcoder/common/TrackStatus;", "getActive", "()Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "all", "getAll", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "outputFormats", "Landroid/media/MediaFormat;", "getOutputFormats", "resolveAudioStatus", "status", "resolveTrack", "Lkotlin/Pair;", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "strategy", "", "Lcom/otaliastudios/transcoder/source/DataSource;", "resolveVideoStatus", "rotation", "lib_release"})
public final class Tracks {
    @NotNull
    private final Logger log;
    @NotNull
    private final TrackMap<TrackStatus> all;
    @NotNull
    private final TrackMap<MediaFormat> outputFormats;
    @NotNull
    private final TrackMap<TrackStatus> active;

    public Tracks(@NotNull TrackMap<TrackStrategy> strategies, @NotNull DataSources sources, int videoRotation, boolean forceCompression) {
        TrackStatus it;
        Intrinsics.checkNotNullParameter(strategies, (String)"strategies");
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        this.log = new Logger("Tracks");
        Object object = this.resolveTrack(TrackType.AUDIO, strategies.getAudio(), (List)sources.audioOrNull());
        MediaFormat audioFormat = (MediaFormat)object.component1();
        TrackStatus audioStatus = (TrackStatus)((Object)object.component2());
        Object object2 = this.resolveTrack(TrackType.VIDEO, strategies.getVideo(), (List)sources.videoOrNull());
        MediaFormat videoFormat = (MediaFormat)object2.component1();
        TrackStatus videoStatus = (TrackStatus)((Object)object2.component2());
        this.all = TrackMapKt.trackMapOf(this.resolveVideoStatus(videoStatus, forceCompression, videoRotation), this.resolveAudioStatus(audioStatus, forceCompression));
        this.outputFormats = TrackMapKt.trackMapOf(videoFormat, audioFormat);
        this.log.i("init: videoStatus=" + (Object)((Object)videoStatus) + ", resolvedVideoStatus=" + (Object)((Object)this.all.getVideo()) + ", videoFormat=" + videoFormat);
        this.log.i("init: audioStatus=" + (Object)((Object)audioStatus) + ", resolvedAudioStatus=" + (Object)((Object)this.all.getAudio()) + ", audioFormat=" + audioFormat);
        object = this.all.getVideo();
        boolean bl = false;
        boolean bl2 = false;
        object2 = (TrackStatus)((Object)object);
        Tracks tracks = this;
        boolean bl3 = false;
        boolean bl4 = it.isTranscoding();
        Object object3 = bl4 ? object : null;
        object = this.all.getAudio();
        bl = false;
        bl2 = false;
        it = (TrackStatus)((Object)object);
        Object object4 = object3;
        boolean bl5 = false;
        boolean bl6 = it.isTranscoding();
        tracks.active = TrackMapKt.trackMapOf(object4, bl6 ? object : null);
    }

    @NotNull
    public final TrackMap<TrackStatus> getAll() {
        return this.all;
    }

    @NotNull
    public final TrackMap<MediaFormat> getOutputFormats() {
        return this.outputFormats;
    }

    @NotNull
    public final TrackMap<TrackStatus> getActive() {
        return this.active;
    }

    private final TrackStatus resolveVideoStatus(TrackStatus status, boolean forceCompression, int rotation) {
        boolean force = forceCompression || rotation != 0;
        boolean canForce = status == TrackStatus.PASS_THROUGH;
        return canForce && force ? TrackStatus.COMPRESSING : status;
    }

    private final TrackStatus resolveAudioStatus(TrackStatus status, boolean forceCompression) {
        boolean force = forceCompression;
        boolean canForce = status == TrackStatus.PASS_THROUGH;
        return canForce && force ? TrackStatus.COMPRESSING : status;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<MediaFormat, TrackStatus> resolveTrack(TrackType type, TrackStrategy strategy, List<? extends DataSource> sources) {
        Pair pair;
        void $this$mapNotNullTo$iv$iv;
        List<? extends DataSource> list;
        this.log.i("resolveTrack(" + (Object)((Object)type) + "), sources=" + ((list = sources) == null ? null : Integer.valueOf(list.size())) + ", strategy=" + Reflection.getOrCreateKotlinClass(strategy.getClass()).getSimpleName());
        if (sources == null) {
            return TuplesKt.to((Object)new MediaFormat(), (Object)((Object)TrackStatus.ABSENT));
        }
        MediaFormatProvider provider = new MediaFormatProvider();
        Iterable $this$mapNotNull$iv = sources;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MediaFormat mediaFormat;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataSource it = (DataSource)element$iv$iv;
            boolean bl2 = false;
            MediaFormat mediaFormat2 = it.getTrackFormat(type);
            if (mediaFormat2 == null) {
                mediaFormat = null;
            } else {
                MediaFormat mediaFormat3;
                MediaFormat format = mediaFormat3 = mediaFormat2;
                mediaFormat = provider.provideMediaFormat(it, type, format);
            }
            if (mediaFormat == null) continue;
            MediaFormat mediaFormat4 = mediaFormat;
            boolean bl3 = false;
            boolean bl4 = false;
            MediaFormat it$iv$iv = mediaFormat4;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List inputs = (List)destination$iv$iv;
        int n = inputs.size();
        if (n == 0) {
            pair = TuplesKt.to((Object)new MediaFormat(), (Object)((Object)TrackStatus.ABSENT));
        } else if (n == sources.size()) {
            MediaFormat output = new MediaFormat();
            TrackStatus trackStatus = strategy.createOutputFormat(inputs, output);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)trackStatus), (String)"strategy.createOutputFormat(inputs, output)");
            TrackStatus status = trackStatus;
            pair = TuplesKt.to((Object)output, (Object)((Object)status));
        } else {
            String string = "Of all " + (Object)((Object)type) + " sources, some have a " + (Object)((Object)type) + " track, some don't.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return pair;
    }
}

