/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import com.otaliastudios.transcoder.ThumbnailerOptions;
import com.otaliastudios.transcoder.TranscoderOptions;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.source.BlankAudioDataSource;
import com.otaliastudios.transcoder.source.DataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0002\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0002\u0010\u000bJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\f\u0010\u0018\u001a\u00020\u0017*\u00020\u0003H\u0002J\u0012\u0010\u0018\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\f\u0010\u0019\u001a\u00020\u0017*\u00020\u0003H\u0002J\u0012\u0010\u0019\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/otaliastudios/transcoder/internal/DataSources;", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "", "Lcom/otaliastudios/transcoder/source/DataSource;", "options", "Lcom/otaliastudios/transcoder/TranscoderOptions;", "(Lcom/otaliastudios/transcoder/TranscoderOptions;)V", "Lcom/otaliastudios/transcoder/ThumbnailerOptions;", "(Lcom/otaliastudios/transcoder/ThumbnailerOptions;)V", "videoSources", "audioSources", "(Ljava/util/List;Ljava/util/List;)V", "discarded", "", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "all", "get", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "has", "", "release", "", "deinit", "init", "lib_release"})
public final class DataSources
implements TrackMap<List<? extends DataSource>> {
    @NotNull
    private final Logger log;
    @NotNull
    private final List<DataSource> discarded;
    @NotNull
    private final List<DataSource> videoSources;
    @NotNull
    private final List<DataSource> audioSources;

    /*
     * WARNING - void declaration
     */
    private DataSources(List<? extends DataSource> videoSources, List<? extends DataSource> audioSources) {
        List list;
        void $this$audioSources_u24lambda_u2d9;
        int n;
        List list2;
        boolean bl;
        Collection collection;
        DataSources $this$videoSources_u24lambda_u2d4;
        List it;
        int valid;
        int count$iv;
        int n2;
        this.log = new Logger("DataSources");
        this.log.i("initializing videoSources...");
        this.init(videoSources);
        this.log.i("initializing audioSources...");
        this.init(audioSources);
        boolean bl2 = false;
        this.discarded = new ArrayList();
        DataSources dataSources = this;
        boolean bl3 = false;
        boolean bl4 = false;
        DataSources dataSources2 = dataSources;
        DataSources dataSources3 = this;
        boolean bl5 = false;
        Iterable $this$count$iv22 = videoSources;
        boolean $i$f$count2 = false;
        if ($this$count$iv22 instanceof Collection && ((Collection)$this$count$iv22).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv22) {
                DataSource it22 = (DataSource)element$iv;
                boolean bl6 = false;
                if (!(it22.getTrackFormat(TrackType.VIDEO) != null)) continue;
                int it22 = ++count$iv;
                bl6 = false;
                if (it22 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int $this$count$iv22 = valid = n2;
        if ($this$count$iv22 == 0) {
            $i$f$count2 = false;
            List $i$f$count2 = CollectionsKt.emptyList();
            count$iv = 0;
            boolean bl7 = false;
            it = $i$f$count2;
            boolean bl8 = false;
            void bl6 = $this$videoSources_u24lambda_u2d4;
            collection = bl6.discarded;
            bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)videoSources);
            list2 = $i$f$count2;
        } else {
            list2 = $this$count$iv22 == videoSources.size() ? videoSources : videoSources;
        }
        List list3 = list2;
        dataSources3.videoSources = list3;
        dataSources = this;
        bl3 = false;
        bl4 = false;
        $this$videoSources_u24lambda_u2d4 = dataSources;
        dataSources3 = this;
        boolean bl9 = false;
        Iterable $this$count$iv = audioSources;
        boolean $i$f$count32 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                DataSource it32 = (DataSource)element$iv;
                boolean bl10 = false;
                if (!(it32.getTrackFormat(TrackType.AUDIO) != null)) continue;
                int it32 = ++count$iv;
                boolean bl11 = false;
                if (it32 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        valid = n;
        $this$audioSources_u24lambda_u2d9.log.i(Intrinsics.stringPlus((String)"computing audioSources, valid=", (Object)valid));
        int n3 = valid;
        if (n3 == 0) {
            $i$f$count32 = false;
            List $i$f$count32 = CollectionsKt.emptyList();
            count$iv = 0;
            boolean bl12 = false;
            it = $i$f$count32;
            boolean bl13 = false;
            void var14_37 = $this$audioSources_u24lambda_u2d9;
            collection = var14_37.discarded;
            bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)audioSources);
            list = $i$f$count32;
        } else if (n3 == audioSources.size()) {
            list = audioSources;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = audioSources;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DataSource dataSource;
                void source2;
                DataSource dataSource2 = (DataSource)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl14 = false;
                if (source2.getTrackFormat(TrackType.AUDIO) != null) {
                    dataSource = source2;
                } else {
                    BlankAudioDataSource blankAudioDataSource = new BlankAudioDataSource(source2.getDurationUs());
                    boolean bl15 = false;
                    boolean bl16 = false;
                    BlankAudioDataSource it2 = blankAudioDataSource;
                    boolean bl17 = false;
                    void var25_51 = $this$audioSources_u24lambda_u2d9;
                    Collection collection3 = var25_51.discarded;
                    boolean bl18 = false;
                    collection3.add(source2);
                    dataSource = blankAudioDataSource;
                }
                void var28_54 = dataSource;
                collection2.add(var28_54);
            }
            list = (List)destination$iv$iv;
        }
        list3 = list;
        dataSources3.audioSources = list3;
    }

    public DataSources(@NotNull TranscoderOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        List<DataSource> list = options.getVideoDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"options.videoDataSources");
        List<DataSource> list2 = list;
        list = options.getAudioDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"options.audioDataSources");
        this(list2, list);
    }

    public DataSources(@NotNull ThumbnailerOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        boolean bl = false;
        this(options.getDataSources(), CollectionsKt.emptyList());
    }

    private final void init(DataSource $this$init) {
        if (!$this$init.isInitialized()) {
            $this$init.initialize();
        }
    }

    private final void deinit(DataSource $this$deinit) {
        if ($this$deinit.isInitialized()) {
            $this$deinit.deinitialize();
        }
    }

    private final void init(List<? extends DataSource> $this$init) {
        Iterable $this$forEach$iv = $this$init;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataSource it = (DataSource)element$iv;
            boolean bl = false;
            this.log.i("initializing " + it + "... (isInit=" + it.isInitialized() + ')');
            this.init(it);
        }
    }

    private final void deinit(List<? extends DataSource> $this$deinit) {
        Iterable $this$forEach$iv = $this$deinit;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataSource it = (DataSource)element$iv;
            boolean bl = false;
            this.log.i("deinitializing " + it + "... (isInit=" + it.isInitialized() + ')');
            this.deinit(it);
        }
    }

    @Override
    @NotNull
    public List<DataSource> get(@NotNull TrackType type) {
        List<DataSource> list;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        TrackType trackType = type;
        int n = WhenMappings.$EnumSwitchMapping$0[trackType.ordinal()];
        switch (n) {
            case 1: {
                list = this.audioSources;
                break;
            }
            case 2: {
                list = this.videoSources;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    @Override
    public boolean has(@NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Collection collection = (Collection)this.get(type);
        boolean bl = false;
        return !collection.isEmpty();
    }

    @NotNull
    public final List<DataSource> all() {
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)((Collection)this.getAudio()), (Iterable)((Iterable)this.getVideo())));
    }

    public final void release() {
        this.log.i("release(): releasing...");
        this.deinit((List)this.getVideo());
        this.deinit((List)this.getAudio());
        this.deinit(this.discarded);
        this.log.i("release(): released.");
    }

    @Override
    @Nullable
    public List<DataSource> audioOrNull() {
        return TrackMap.DefaultImpls.audioOrNull(this);
    }

    @Override
    @Nullable
    public List<DataSource> getOrNull(@NotNull TrackType type) {
        return TrackMap.DefaultImpls.getOrNull(this, type);
    }

    @Override
    @NotNull
    public Iterator<List<DataSource>> iterator() {
        return TrackMap.DefaultImpls.iterator(this);
    }

    @Override
    @Nullable
    public List<DataSource> videoOrNull() {
        return TrackMap.DefaultImpls.videoOrNull(this);
    }

    @Override
    @NotNull
    public List<DataSource> getAudio() {
        return TrackMap.DefaultImpls.getAudio(this);
    }

    @Override
    public boolean getHasAudio() {
        return TrackMap.DefaultImpls.getHasAudio(this);
    }

    @Override
    public boolean getHasVideo() {
        return TrackMap.DefaultImpls.getHasVideo(this);
    }

    @Override
    public int getSize() {
        return TrackMap.DefaultImpls.getSize(this);
    }

    @Override
    @NotNull
    public List<DataSource> getVideo() {
        return TrackMap.DefaultImpls.getVideo(this);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackType.values().length];
            nArray[TrackType.AUDIO.ordinal()] = 1;
            nArray[TrackType.VIDEO.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

