/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.Codecs;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.Tracks;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\n\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/otaliastudios/transcoder/internal/Codecs;", "", "sources", "Lcom/otaliastudios/transcoder/internal/DataSources;", "tracks", "Lcom/otaliastudios/transcoder/internal/Tracks;", "current", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "", "(Lcom/otaliastudios/transcoder/internal/DataSources;Lcom/otaliastudios/transcoder/internal/Tracks;Lcom/otaliastudios/transcoder/internal/utils/TrackMap;)V", "encoders", "Lkotlin/Pair;", "Landroid/media/MediaCodec;", "Landroid/view/Surface;", "getEncoders", "()Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "ownsEncoderStart", "", "getOwnsEncoderStart", "ownsEncoderStop", "getOwnsEncoderStop", "release", "", "lib_release"})
public final class Codecs {
    @NotNull
    private final DataSources sources;
    @NotNull
    private final Tracks tracks;
    @NotNull
    private final TrackMap<Integer> current;
    @NotNull
    private final Logger log;
    @NotNull
    private final TrackMap<Pair<MediaCodec, Surface>> encoders;
    @NotNull
    private final TrackMap<Boolean> ownsEncoderStart;
    @NotNull
    private final TrackMap<Boolean> ownsEncoderStop;

    public Codecs(@NotNull DataSources sources, @NotNull Tracks tracks, @NotNull TrackMap<Integer> current) {
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)tracks, (String)"tracks");
        Intrinsics.checkNotNullParameter(current, (String)"current");
        this.sources = sources;
        this.tracks = tracks;
        this.current = current;
        this.log = new Logger("Codecs");
        this.encoders = new TrackMap<Pair<? extends MediaCodec, ? extends Surface>>(this){
            @NotNull
            private final Lazy lazyAudio$delegate;
            @NotNull
            private final Lazy lazyVideo$delegate;
            final /* synthetic */ Codecs this$0;
            {
                this.this$0 = $receiver;
                this.lazyAudio$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pair>(this.this$0){
                    final /* synthetic */ Codecs this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Pair invoke() {
                        MediaFormat format = Codecs.access$getTracks$p(this.this$0).getOutputFormats().getAudio();
                        String string = format.getString("mime");
                        Intrinsics.checkNotNull((Object)string);
                        MediaCodec mediaCodec = MediaCodec.createEncoderByType((String)string);
                        Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"createEncoderByType(form\u2026(MediaFormat.KEY_MIME)!!)");
                        MediaCodec codec = mediaCodec;
                        codec.configure(format, null, null, 1);
                        return TuplesKt.to((Object)codec, null);
                    }
                }));
                this.lazyVideo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Pair<? extends MediaCodec, ? extends Surface>>(this.this$0){
                    final /* synthetic */ Codecs this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Pair<MediaCodec, Surface> invoke() {
                        MediaFormat format = Codecs.access$getTracks$p(this.this$0).getOutputFormats().getVideo();
                        String string = format.getString("mime");
                        Intrinsics.checkNotNull((Object)string);
                        MediaCodec mediaCodec = MediaCodec.createEncoderByType((String)string);
                        Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"createEncoderByType(form\u2026(MediaFormat.KEY_MIME)!!)");
                        MediaCodec codec = mediaCodec;
                        codec.configure(format, null, null, 1);
                        return TuplesKt.to((Object)codec, (Object)codec.createInputSurface());
                    }
                }));
            }

            public boolean has(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return Codecs.access$getTracks$p(this.this$0).getAll().get(type) == TrackStatus.COMPRESSING;
            }

            private final Pair getLazyAudio() {
                Lazy lazy = this.lazyAudio$delegate;
                Object var2_2 = null;
                boolean bl = false;
                return (Pair)lazy.getValue();
            }

            private final Pair<MediaCodec, Surface> getLazyVideo() {
                Lazy lazy = this.lazyVideo$delegate;
                Object var2_2 = null;
                boolean bl = false;
                return (Pair)lazy.getValue();
            }

            @NotNull
            public Pair<MediaCodec, Surface> get(@NotNull TrackType type) {
                Pair<MediaCodec, Surface> pair;
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                TrackType trackType = type;
                int n = encoders.WhenMappings.$EnumSwitchMapping$0[trackType.ordinal()];
                switch (n) {
                    case 1: {
                        pair = this.getLazyAudio();
                        break;
                    }
                    case 2: {
                        pair = this.getLazyVideo();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return pair;
            }

            @Nullable
            public Pair<MediaCodec, Surface> audioOrNull() {
                return TrackMap.DefaultImpls.audioOrNull(this);
            }

            @Nullable
            public Pair<MediaCodec, Surface> getOrNull(@NotNull TrackType type) {
                return TrackMap.DefaultImpls.getOrNull(this, type);
            }

            @NotNull
            public Iterator<Pair<MediaCodec, Surface>> iterator() {
                return TrackMap.DefaultImpls.iterator(this);
            }

            @Nullable
            public Pair<MediaCodec, Surface> videoOrNull() {
                return TrackMap.DefaultImpls.videoOrNull(this);
            }

            @NotNull
            public Pair<MediaCodec, Surface> getAudio() {
                return TrackMap.DefaultImpls.getAudio(this);
            }

            public boolean getHasAudio() {
                return TrackMap.DefaultImpls.getHasAudio(this);
            }

            public boolean getHasVideo() {
                return TrackMap.DefaultImpls.getHasVideo(this);
            }

            public int getSize() {
                return TrackMap.DefaultImpls.getSize(this);
            }

            @NotNull
            public Pair<MediaCodec, Surface> getVideo() {
                return TrackMap.DefaultImpls.getVideo(this);
            }
        };
        this.ownsEncoderStart = new TrackMap<Boolean>(this){
            final /* synthetic */ Codecs this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean has(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return true;
            }

            @NotNull
            public Boolean get(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return ((Number)Codecs.access$getCurrent$p(this.this$0).get(type)).intValue() == 0;
            }

            @Nullable
            public Boolean audioOrNull() {
                return TrackMap.DefaultImpls.audioOrNull(this);
            }

            @Nullable
            public Boolean getOrNull(@NotNull TrackType type) {
                return TrackMap.DefaultImpls.getOrNull(this, type);
            }

            @NotNull
            public Iterator<Boolean> iterator() {
                return TrackMap.DefaultImpls.iterator(this);
            }

            @Nullable
            public Boolean videoOrNull() {
                return TrackMap.DefaultImpls.videoOrNull(this);
            }

            @NotNull
            public Boolean getAudio() {
                return TrackMap.DefaultImpls.getAudio(this);
            }

            public boolean getHasAudio() {
                return TrackMap.DefaultImpls.getHasAudio(this);
            }

            public boolean getHasVideo() {
                return TrackMap.DefaultImpls.getHasVideo(this);
            }

            public int getSize() {
                return TrackMap.DefaultImpls.getSize(this);
            }

            @NotNull
            public Boolean getVideo() {
                return TrackMap.DefaultImpls.getVideo(this);
            }
        };
        this.ownsEncoderStop = new TrackMap<Boolean>(this){
            final /* synthetic */ Codecs this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean has(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return true;
            }

            @NotNull
            public Boolean get(@NotNull TrackType type) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return ((Number)Codecs.access$getCurrent$p(this.this$0).get(type)).intValue() == CollectionsKt.getLastIndex((List)Codecs.access$getSources$p(this.this$0).get(type));
            }

            @Nullable
            public Boolean audioOrNull() {
                return TrackMap.DefaultImpls.audioOrNull(this);
            }

            @Nullable
            public Boolean getOrNull(@NotNull TrackType type) {
                return TrackMap.DefaultImpls.getOrNull(this, type);
            }

            @NotNull
            public Iterator<Boolean> iterator() {
                return TrackMap.DefaultImpls.iterator(this);
            }

            @Nullable
            public Boolean videoOrNull() {
                return TrackMap.DefaultImpls.videoOrNull(this);
            }

            @NotNull
            public Boolean getAudio() {
                return TrackMap.DefaultImpls.getAudio(this);
            }

            public boolean getHasAudio() {
                return TrackMap.DefaultImpls.getHasAudio(this);
            }

            public boolean getHasVideo() {
                return TrackMap.DefaultImpls.getHasVideo(this);
            }

            public int getSize() {
                return TrackMap.DefaultImpls.getSize(this);
            }

            @NotNull
            public Boolean getVideo() {
                return TrackMap.DefaultImpls.getVideo(this);
            }
        };
    }

    @NotNull
    public final TrackMap<Pair<MediaCodec, Surface>> getEncoders() {
        return this.encoders;
    }

    @NotNull
    public final TrackMap<Boolean> getOwnsEncoderStart() {
        return this.ownsEncoderStart;
    }

    @NotNull
    public final TrackMap<Boolean> getOwnsEncoderStop() {
        return this.ownsEncoderStop;
    }

    public final void release() {
        Iterable $this$forEach$iv = this.encoders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            ((MediaCodec)it.getFirst()).release();
        }
    }

    public static final /* synthetic */ Tracks access$getTracks$p(Codecs $this) {
        return $this.tracks;
    }

    public static final /* synthetic */ TrackMap access$getCurrent$p(Codecs $this) {
        return $this.current;
    }

    public static final /* synthetic */ DataSources access$getSources$p(Codecs $this) {
        return $this.sources;
    }
}

