/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.sink;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.MutableTrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.sink.DataSink;
import com.otaliastudios.transcoder.sink.DefaultDataSinkChecks;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class DefaultDataSink
implements DataSink {
    private static final Logger LOG = new Logger("DefaultDataSink");
    private static final int BUFFER_SIZE = 262144;
    private boolean mMuxerStarted = false;
    private final MediaMuxer mMuxer;
    private final List<QueuedSample> mQueue = new ArrayList<QueuedSample>();
    private ByteBuffer mQueueBuffer;
    private final MutableTrackMap<TrackStatus> mStatus = TrackMapKt.mutableTrackMapOf(null);
    private final MutableTrackMap<MediaFormat> mLastFormat = TrackMapKt.mutableTrackMapOf(null);
    private final MutableTrackMap<Integer> mMuxerIndex = TrackMapKt.mutableTrackMapOf(null);
    private final DefaultDataSinkChecks mMuxerChecks = new DefaultDataSinkChecks();

    public DefaultDataSink(@NonNull String outputFilePath) {
        this(outputFilePath, 0);
    }

    public DefaultDataSink(@NonNull String outputFilePath, int format) {
        try {
            this.mMuxer = new MediaMuxer(outputFilePath, format);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequiresApi(api=26)
    public DefaultDataSink(@NonNull FileDescriptor fileDescriptor) {
        this(fileDescriptor, 0);
    }

    @RequiresApi(api=26)
    public DefaultDataSink(@NonNull FileDescriptor fileDescriptor, int format) {
        try {
            this.mMuxer = new MediaMuxer(fileDescriptor, format);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setOrientation(int rotation) {
        this.mMuxer.setOrientationHint(rotation);
    }

    @Override
    public void setLocation(double latitude, double longitude) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mMuxer.setLocation((float)latitude, (float)longitude);
        }
    }

    @Override
    public void setTrackStatus(@NonNull TrackType type, @NonNull TrackStatus status) {
        this.mStatus.set(type, status);
    }

    @Override
    public void setTrackFormat(@NonNull TrackType type, @NonNull MediaFormat format) {
        boolean shouldValidate;
        LOG.i("setTrackFormat(" + (Object)((Object)type) + ") format=" + format);
        boolean bl = shouldValidate = this.mStatus.get(type) == TrackStatus.COMPRESSING;
        if (shouldValidate) {
            this.mMuxerChecks.checkOutputFormat(type, format);
        }
        this.mLastFormat.set(type, format);
        this.maybeStart();
    }

    private void maybeStart() {
        boolean isAudioReady;
        if (this.mMuxerStarted) {
            return;
        }
        boolean isTranscodingVideo = ((TrackStatus)((Object)this.mStatus.get(TrackType.VIDEO))).isTranscoding();
        boolean isTranscodingAudio = ((TrackStatus)((Object)this.mStatus.get(TrackType.AUDIO))).isTranscoding();
        MediaFormat videoOutputFormat = (MediaFormat)this.mLastFormat.getOrNull(TrackType.VIDEO);
        MediaFormat audioOutputFormat = (MediaFormat)this.mLastFormat.getOrNull(TrackType.AUDIO);
        boolean isVideoReady = videoOutputFormat != null || !isTranscodingVideo;
        boolean bl = isAudioReady = audioOutputFormat != null || !isTranscodingAudio;
        if (!isVideoReady || !isAudioReady) {
            return;
        }
        if (isTranscodingVideo) {
            int videoIndex = this.mMuxer.addTrack(videoOutputFormat);
            this.mMuxerIndex.setVideo(videoIndex);
            LOG.v("Added track #" + videoIndex + " with " + videoOutputFormat.getString("mime") + " to muxer");
        }
        if (isTranscodingAudio) {
            int audioIndex = this.mMuxer.addTrack(audioOutputFormat);
            this.mMuxerIndex.setAudio(audioIndex);
            LOG.v("Added track #" + audioIndex + " with " + audioOutputFormat.getString("mime") + " to muxer");
        }
        this.mMuxer.start();
        this.mMuxerStarted = true;
        this.drainQueue();
    }

    @Override
    public void writeTrack(@NonNull TrackType type, @NonNull ByteBuffer byteBuffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        if (this.mMuxerStarted) {
            this.mMuxer.writeSampleData(((Integer)this.mMuxerIndex.get(type)).intValue(), byteBuffer, bufferInfo);
        } else {
            this.enqueue(type, byteBuffer, bufferInfo);
        }
    }

    private void enqueue(@NonNull TrackType type, @NonNull ByteBuffer buffer, @NonNull MediaCodec.BufferInfo bufferInfo) {
        if (this.mQueueBuffer == null) {
            this.mQueueBuffer = ByteBuffer.allocateDirect(262144).order(ByteOrder.nativeOrder());
        }
        LOG.v("enqueue(" + (Object)((Object)type) + "): offset=" + bufferInfo.offset + "\trealOffset=" + buffer.position() + "\tsize=" + bufferInfo.size + "\trealSize=" + buffer.remaining() + "\tavailable=" + this.mQueueBuffer.remaining() + "\ttotal=" + 262144);
        buffer.limit(bufferInfo.offset + bufferInfo.size);
        buffer.position(bufferInfo.offset);
        this.mQueueBuffer.put(buffer);
        this.mQueue.add(new QueuedSample(type, bufferInfo));
    }

    private void drainQueue() {
        if (this.mQueue.isEmpty()) {
            return;
        }
        this.mQueueBuffer.flip();
        LOG.i("Output format determined, writing pending data into the muxer. samples:" + this.mQueue.size() + " bytes:" + this.mQueueBuffer.limit());
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        int offset = 0;
        for (QueuedSample sample : this.mQueue) {
            bufferInfo.set(offset, sample.mSize, sample.mTimeUs, sample.mFlags);
            this.writeTrack(sample.mType, this.mQueueBuffer, bufferInfo);
            offset += sample.mSize;
        }
        this.mQueue.clear();
        this.mQueueBuffer = null;
    }

    @Override
    public void stop() {
        this.mMuxer.stop();
    }

    @Override
    public void release() {
        try {
            this.mMuxer.release();
        }
        catch (Exception e) {
            LOG.w("Failed to release the muxer.", e);
        }
    }

    private static class QueuedSample {
        private final TrackType mType;
        private final int mSize;
        private final long mTimeUs;
        private final int mFlags;

        private QueuedSample(@NonNull TrackType type, @NonNull MediaCodec.BufferInfo bufferInfo) {
            this.mType = type;
            this.mSize = bufferInfo.size;
            this.mTimeUs = bufferInfo.presentationTimeUs;
            this.mFlags = bufferInfo.flags;
        }
    }
}

