/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.resample;

import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.resample.AudioResampler;
import java.nio.ShortBuffer;

public class DownsampleAudioResampler
implements AudioResampler {
    private static float ratio(int remaining, int all) {
        return (float)remaining / (float)all;
    }

    @Override
    public void resample(@NonNull ShortBuffer inputBuffer, int inputSampleRate, @NonNull ShortBuffer outputBuffer, int outputSampleRate, int channels) {
        if (inputSampleRate < outputSampleRate) {
            throw new IllegalArgumentException("Illegal use of DownsampleAudioResampler");
        }
        if (channels != 1 && channels != 2) {
            throw new IllegalArgumentException("Illegal use of DownsampleAudioResampler. Channels:" + channels);
        }
        int inputSamples = inputBuffer.remaining() / channels;
        int outputSamples = (int)Math.ceil((double)inputSamples * ((double)outputSampleRate / (double)inputSampleRate));
        int dropSamples = inputSamples - outputSamples;
        int remainingOutputSamples = outputSamples;
        int remainingDropSamples = dropSamples;
        float remainingOutputSamplesRatio = DownsampleAudioResampler.ratio(remainingOutputSamples, outputSamples);
        float remainingDropSamplesRatio = DownsampleAudioResampler.ratio(remainingDropSamples, dropSamples);
        while (remainingOutputSamples > 0 && remainingDropSamples > 0) {
            if (remainingOutputSamplesRatio >= remainingDropSamplesRatio) {
                outputBuffer.put(inputBuffer.get());
                if (channels == 2) {
                    outputBuffer.put(inputBuffer.get());
                }
                remainingOutputSamplesRatio = DownsampleAudioResampler.ratio(--remainingOutputSamples, outputSamples);
                continue;
            }
            inputBuffer.position(inputBuffer.position() + channels);
            remainingDropSamplesRatio = DownsampleAudioResampler.ratio(--remainingDropSamples, dropSamples);
        }
    }
}

