/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.utils;

import android.media.MediaFormat;
import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.source.DataSource;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0007\u001a\u00020\u00052\b\b\u0001\u0010\b\u001a\u00020\tH\u0096\u0001J\t\u0010\n\u001a\u00020\u000bH\u0096\u0001J\t\u0010\f\u001a\u00020\rH\u0096\u0001J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0097\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u0096\u0001J\t\u0010\u0012\u001a\u00020\rH\u0096\u0001J\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010\b\u001a\u00020\tH\u0097\u0001J\t\u0010\u0015\u001a\u00020\u000bH\u0096\u0001J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\t\u0010\u0017\u001a\u00020\u0005H\u0096\u0001J\u0013\u0010\u0018\u001a\u00020\u000b2\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0096\u0001J\u0013\u0010\u001b\u001a\u00020\u000b2\b\b\u0001\u0010\b\u001a\u00020\tH\u0096\u0001J\u0011\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\rH\u0096\u0001J\u0013\u0010\u001e\u001a\u00020\u000b2\b\b\u0001\u0010\b\u001a\u00020\tH\u0096\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/otaliastudios/transcoder/internal/utils/EosForcingDataSource;", "Lcom/otaliastudios/transcoder/source/DataSource;", "source", "force", "Lkotlin/Function0;", "", "(Lcom/otaliastudios/transcoder/source/DataSource;Lkotlin/jvm/functions/Function0;)V", "canReadTrack", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "deinitialize", "", "getDurationUs", "", "getLocation", "", "getOrientation", "", "getPositionUs", "getTrackFormat", "Landroid/media/MediaFormat;", "initialize", "isDrained", "isInitialized", "readTrack", "chunk", "Lcom/otaliastudios/transcoder/source/DataSource$Chunk;", "releaseTrack", "seekTo", "desiredPositionUs", "selectTrack", "lib_release"})
final class EosForcingDataSource
implements DataSource {
    private final DataSource source;
    private final Function0<Boolean> force;

    @Override
    public boolean isDrained() {
        return (Boolean)this.force.invoke() != false || this.source.isDrained();
    }

    public EosForcingDataSource(@NotNull DataSource source2, @NotNull Function0<Boolean> force) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter(force, (String)"force");
        this.source = source2;
        this.force = force;
    }

    @Override
    public boolean canReadTrack(@NonNull @NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.source.canReadTrack(type);
    }

    @Override
    public void deinitialize() {
        this.source.deinitialize();
    }

    @Override
    public long getDurationUs() {
        return this.source.getDurationUs();
    }

    @Override
    @androidx.annotation.Nullable
    @Nullable
    public double[] getLocation() {
        return this.source.getLocation();
    }

    @Override
    public int getOrientation() {
        return this.source.getOrientation();
    }

    @Override
    public long getPositionUs() {
        return this.source.getPositionUs();
    }

    @Override
    @androidx.annotation.Nullable
    @Nullable
    public MediaFormat getTrackFormat(@NonNull @NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.source.getTrackFormat(type);
    }

    @Override
    public void initialize() {
        this.source.initialize();
    }

    @Override
    public boolean isInitialized() {
        return this.source.isInitialized();
    }

    @Override
    public void readTrack(@NonNull @NotNull DataSource.Chunk chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.source.readTrack(chunk);
    }

    @Override
    public void releaseTrack(@NonNull @NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.source.releaseTrack(type);
    }

    @Override
    public long seekTo(long desiredPositionUs) {
        return this.source.seekTo(desiredPositionUs);
    }

    @Override
    public void selectTrack(@NonNull @NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.source.selectTrack(type);
    }
}

