/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.media;

import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.media.MediaCodecBuffers;
import com.otaliastudios.transcoder.source.DataSource;
import java.io.IOException;

public class MediaFormatProvider {
    @NonNull
    public MediaFormat provideMediaFormat(@NonNull DataSource source2, @NonNull TrackType type, @NonNull MediaFormat format) {
        if (this.isComplete(type, format)) {
            return format;
        }
        MediaFormat newFormat = this.decodeMediaFormat(source2, type, format);
        if (!this.isComplete(type, newFormat)) {
            String message = "Could not get a complete format!";
            message = message + " hasMimeType:" + newFormat.containsKey("mime");
            if (type == TrackType.VIDEO) {
                message = message + " hasWidth:" + newFormat.containsKey("width");
                message = message + " hasHeight:" + newFormat.containsKey("height");
                message = message + " hasFrameRate:" + newFormat.containsKey("frame-rate");
            } else if (type == TrackType.AUDIO) {
                message = message + " hasChannels:" + newFormat.containsKey("channel-count");
                message = message + " hasSampleRate:" + newFormat.containsKey("sample-rate");
            }
            throw new RuntimeException(message);
        }
        return newFormat;
    }

    private boolean isComplete(@NonNull TrackType type, @NonNull MediaFormat format) {
        if (type == TrackType.VIDEO && !format.containsKey("frame-rate")) {
            format.setInteger("frame-rate", 24);
        }
        switch (type) {
            case AUDIO: {
                return this.isCompleteAudioFormat(format);
            }
            case VIDEO: {
                return this.isCompleteVideoFormat(format);
            }
        }
        throw new RuntimeException("Unexpected type: " + (Object)((Object)type));
    }

    private boolean isCompleteVideoFormat(@NonNull MediaFormat format) {
        return format.containsKey("mime") && format.containsKey("height") && format.containsKey("width") && format.containsKey("frame-rate");
    }

    private boolean isCompleteAudioFormat(@NonNull MediaFormat format) {
        return format.containsKey("mime") && format.containsKey("channel-count") && format.containsKey("sample-rate");
    }

    @NonNull
    private MediaFormat decodeMediaFormat(@NonNull DataSource source2, @NonNull TrackType type, @NonNull MediaFormat format) {
        MediaCodec decoder;
        source2.selectTrack(type);
        try {
            decoder = MediaCodec.createDecoderByType((String)format.getString("mime"));
            decoder.configure(format, null, null, 0);
        }
        catch (IOException e) {
            throw new RuntimeException("Can't decode this track", e);
        }
        decoder.start();
        MediaCodecBuffers buffers2 = new MediaCodecBuffers(decoder);
        MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
        DataSource.Chunk chunk = new DataSource.Chunk();
        MediaFormat result2 = null;
        while (result2 == null) {
            result2 = this.decodeOnce(type, source2, chunk, decoder, buffers2, info);
        }
        source2.deinitialize();
        source2.initialize();
        return result2;
    }

    @Nullable
    private MediaFormat decodeOnce(@NonNull TrackType type, @NonNull DataSource source2, @NonNull DataSource.Chunk chunk, @NonNull MediaCodec decoder, @NonNull MediaCodecBuffers buffers2, @NonNull MediaCodec.BufferInfo info) {
        MediaFormat format = this.drainOnce(decoder, buffers2, info);
        if (format != null) {
            return format;
        }
        this.feedOnce(type, source2, chunk, decoder, buffers2);
        return null;
    }

    @Nullable
    private MediaFormat drainOnce(@NonNull MediaCodec decoder, @NonNull MediaCodecBuffers buffers2, @NonNull MediaCodec.BufferInfo info) {
        int result2 = decoder.dequeueOutputBuffer(info, 0L);
        switch (result2) {
            case -1: {
                return null;
            }
            case -2: {
                return decoder.getOutputFormat();
            }
            case -3: {
                buffers2.onOutputBuffersChanged();
                return this.drainOnce(decoder, buffers2, info);
            }
        }
        decoder.releaseOutputBuffer(result2, false);
        return null;
    }

    private void feedOnce(@NonNull TrackType type, @NonNull DataSource source2, @NonNull DataSource.Chunk chunk, @NonNull MediaCodec decoder, @NonNull MediaCodecBuffers buffers2) {
        if (!source2.canReadTrack(type)) {
            throw new RuntimeException("This should never happen!");
        }
        int result2 = decoder.dequeueInputBuffer(0L);
        if (result2 < 0) {
            return;
        }
        chunk.buffer = buffers2.getInputBuffer(result2);
        source2.readTrack(chunk);
        decoder.queueInputBuffer(result2, chunk.buffer.position(), chunk.buffer.remaining(), chunk.timeUs, chunk.keyframe ? 1 : 0);
    }
}

