/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.media;

import android.media.MediaCodec;
import android.os.Build;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;

public class MediaCodecBuffers {
    private final MediaCodec mMediaCodec;
    private final ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;

    public MediaCodecBuffers(@NonNull MediaCodec mediaCodec) {
        this.mMediaCodec = mediaCodec;
        if (Build.VERSION.SDK_INT < 21) {
            this.mInputBuffers = mediaCodec.getInputBuffers();
            this.mOutputBuffers = mediaCodec.getOutputBuffers();
        } else {
            this.mOutputBuffers = null;
            this.mInputBuffers = null;
        }
    }

    @NonNull
    public ByteBuffer getInputBuffer(int index) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mMediaCodec.getInputBuffer(index);
        }
        ByteBuffer result2 = this.mInputBuffers[index];
        result2.clear();
        return result2;
    }

    @NonNull
    public ByteBuffer getOutputBuffer(int index) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mMediaCodec.getOutputBuffer(index);
        }
        return this.mOutputBuffers[index];
    }

    public void onOutputBuffersChanged() {
        if (Build.VERSION.SDK_INT < 21) {
            this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
        }
    }
}

