/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.codec;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.Codecs;
import com.otaliastudios.transcoder.internal.codec.Encoder;
import com.otaliastudios.transcoder.internal.codec.EncoderChannel;
import com.otaliastudios.transcoder.internal.codec.EncoderData;
import com.otaliastudios.transcoder.internal.data.WriterChannel;
import com.otaliastudios.transcoder.internal.data.WriterData;
import com.otaliastudios.transcoder.internal.media.MediaCodecBuffers;
import com.otaliastudios.transcoder.internal.pipeline.QueuedStep;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 ;2\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u00020\u0003:\u0001;B\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB'\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0012J\u0016\u00100\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001d\u0018\u000101H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u000404H\u0014J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0002H\u0014J\u0010\u00108\u001a\u0002062\u0006\u00107\u001a\u00020\u0002H\u0014J\b\u00109\u001a\u000206H\u0002J\b\u0010:\u001a\u000206H\u0016R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R+\u0010%\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010$\u001a\u0004\b&\u0010 \"\u0004\b'\u0010\"R\u000e\u0010)\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/otaliastudios/transcoder/internal/codec/Encoder;", "Lcom/otaliastudios/transcoder/internal/pipeline/QueuedStep;", "Lcom/otaliastudios/transcoder/internal/codec/EncoderData;", "Lcom/otaliastudios/transcoder/internal/codec/EncoderChannel;", "Lcom/otaliastudios/transcoder/internal/data/WriterData;", "Lcom/otaliastudios/transcoder/internal/data/WriterChannel;", "codecs", "Lcom/otaliastudios/transcoder/internal/Codecs;", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "(Lcom/otaliastudios/transcoder/internal/Codecs;Lcom/otaliastudios/transcoder/common/TrackType;)V", "codec", "Landroid/media/MediaCodec;", "surface", "Landroid/view/Surface;", "ownsCodecStart", "", "ownsCodecStop", "(Landroid/media/MediaCodec;Landroid/view/Surface;ZZ)V", "buffers", "Lcom/otaliastudios/transcoder/internal/media/MediaCodecBuffers;", "getBuffers", "()Lcom/otaliastudios/transcoder/internal/media/MediaCodecBuffers;", "buffers$delegate", "Lkotlin/Lazy;", "channel", "getChannel", "()Lcom/otaliastudios/transcoder/internal/codec/Encoder;", "<set-?>", "", "dequeuedInputs", "getDequeuedInputs", "()I", "setDequeuedInputs", "(I)V", "dequeuedInputs$delegate", "Lkotlin/properties/ReadWriteProperty;", "dequeuedOutputs", "getDequeuedOutputs", "setDequeuedOutputs", "dequeuedOutputs$delegate", "eosReceivedButNotEnqueued", "info", "Landroid/media/MediaCodec$BufferInfo;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "getSurface", "()Landroid/view/Surface;", "buffer", "Lkotlin/Pair;", "Ljava/nio/ByteBuffer;", "drain", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "enqueue", "", "data", "enqueueEos", "printDequeued", "release", "Companion", "lib_release"})
public final class Encoder
extends QueuedStep<EncoderData, EncoderChannel, WriterData, WriterChannel>
implements EncoderChannel {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final TrackType type;
    private final Logger log;
    private final ReadWriteProperty dequeuedInputs$delegate;
    private final ReadWriteProperty dequeuedOutputs$delegate;
    @NotNull
    private final Encoder channel;
    private final Lazy buffers$delegate;
    private MediaCodec.BufferInfo info;
    private boolean eosReceivedButNotEnqueued;
    private final MediaCodec codec;
    @Nullable
    private final Surface surface;
    private final boolean ownsCodecStop;
    private static final TrackMap<AtomicInteger> ID;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(Encoder.class, "dequeuedInputs", "getDequeuedInputs()I", 0)), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(Encoder.class, "dequeuedOutputs", "getDequeuedOutputs()I", 0))};
        Companion = new Companion(null);
        ID = TrackMapKt.trackMapOf(new AtomicInteger(0), new AtomicInteger(0));
    }

    private final int getDequeuedInputs() {
        return ((Number)this.dequeuedInputs$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setDequeuedInputs(int n) {
        this.dequeuedInputs$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    private final int getDequeuedOutputs() {
        return ((Number)this.dequeuedOutputs$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
    }

    private final void setDequeuedOutputs(int n) {
        this.dequeuedOutputs$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)n);
    }

    private final void printDequeued() {
        this.log.v("dequeuedInputs=" + this.getDequeuedInputs() + " dequeuedOutputs=" + this.getDequeuedOutputs());
    }

    @Override
    @NotNull
    public Encoder getChannel() {
        return this.channel;
    }

    private final MediaCodecBuffers getBuffers() {
        Lazy lazy = this.buffers$delegate;
        Encoder encoder = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MediaCodecBuffers)lazy.getValue();
    }

    @Override
    @Nullable
    public Pair<ByteBuffer, Integer> buffer() {
        Pair pair;
        int id = this.codec.dequeueInputBuffer(0L);
        if (id >= 0) {
            Encoder encoder = this;
            int n = encoder.getDequeuedInputs();
            encoder.setDequeuedInputs(n + 1);
            pair = TuplesKt.to((Object)this.getBuffers().getInputBuffer(id), (Object)id);
        } else {
            this.log.i("buffer() failed. dequeuedInputs=" + this.getDequeuedInputs() + " dequeuedOutputs=" + this.getDequeuedOutputs());
            pair = null;
        }
        return pair;
    }

    @Override
    protected void enqueueEos(@NotNull EncoderData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (this.getSurface() == null) {
            if (!this.ownsCodecStop) {
                this.eosReceivedButNotEnqueued = true;
            }
            int flag = !this.ownsCodecStop ? 0 : 4;
            this.codec.queueInputBuffer(data2.getId(), 0, 0, 0L, flag);
            Encoder encoder = this;
            int n = encoder.getDequeuedInputs();
            encoder.setDequeuedInputs(n + -1);
        } else if (!this.ownsCodecStop) {
            this.eosReceivedButNotEnqueued = true;
        } else {
            this.codec.signalEndOfInputStream();
        }
    }

    @Override
    protected void enqueue(@NotNull EncoderData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (this.getSurface() != null) {
            return;
        }
        ByteBuffer byteBuffer = data2.getBuffer();
        boolean bl = false;
        boolean bl2 = false;
        if (byteBuffer == null) {
            boolean bl3 = false;
            String string = "Audio should always pass a buffer to Encoder.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ByteBuffer buffer = byteBuffer;
        this.codec.queueInputBuffer(data2.getId(), buffer.position(), buffer.remaining(), data2.getTimeUs(), 0);
        Encoder encoder = this;
        int n = encoder.getDequeuedInputs();
        encoder.setDequeuedInputs(n + -1);
    }

    @Override
    @NotNull
    protected State<WriterData> drain() {
        State state;
        long timeoutUs = this.eosReceivedButNotEnqueued ? 5000L : 0L;
        int result2 = this.codec.dequeueOutputBuffer(this.info, timeoutUs);
        switch (result2) {
            case -1: {
                if (this.eosReceivedButNotEnqueued) {
                    ByteBuffer buffer;
                    this.log.i("Sending fake Eos. dequeuedInputs=" + this.getDequeuedInputs() + " dequeuedOutputs=" + this.getDequeuedOutputs());
                    ByteBuffer byteBuffer = buffer = ByteBuffer.allocateDirect(0);
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer");
                    state = new State.Eos<WriterData>(new WriterData(byteBuffer, 0L, 0, (Function0<Unit>)((Function0)drain.1.INSTANCE)));
                    break;
                }
                this.log.i("Can't dequeue output buffer: INFO_TRY_AGAIN_LATER");
                state = State.Wait.INSTANCE;
                break;
            }
            case -2: {
                this.log.i("INFO_OUTPUT_FORMAT_CHANGED! format=" + this.codec.getOutputFormat());
                WriterChannel writerChannel = (WriterChannel)this.getNext();
                MediaFormat mediaFormat = this.codec.getOutputFormat();
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"codec.outputFormat");
                writerChannel.handleFormat(mediaFormat);
                state = State.Retry.INSTANCE;
                break;
            }
            case -3: {
                this.getBuffers().onOutputBuffersChanged();
                state = State.Retry.INSTANCE;
                break;
            }
            default: {
                boolean isConfig;
                boolean bl = isConfig = (this.info.flags & 2) != 0;
                if (isConfig) {
                    this.codec.releaseOutputBuffer(result2, false);
                    state = State.Retry.INSTANCE;
                    break;
                }
                Encoder encoder = this;
                int n = encoder.getDequeuedOutputs();
                encoder.setDequeuedOutputs(n + 1);
                boolean isEos = (this.info.flags & 4) != 0;
                int flags = this.info.flags & ~4;
                ByteBuffer byteBuffer = this.getBuffers().getOutputBuffer(result2);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffers.getOutputBuffer(result)");
                ByteBuffer buffer = byteBuffer;
                long timeUs = this.info.presentationTimeUs;
                buffer.clear();
                buffer.limit(this.info.offset + this.info.size);
                buffer.position(this.info.offset);
                WriterData data2 = new WriterData(buffer, timeUs, flags, (Function0<Unit>)((Function0)new Function0<Unit>(this, result2){
                    final /* synthetic */ Encoder this$0;
                    final /* synthetic */ int $result;

                    public final void invoke() {
                        Encoder.access$getCodec$p(this.this$0).releaseOutputBuffer(this.$result, false);
                        Encoder encoder = this.this$0;
                        int n = Encoder.access$getDequeuedOutputs$p(encoder);
                        Encoder.access$setDequeuedOutputs$p(encoder, n + -1);
                    }
                    {
                        this.this$0 = encoder;
                        this.$result = n;
                        super(0);
                    }
                }));
                state = isEos ? (State.Ok)new State.Eos<WriterData>(data2) : new State.Ok(data2);
            }
        }
        return state;
    }

    @Override
    public void release() {
        this.log.i("release(): ownsStop=" + this.ownsCodecStop + " dequeuedInputs=" + this.getDequeuedInputs() + " dequeuedOutputs=" + this.getDequeuedOutputs());
        if (this.ownsCodecStop) {
            this.codec.stop();
        }
    }

    @Override
    @Nullable
    public Surface getSurface() {
        return this.surface;
    }

    public Encoder(@NotNull MediaCodec codec, @Nullable Surface surface, boolean ownsCodecStart, boolean ownsCodecStop) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        this.codec = codec;
        this.surface = surface;
        this.ownsCodecStop = ownsCodecStop;
        this.type = this.getSurface() != null ? TrackType.VIDEO : TrackType.AUDIO;
        this.log = new Logger("Encoder(" + (Object)((Object)this.type) + ',' + ID.get(this.type).getAndIncrement() + ')');
        Delegates delegates = Delegates.INSTANCE;
        Integer initialValue$iv = 0;
        boolean $i$f$observable = false;
        this.dequeuedInputs$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ Encoder this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = encoder;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                int n = ((Number)newValue).intValue();
                int n2 = ((Number)oldValue).intValue();
                KProperty $noName_0 = property;
                boolean bl = false;
                Encoder.access$printDequeued(this.this$0);
            }
        };
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = 0;
        $i$f$observable = false;
        this.dequeuedOutputs$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ Encoder this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = encoder;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                int n = ((Number)newValue).intValue();
                int n2 = ((Number)oldValue).intValue();
                KProperty $noName_0 = property;
                boolean bl = false;
                Encoder.access$printDequeued(this.this$0);
            }
        };
        this.channel = this;
        this.buffers$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MediaCodecBuffers>(this){
            final /* synthetic */ Encoder this$0;

            @NotNull
            public final MediaCodecBuffers invoke() {
                return new MediaCodecBuffers(Encoder.access$getCodec$p(this.this$0));
            }
            {
                this.this$0 = encoder;
                super(0);
            }
        }));
        this.info = new MediaCodec.BufferInfo();
        this.log.i("Encoder: ownsStart=" + ownsCodecStart + " ownsStop=" + this.ownsCodecStop);
        if (ownsCodecStart) {
            this.codec.start();
        }
    }

    public Encoder(@NotNull Codecs codecs, @NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)codecs, (String)"codecs");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this((MediaCodec)codecs.getEncoders().get(type).getFirst(), (Surface)codecs.getEncoders().get(type).getSecond(), codecs.getOwnsEncoderStart().get(type), codecs.getOwnsEncoderStop().get(type));
    }

    public static final /* synthetic */ MediaCodec access$getCodec$p(Encoder $this) {
        return $this.codec;
    }

    public static final /* synthetic */ int access$getDequeuedOutputs$p(Encoder $this) {
        return $this.getDequeuedOutputs();
    }

    public static final /* synthetic */ void access$setDequeuedOutputs$p(Encoder $this, int n) {
        $this.setDequeuedOutputs(n);
    }

    public static final /* synthetic */ void access$printDequeued(Encoder $this) {
        $this.printDequeued();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/otaliastudios/transcoder/internal/codec/Encoder$Companion;", "", "()V", "ID", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "Ljava/util/concurrent/atomic/AtomicInteger;", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

