/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.audio;

import android.media.MediaFormat;
import android.view.Surface;
import com.otaliastudios.transcoder.internal.audio.ChunkQueue;
import com.otaliastudios.transcoder.internal.audio.ShortBuffers;
import com.otaliastudios.transcoder.internal.audio.remix.AudioRemixer;
import com.otaliastudios.transcoder.internal.codec.DecoderChannel;
import com.otaliastudios.transcoder.internal.codec.DecoderData;
import com.otaliastudios.transcoder.internal.codec.DecoderTimerData;
import com.otaliastudios.transcoder.internal.codec.EncoderChannel;
import com.otaliastudios.transcoder.internal.codec.EncoderData;
import com.otaliastudios.transcoder.internal.pipeline.QueuedStep;
import com.otaliastudios.transcoder.internal.pipeline.State;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.resample.AudioResampler;
import com.otaliastudios.transcoder.stretch.AudioStretcher;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 )2\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u00020\u0003:\u0001)B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 H\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0014J\u0010\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0014J\u0010\u0010%\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u000bH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\u00020\u001a*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/otaliastudios/transcoder/internal/audio/AudioEngine;", "Lcom/otaliastudios/transcoder/internal/pipeline/QueuedStep;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderData;", "Lcom/otaliastudios/transcoder/internal/codec/DecoderChannel;", "Lcom/otaliastudios/transcoder/internal/codec/EncoderData;", "Lcom/otaliastudios/transcoder/internal/codec/EncoderChannel;", "stretcher", "Lcom/otaliastudios/transcoder/stretch/AudioStretcher;", "resampler", "Lcom/otaliastudios/transcoder/resample/AudioResampler;", "targetFormat", "Landroid/media/MediaFormat;", "(Lcom/otaliastudios/transcoder/stretch/AudioStretcher;Lcom/otaliastudios/transcoder/resample/AudioResampler;Landroid/media/MediaFormat;)V", "buffers", "Lcom/otaliastudios/transcoder/internal/audio/ShortBuffers;", "channel", "getChannel", "()Lcom/otaliastudios/transcoder/internal/audio/AudioEngine;", "chunks", "Lcom/otaliastudios/transcoder/internal/audio/ChunkQueue;", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "rawFormat", "remixer", "Lcom/otaliastudios/transcoder/internal/audio/remix/AudioRemixer;", "channels", "", "getChannels", "(Landroid/media/MediaFormat;)I", "sampleRate", "getSampleRate", "drain", "Lcom/otaliastudios/transcoder/internal/pipeline/State;", "enqueue", "", "data", "enqueueEos", "handleRawFormat", "handleSourceFormat", "Landroid/view/Surface;", "sourceFormat", "Companion", "lib_release"})
public final class AudioEngine
extends QueuedStep<DecoderData, DecoderChannel, EncoderData, EncoderChannel>
implements DecoderChannel {
    private final Logger log;
    @NotNull
    private final AudioEngine channel;
    private final ShortBuffers buffers;
    private MediaFormat rawFormat;
    private ChunkQueue chunks;
    private AudioRemixer remixer;
    private final AudioStretcher stretcher;
    private final AudioResampler resampler;
    private final MediaFormat targetFormat;
    private static final AtomicInteger ID;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public AudioEngine getChannel() {
        return this.channel;
    }

    private final int getSampleRate(MediaFormat $this$sampleRate) {
        return $this$sampleRate.getInteger("sample-rate");
    }

    private final int getChannels(MediaFormat $this$channels) {
        return $this$channels.getInteger("channel-count");
    }

    @Override
    @Nullable
    public Surface handleSourceFormat(@NotNull MediaFormat sourceFormat) {
        Intrinsics.checkNotNullParameter((Object)sourceFormat, (String)"sourceFormat");
        return null;
    }

    @Override
    public void handleRawFormat(@NotNull MediaFormat rawFormat) {
        Intrinsics.checkNotNullParameter((Object)rawFormat, (String)"rawFormat");
        this.log.i("handleRawFormat(" + rawFormat + ')');
        this.rawFormat = rawFormat;
        this.remixer = AudioRemixer.Companion.get$lib_release(this.getChannels(rawFormat), this.getChannels(this.targetFormat));
        this.chunks = new ChunkQueue(this.getSampleRate(rawFormat), this.getChannels(rawFormat));
    }

    @Override
    protected void enqueueEos(@NotNull DecoderData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.log.i("enqueueEos()");
        data2.getRelease().invoke((Object)false);
        ChunkQueue chunkQueue = this.chunks;
        if (chunkQueue == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chunks");
        }
        chunkQueue.enqueueEos();
    }

    @Override
    protected void enqueue(@NotNull DecoderData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        DecoderData decoderData = data2;
        if (!(decoderData instanceof DecoderTimerData)) {
            decoderData = null;
        }
        DecoderTimerData decoderTimerData = (DecoderTimerData)decoderData;
        double stretch = decoderTimerData != null ? decoderTimerData.getTimeStretch() : 1.0;
        ChunkQueue chunkQueue = this.chunks;
        if (chunkQueue == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chunks");
        }
        ShortBuffer shortBuffer = data2.getBuffer().asShortBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)shortBuffer, (String)"data.buffer.asShortBuffer()");
        chunkQueue.enqueue(shortBuffer, data2.getTimeUs(), stretch, (Function0<Unit>)((Function0)new Function0<Unit>(data2){
            final /* synthetic */ DecoderData $data;

            public final void invoke() {
                this.$data.getRelease().invoke((Object)false);
            }
            {
                this.$data = decoderData;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected State<EncoderData> drain() {
        void outBytes;
        ChunkQueue chunkQueue = this.chunks;
        if (chunkQueue == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chunks");
        }
        if (chunkQueue.isEmpty()) {
            this.log.i("drain(): no chunks, waiting...");
            return State.Wait.INSTANCE;
        }
        Pair<ByteBuffer, Integer> pair = ((EncoderChannel)this.getNext()).buffer();
        if (pair == null) {
            AudioEngine audioEngine = this;
            boolean bl = false;
            boolean bl2 = false;
            AudioEngine $this$run = audioEngine;
            boolean bl3 = false;
            $this$run.log.i("drain(): no next buffer, waiting...");
            return State.Wait.INSTANCE;
        }
        Pair<ByteBuffer, Integer> pair2 = pair;
        ByteBuffer byteBuffer = (ByteBuffer)pair2.component1();
        int outId = ((Number)pair2.component2()).intValue();
        ShortBuffer outBuffer = outBytes.asShortBuffer();
        ChunkQueue chunkQueue2 = this.chunks;
        if (chunkQueue2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chunks");
        }
        return chunkQueue2.drain(new State.Eos<EncoderData>(new EncoderData((ByteBuffer)outBytes, outId, 0L)), (Function3)new Function3<ShortBuffer, Long, Double, State.Ok<EncoderData>>(this, outBuffer, (ByteBuffer)outBytes, outId){
            final /* synthetic */ AudioEngine this$0;
            final /* synthetic */ ShortBuffer $outBuffer;
            final /* synthetic */ ByteBuffer $outBytes;
            final /* synthetic */ int $outId;

            @NotNull
            public final State.Ok<EncoderData> invoke(@NotNull ShortBuffer inBuffer, long timeUs, double stretch) {
                boolean bl;
                double d;
                int n;
                Intrinsics.checkNotNullParameter((Object)inBuffer, (String)"inBuffer");
                int outSize = this.$outBuffer.remaining();
                int inSize = inBuffer.remaining();
                double d2 = (double)inSize * stretch;
                boolean bl2 = false;
                double desiredOutSize = Math.ceil(d2);
                desiredOutSize = AudioEngine.access$getRemixer$p(this.this$0).getRemixedSize((int)desiredOutSize);
                d2 = desiredOutSize * (double)AudioEngine.access$getSampleRate$p(this.this$0, AudioEngine.access$getTargetFormat$p(this.this$0)) / (double)AudioEngine.access$getSampleRate$p(this.this$0, AudioEngine.access$getRawFormat$p(this.this$0));
                bl2 = false;
                desiredOutSize = Math.ceil(d2);
                if (desiredOutSize <= (double)outSize) {
                    n = inSize;
                } else {
                    double factor = desiredOutSize / (double)inSize;
                    d = (double)outSize / factor;
                    bl = false;
                    n = (int)Math.floor(d);
                }
                int processableSize = n;
                inBuffer.limit(inBuffer.position() + processableSize);
                d = (double)processableSize * stretch;
                bl = false;
                double stretchSize = Math.ceil(d);
                ShortBuffer stretchBuffer = AudioEngine.access$getBuffers$p(this.this$0).acquire("stretch", (int)stretchSize);
                AudioEngine.access$getStretcher$p(this.this$0).stretch(inBuffer, stretchBuffer, AudioEngine.access$getChannels$p(this.this$0, AudioEngine.access$getRawFormat$p(this.this$0)));
                stretchBuffer.flip();
                int remixSize = AudioEngine.access$getRemixer$p(this.this$0).getRemixedSize((int)stretchSize);
                ShortBuffer remixBuffer = AudioEngine.access$getBuffers$p(this.this$0).acquire("remix", remixSize);
                AudioEngine.access$getRemixer$p(this.this$0).remix(stretchBuffer, remixBuffer);
                remixBuffer.flip();
                AudioEngine.access$getResampler$p(this.this$0).resample(remixBuffer, AudioEngine.access$getSampleRate$p(this.this$0, AudioEngine.access$getRawFormat$p(this.this$0)), this.$outBuffer, AudioEngine.access$getSampleRate$p(this.this$0, AudioEngine.access$getTargetFormat$p(this.this$0)), AudioEngine.access$getChannels$p(this.this$0, AudioEngine.access$getTargetFormat$p(this.this$0)));
                this.$outBuffer.flip();
                this.$outBytes.clear();
                this.$outBytes.limit(this.$outBuffer.limit() * 2);
                this.$outBytes.position(this.$outBuffer.position() * 2);
                return new State.Ok<EncoderData>(new EncoderData(this.$outBytes, this.$outId, timeUs));
            }
            {
                this.this$0 = audioEngine;
                this.$outBuffer = shortBuffer;
                this.$outBytes = byteBuffer;
                this.$outId = n;
                super(3);
            }
        });
    }

    public AudioEngine(@NotNull AudioStretcher stretcher, @NotNull AudioResampler resampler, @NotNull MediaFormat targetFormat) {
        Intrinsics.checkNotNullParameter((Object)stretcher, (String)"stretcher");
        Intrinsics.checkNotNullParameter((Object)resampler, (String)"resampler");
        Intrinsics.checkNotNullParameter((Object)targetFormat, (String)"targetFormat");
        this.stretcher = stretcher;
        this.resampler = resampler;
        this.targetFormat = targetFormat;
        this.log = new Logger("AudioEngine(" + ID.getAndIncrement() + ')');
        this.channel = this;
        this.buffers = new ShortBuffers();
    }

    static {
        Companion = new Companion(null);
        ID = new AtomicInteger(0);
    }

    public static final /* synthetic */ AudioRemixer access$getRemixer$p(AudioEngine $this) {
        AudioRemixer audioRemixer = $this.remixer;
        if (audioRemixer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"remixer");
        }
        return audioRemixer;
    }

    public static final /* synthetic */ void access$setRemixer$p(AudioEngine $this, AudioRemixer audioRemixer) {
        $this.remixer = audioRemixer;
    }

    public static final /* synthetic */ MediaFormat access$getTargetFormat$p(AudioEngine $this) {
        return $this.targetFormat;
    }

    public static final /* synthetic */ int access$getSampleRate$p(AudioEngine $this, MediaFormat $this$access_u24sampleRate_u24p) {
        return $this.getSampleRate($this$access_u24sampleRate_u24p);
    }

    public static final /* synthetic */ MediaFormat access$getRawFormat$p(AudioEngine $this) {
        MediaFormat mediaFormat = $this.rawFormat;
        if (mediaFormat == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rawFormat");
        }
        return mediaFormat;
    }

    public static final /* synthetic */ void access$setRawFormat$p(AudioEngine $this, MediaFormat mediaFormat) {
        $this.rawFormat = mediaFormat;
    }

    public static final /* synthetic */ ShortBuffers access$getBuffers$p(AudioEngine $this) {
        return $this.buffers;
    }

    public static final /* synthetic */ AudioStretcher access$getStretcher$p(AudioEngine $this) {
        return $this.stretcher;
    }

    public static final /* synthetic */ int access$getChannels$p(AudioEngine $this, MediaFormat $this$access_u24channels_u24p) {
        return $this.getChannels($this$access_u24channels_u24p);
    }

    public static final /* synthetic */ AudioResampler access$getResampler$p(AudioEngine $this) {
        return $this.resampler;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/otaliastudios/transcoder/internal/audio/AudioEngine$Companion;", "", "()V", "ID", "Ljava/util/concurrent/atomic/AtomicInteger;", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

