/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.parser.OVariableParser;
import com.orientechnologies.common.parser.OVariableParserListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import com.orientechnologies.orient.server.plugin.OServerPluginConfigurable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OAutomaticBackup
extends OServerPluginAbstract
implements OServerPluginConfigurable {
    private ODocument configuration;
    private Set<OAutomaticBackupListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private String configFile = "${ORIENTDB_HOME}/config/automatic-backup.json";
    private Date firstTime = null;
    private long delay = -1L;
    private int bufferSize = 0x100000;
    private int compressionLevel = 9;
    private MODE mode = MODE.FULL_BACKUP;
    private String exportOptions;
    private String targetDirectory = "backup";
    private String targetFileName;
    private Set<String> includeDatabases = new HashSet<String>();
    private Set<String> excludeDatabases = new HashSet<String>();
    private OServer serverInstance;

    @Override
    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        this.serverInstance = iServer;
        this.configuration = new ODocument();
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("config") && param.value.trim().length() > 0) {
                this.configFile = param.value.trim();
                File f = new File(OSystemVariableResolver.resolveSystemVariables((String)this.configFile));
                if (f.exists()) break;
                throw new OConfigurationException("Automatic Backup configuration file '" + this.configFile + "' not found. Automatic Backup will be disabled");
            }
            if (param.name.equalsIgnoreCase("enabled")) {
                this.configuration.field("enabled", (Object)Boolean.parseBoolean(param.value));
                continue;
            }
            if (param.name.equalsIgnoreCase("delay")) {
                this.configuration.field("delay", (Object)param.value);
                continue;
            }
            if (param.name.equalsIgnoreCase("firstTime")) {
                this.configuration.field("firstTime", (Object)param.value);
                continue;
            }
            if (param.name.equalsIgnoreCase("target.directory")) {
                this.configuration.field("targetDirectory", (Object)param.value);
                continue;
            }
            if (param.name.equalsIgnoreCase("db.include") && param.value.trim().length() > 0) {
                this.configuration.field("dbInclude", (Object)param.value);
                continue;
            }
            if (param.name.equalsIgnoreCase("db.exclude") && param.value.trim().length() > 0) {
                this.configuration.field("dbExclude", (Object)param.value);
                continue;
            }
            if (param.name.equalsIgnoreCase("target.fileName")) {
                this.configuration.field("targetFileName", (Object)param.value);
                continue;
            }
            if (param.name.equalsIgnoreCase("bufferSize")) {
                this.configuration.field("bufferSize", (Object)Integer.parseInt(param.value));
                continue;
            }
            if (param.name.equalsIgnoreCase("compressionLevel")) {
                this.configuration.field("compressionLevel", (Object)Integer.parseInt(param.value));
                continue;
            }
            if (param.name.equalsIgnoreCase("mode")) {
                this.configuration.field("mode", (Object)param.value);
                continue;
            }
            if (!param.name.equalsIgnoreCase("exportOptions")) continue;
            this.configuration.field("exportOptions", (Object)param.value);
        }
        this.configure();
        if (this.enabled) {
            File filePath;
            if (this.delay <= 0L) {
                throw new OConfigurationException("Cannot find mandatory parameter 'delay'");
            }
            if (!this.targetDirectory.endsWith("/")) {
                this.targetDirectory = this.targetDirectory + "/";
            }
            if ((filePath = new File(this.targetDirectory)).exists()) {
                if (!filePath.isDirectory()) {
                    throw new OConfigurationException("Parameter 'path' points to a file, not a directory");
                }
            } else {
                filePath.mkdirs();
            }
            OLogManager.instance().info((Object)this, "Automatic Backup plugin installed and active: delay=%dms, firstTime=%s, targetDirectory=%s", new Object[]{this.delay, this.firstTime, this.targetDirectory});
            Runnable timerTask = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    OLogManager.instance().info((Object)this, "Scanning databases to backup...", new Object[0]);
                    int ok = 0;
                    int errors = 0;
                    Map<String, String> databases = OAutomaticBackup.this.serverInstance.getAvailableStorageNames();
                    for (Map.Entry<String, String> database : databases.entrySet()) {
                        String dbName = database.getKey();
                        String dbURL = database.getValue();
                        boolean include = OAutomaticBackup.this.includeDatabases.size() > 0 ? OAutomaticBackup.this.includeDatabases.contains(dbName) : true;
                        if (OAutomaticBackup.this.excludeDatabases.contains(dbName)) {
                            include = false;
                        }
                        if (!include) continue;
                        ODatabaseDocumentInternal db = null;
                        try {
                            db = OAutomaticBackup.this.serverInstance.getDatabases().openNoAuthorization(dbName);
                            long begin = System.currentTimeMillis();
                            switch (OAutomaticBackup.this.mode) {
                                case FULL_BACKUP: {
                                    OAutomaticBackup.this.fullBackupDatabase(dbURL, OAutomaticBackup.this.targetDirectory + OAutomaticBackup.this.getFileName(database), db);
                                    OLogManager.instance().info((Object)this, "Full Backup of database '" + dbURL + "' completed in " + (System.currentTimeMillis() - begin) + "ms", new Object[0]);
                                    break;
                                }
                                case INCREMENTAL_BACKUP: {
                                    OAutomaticBackup.this.incrementalBackupDatabase(dbURL, OAutomaticBackup.this.targetDirectory, db);
                                    OLogManager.instance().info((Object)this, "Incremental Backup of database '" + dbURL + "' completed in " + (System.currentTimeMillis() - begin) + "ms", new Object[0]);
                                    break;
                                }
                                case EXPORT: {
                                    OAutomaticBackup.this.exportDatabase(dbURL, OAutomaticBackup.this.targetDirectory + OAutomaticBackup.this.getFileName(database), db);
                                    OLogManager.instance().info((Object)this, "Export of database '" + dbURL + "' completed in " + (System.currentTimeMillis() - begin) + "ms", new Object[0]);
                                }
                            }
                            try {
                                for (OAutomaticBackupListener listener : OAutomaticBackup.this.listeners) {
                                    listener.onBackupCompleted(dbName);
                                }
                            }
                            catch (Exception e) {
                                OLogManager.instance().error((Object)this, "Error on listener for database '" + dbURL, (Throwable)e, new Object[0]);
                            }
                            ++ok;
                        }
                        catch (Exception e) {
                            OLogManager.instance().error((Object)this, "Error on backup of database '" + dbURL + "' to directory: " + OAutomaticBackup.this.targetDirectory, (Throwable)e, new Object[0]);
                            try {
                                for (OAutomaticBackupListener listener : OAutomaticBackup.this.listeners) {
                                    listener.onBackupError(dbName, e);
                                }
                            }
                            catch (Exception l) {
                                OLogManager.instance().error((Object)this, "Error on listener for database '" + dbURL, (Throwable)l, new Object[0]);
                            }
                            ++errors;
                        }
                        finally {
                            if (db == null) continue;
                            db.close();
                        }
                    }
                    OLogManager.instance().info((Object)this, "Automatic Backup finished: %d ok, %d errors", new Object[]{ok, errors});
                }
            };
            if (this.firstTime == null) {
                Orient.instance().scheduleTask(timerTask, this.delay, this.delay);
            } else {
                Orient.instance().scheduleTask(timerTask, this.firstTime, this.delay);
            }
        } else {
            OLogManager.instance().info((Object)this, "Automatic Backup plugin is disabled", new Object[0]);
        }
    }

    private void configure() {
        File f = new File(OSystemVariableResolver.resolveSystemVariables((String)this.configFile));
        if (f.exists()) {
            try {
                String configurationContent = OIOUtils.readFileAsString((File)f);
                this.configuration = new ODocument().fromJSON(configurationContent);
            }
            catch (IOException e) {
                throw OException.wrapException((OException)new OConfigurationException("Cannot load Automatic Backup configuration file '" + this.configFile + "'. Automatic Backup will be disabled"), (Throwable)e);
            }
        }
        try {
            f.getParentFile().mkdirs();
            f.createNewFile();
            OIOUtils.writeFile((File)f, (String)this.configuration.toJSON("prettyPrint"));
            OLogManager.instance().info((Object)this, "Automatic Backup: migrated configuration to file '%s'", new Object[]{f});
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OConfigurationException("Cannot create Automatic Backup configuration file '" + this.configFile + "'. Automatic Backup will be disabled"), (Throwable)e);
        }
        for (String settingName : this.configuration.fieldNames()) {
            String settingValueAsString;
            Object settingValue = this.configuration.field(settingName);
            String string = settingValueAsString = settingValue != null ? settingValue.toString() : null;
            if (settingName.equalsIgnoreCase("enabled")) {
                if (((Boolean)settingValue).booleanValue()) continue;
                this.enabled = false;
                return;
            }
            if (settingName.equalsIgnoreCase("delay")) {
                this.delay = OIOUtils.getTimeAsMillisecs((Object)settingValue);
                continue;
            }
            if (settingName.equalsIgnoreCase("firstTime")) {
                try {
                    this.firstTime = OIOUtils.getTodayWithTime((String)settingValueAsString);
                    if (!this.firstTime.before(new Date())) continue;
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(this.firstTime);
                    cal.add(5, 1);
                    this.firstTime = cal.getTime();
                    continue;
                }
                catch (ParseException e) {
                    throw OException.wrapException((OException)new OConfigurationException("Parameter 'firstTime' has invalid format, expected: HH:mm:ss"), (Throwable)e);
                }
            }
            if (settingName.equalsIgnoreCase("targetDirectory")) {
                this.targetDirectory = settingValueAsString;
                continue;
            }
            if (settingName.equalsIgnoreCase("dbInclude")) {
                String[] included;
                for (String db : included = this.getDbsList(settingName, settingValueAsString)) {
                    this.includeDatabases.add(db);
                }
                continue;
            }
            if (settingName.equalsIgnoreCase("dbExclude") && settingValueAsString.trim().length() > 0) {
                String[] excluded;
                for (String db : excluded = this.getDbsList(settingName, settingValueAsString)) {
                    this.excludeDatabases.add(db);
                }
                continue;
            }
            if (settingName.equalsIgnoreCase("targetFileName")) {
                this.targetFileName = settingValueAsString;
                continue;
            }
            if (settingName.equalsIgnoreCase("bufferSize")) {
                this.bufferSize = (Integer)settingValue;
                continue;
            }
            if (settingName.equalsIgnoreCase("compressionLevel")) {
                this.compressionLevel = (Integer)settingValue;
                continue;
            }
            if (settingName.equalsIgnoreCase("mode")) {
                this.mode = MODE.valueOf(settingValueAsString.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if (!settingName.equalsIgnoreCase("exportOptions")) continue;
            this.exportOptions = settingValueAsString;
        }
    }

    private String[] getDbsList(String settingName, String settingValueAsString) {
        String[] included = null;
        Object val = this.configuration.field(settingName);
        if (val instanceof Collection) {
            Collection dbs = (Collection)val;
            included = new String[dbs.size()];
            int i = 0;
            for (Object o : dbs) {
                included[i] = o.toString();
                ++i;
            }
        } else if (settingValueAsString.trim().length() > 0) {
            included = settingValueAsString.split(",");
        }
        return included;
    }

    protected void incrementalBackupDatabase(String dbURL, String iPath, ODatabaseDocumentInternal db) throws IOException {
        if (!iPath.endsWith("/")) {
            iPath = iPath + "/";
        }
        iPath = iPath + db.getName();
        OLogManager.instance().info((Object)this, "AutomaticBackup: executing incremental backup of database '%s' to %s", new Object[]{dbURL, iPath});
        db.incrementalBackup(iPath);
    }

    protected void fullBackupDatabase(String dbURL, String iPath, ODatabaseDocumentInternal db) throws IOException {
        OLogManager.instance().info((Object)this, "AutomaticBackup: executing full backup of database '%s' to %s", new Object[]{dbURL, iPath});
        Path filePath = Paths.get(iPath, new String[0]);
        OFileUtils.prepareForFileCreationOrReplacement((Path)filePath, (Object)this, (String)"backing up");
        String tempFileName = iPath + ".tmp";
        Path tempFilePath = Paths.get(tempFileName, new String[0]);
        OFileUtils.prepareForFileCreationOrReplacement((Path)tempFilePath, (Object)this, (String)"backing up");
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(tempFileName);){
                db.backup((OutputStream)fileOutputStream, null, null, new OCommandOutputListener(){

                    public void onMessage(String iText) {
                        OLogManager.instance().info((Object)this, iText, new Object[0]);
                    }
                }, this.compressionLevel, this.bufferSize);
            }
            OFileUtils.atomicMoveWithFallback((Path)tempFilePath, (Path)filePath, (Object)this);
        }
        catch (Exception e) {
            OLogManager.instance().errorNoDb((Object)this, "Error during backup processing, file %s will be deleted\n", (Throwable)e, new Object[]{tempFileName});
            Files.deleteIfExists(tempFilePath);
            throw e;
        }
    }

    protected void exportDatabase(String dbURL, String iPath, ODatabaseDocumentInternal db) throws IOException {
        OLogManager.instance().info((Object)this, "AutomaticBackup: executing export of database '%s' to %s", new Object[]{dbURL, iPath});
        ODatabaseExport exp = new ODatabaseExport(db, iPath, new OCommandOutputListener(){

            public void onMessage(String iText) {
                OLogManager.instance().info((Object)this, iText, new Object[0]);
            }
        });
        if (this.exportOptions != null && !this.exportOptions.trim().isEmpty()) {
            exp.setOptions(this.exportOptions.trim());
        }
        exp.exportDatabase().close();
    }

    protected String getFileName(final Map.Entry<String, String> dbName) {
        return (String)OVariableParser.resolveVariables((String)this.targetFileName, (String)"${", (String)"}", (OVariableParserListener)new OVariableParserListener(){

            public String resolve(String iVariable) {
                if (iVariable.equalsIgnoreCase(VARIABLES.DBNAME.toString())) {
                    return (String)dbName.getKey();
                }
                if (iVariable.startsWith(VARIABLES.DATE.toString())) {
                    return new SimpleDateFormat(iVariable.substring(VARIABLES.DATE.toString().length() + 1)).format(new Date());
                }
                throw new IllegalArgumentException("Variable '" + iVariable + "' was not found");
            }
        });
    }

    public String getName() {
        return "automaticBackup";
    }

    @Override
    public ODocument getConfig() {
        return this.configuration;
    }

    @Override
    public void changeConfig(ODocument document) {
    }

    public void registerListener(OAutomaticBackupListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(OAutomaticBackupListener listener) {
        this.listeners.remove(listener);
    }

    public static interface OAutomaticBackupListener {
        public void onBackupCompleted(String var1);

        public void onBackupError(String var1, Exception var2);
    }

    public static enum MODE {
        FULL_BACKUP,
        INCREMENTAL_BACKUP,
        EXPORT;

    }

    public static enum VARIABLES {
        DBNAME,
        DATE;

    }
}

