/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.enterprise.channel.text.OChannelTextServer;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.network.protocol.http.OHttpNetworkCommandManager;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpUtils;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import com.orientechnologies.orient.server.network.protocol.http.command.all.OServerCommandFunction;
import com.orientechnologies.orient.server.network.protocol.http.command.delete.OServerCommandDeleteClass;
import com.orientechnologies.orient.server.network.protocol.http.command.delete.OServerCommandDeleteDatabase;
import com.orientechnologies.orient.server.network.protocol.http.command.delete.OServerCommandDeleteDocument;
import com.orientechnologies.orient.server.network.protocol.http.command.delete.OServerCommandDeleteIndex;
import com.orientechnologies.orient.server.network.protocol.http.command.delete.OServerCommandDeleteProperty;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetClass;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetCluster;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetConnect;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetConnections;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetDatabase;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetDictionary;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetDisconnect;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetDocument;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetDocumentByClass;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetExportDatabase;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetFileDownload;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetIndex;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetListDatabases;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetPing;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetQuery;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetSSO;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetServer;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetServerVersion;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetStorageAllocation;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetSupportedLanguages;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandIsEnterprise;
import com.orientechnologies.orient.server.network.protocol.http.command.options.OServerCommandOptions;
import com.orientechnologies.orient.server.network.protocol.http.command.patch.OServerCommandPatchDocument;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostAuthToken;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostBatch;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostClass;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostCommandGraph;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostDatabase;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostDocument;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostImportRecords;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostInstallDatabase;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostKillDbConnection;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostProperty;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostServer;
import com.orientechnologies.orient.server.network.protocol.http.command.post.OServerCommandPostStudio;
import com.orientechnologies.orient.server.network.protocol.http.command.put.OServerCommandPostConnection;
import com.orientechnologies.orient.server.network.protocol.http.command.put.OServerCommandPutDocument;
import com.orientechnologies.orient.server.network.protocol.http.command.put.OServerCommandPutIndex;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartBaseInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;

public abstract class ONetworkProtocolHttpAbstract
extends ONetworkProtocol {
    private static final String COMMAND_SEPARATOR = "|";
    private static final Charset utf8 = Charset.forName("utf8");
    private static int requestMaxContentLength;
    private static int socketTimeout;
    private final StringBuilder requestContent = new StringBuilder(512);
    protected OClientConnection connection;
    protected OChannelTextServer channel;
    protected OUser account;
    protected OHttpRequest request;
    protected OHttpResponse response;
    protected OHttpNetworkCommandManager cmdManager;
    private String responseCharSet;
    private boolean jsonResponseError;
    private String[] additionalResponseHeaders;
    private String listeningAddress = "?";
    private OContextConfiguration configuration;

    public ONetworkProtocolHttpAbstract(OServer server) {
        super(server.getThreadGroup(), "IO-HTTP");
    }

    @Override
    public void config(OServerNetworkListener iListener, OServer iServer, Socket iSocket, OContextConfiguration iConfiguration) throws IOException {
        String addHeaders;
        this.configuration = iConfiguration;
        boolean installDefaultCommands = iConfiguration.getValueAsBoolean(OGlobalConfiguration.NETWORK_HTTP_INSTALL_DEFAULT_COMMANDS);
        if (installDefaultCommands) {
            this.registerStatelessCommands(iListener);
        }
        if ((addHeaders = iConfiguration.getValueAsString("network.http.additionalResponseHeaders", null)) != null) {
            this.additionalResponseHeaders = addHeaders.split(";");
        }
        this.connection = iServer.getClientConnectionManager().connect(this);
        this.server = iServer;
        requestMaxContentLength = iConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_HTTP_MAX_CONTENT_LENGTH);
        socketTimeout = iConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_TIMEOUT);
        this.responseCharSet = iConfiguration.getValueAsString(OGlobalConfiguration.NETWORK_HTTP_CONTENT_CHARSET);
        this.jsonResponseError = iConfiguration.getValueAsBoolean(OGlobalConfiguration.NETWORK_HTTP_JSON_RESPONSE_ERROR);
        this.channel = new OChannelTextServer(iSocket, iConfiguration);
        this.channel.connected();
        this.connection.getData().caller = this.channel.toString();
        this.listeningAddress = this.getListeningAddress();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service() throws ONetworkProtocolException, IOException {
        boolean isChain;
        ++this.connection.getStats().totalRequests;
        this.connection.getData().commandInfo = null;
        this.connection.getData().commandDetail = null;
        String callbackF = this.server.getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.NETWORK_HTTP_JSONP_ENABLED) && this.request.parameters != null && this.request.parameters.containsKey("callback") ? this.request.parameters.get("callback") : null;
        this.response = new OHttpResponse(this.channel.outStream, this.request.httpVersion, this.additionalResponseHeaders, this.responseCharSet, this.connection.getData().serverInfo, this.request.sessionId, callbackF, this.request.keepAlive, this.connection);
        this.response.setJsonErrorResponse(this.jsonResponseError);
        if (this.request.contentEncoding != null && this.request.contentEncoding.equals("gzip")) {
            this.response.setContentEncoding("gzip");
        }
        if (this.request.contentEncoding != null && this.request.contentEncoding.contains("gzip")) {
            this.response.setStaticEncoding("gzip");
        }
        long begin = System.currentTimeMillis();
        do {
            isChain = false;
            String command = this.request.url.length() < 2 ? "" : this.request.url.substring(1);
            String commandString = this.getCommandString(command);
            OServerCommand cmd = (OServerCommand)this.cmdManager.getCommand(commandString);
            Map<String, String> requestParams = this.cmdManager.extractUrlTokens(commandString);
            if (requestParams != null) {
                if (this.request.parameters == null) {
                    this.request.parameters = new HashMap<String, String>();
                }
                for (Map.Entry<String, String> entry : requestParams.entrySet()) {
                    this.request.parameters.put(entry.getKey(), URLDecoder.decode(entry.getValue(), "UTF-8"));
                }
            }
            if (cmd != null) {
                try {
                    if (!cmd.beforeExecute(this.request, this.response)) continue;
                    try {
                        isChain = cmd.execute(this.request, this.response);
                    }
                    finally {
                        cmd.afterExecute(this.request, this.response);
                    }
                }
                catch (Exception e) {
                    this.handleError(e, this.request);
                }
                continue;
            }
            try {
                OLogManager.instance().warn((Object)this, "->" + this.channel.socket.getInetAddress().getHostAddress() + ": Command not found: " + this.request.httpMethod + "." + URLDecoder.decode(command, "UTF-8"), new Object[0]);
                this.sendError(405, "Method Not Allowed", null, "text/plain", "Command not found: " + command, this.request.keepAlive);
            }
            catch (IOException e1) {
                this.sendShutdown();
            }
        } while (isChain);
        this.connection.getStats().lastCommandInfo = this.connection.getData().commandInfo;
        this.connection.getStats().lastCommandDetail = this.connection.getData().commandDetail;
        this.connection.getStats().activeQueries = this.getActiveQueries(this.connection.getDatabase());
        this.connection.getStats().lastCommandExecutionTime = System.currentTimeMillis() - begin;
        this.connection.getStats().totalCommandExecutionTime += this.connection.getStats().lastCommandExecutionTime;
    }

    private List<String> getActiveQueries(ODatabaseDocumentInternal database) {
        if (database == null) {
            return null;
        }
        try {
            Map queries = database.getActiveQueries();
            return queries.values().stream().map(x -> x.getExecutionPlan()).filter(x -> x.isPresent() && x.get() instanceof OInternalExecutionPlan).map(OInternalExecutionPlan.class::cast).map(x -> x.getStatement()).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void sendShutdown() {
        super.sendShutdown();
        try {
            if (this.channel.socket != null) {
                this.channel.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdown() {
        try {
            this.sendShutdown();
            this.channel.close();
        }
        finally {
            this.server.getClientConnectionManager().disconnect(this.connection.getId());
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Connection closed", new Object[0]);
            }
        }
    }

    public OHttpRequest getRequest() {
        return this.request;
    }

    public OHttpResponse getResponse() {
        return this.response;
    }

    @Override
    public OChannel getChannel() {
        return this.channel;
    }

    public OUser getAccount() {
        return this.account;
    }

    public String getSessionID() {
        return this.request.sessionId;
    }

    public String getResponseCharSet() {
        return this.responseCharSet;
    }

    public void setResponseCharSet(String responseCharSet) {
        this.responseCharSet = responseCharSet;
    }

    public String[] getAdditionalResponseHeaders() {
        return this.additionalResponseHeaders;
    }

    public OHttpNetworkCommandManager getCommandManager() {
        return this.cmdManager;
    }

    protected void handleError(Throwable e, OHttpRequest iRequest) {
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Caught exception", e, new Object[0]);
        }
        int errorCode = 500;
        String errorReason = null;
        String errorMessage = null;
        String responseHeaders = null;
        if (e instanceof IllegalFormatException || e instanceof InputMismatchException) {
            errorCode = 400;
            errorReason = "Bad request";
        } else if (e instanceof ORecordNotFoundException) {
            errorCode = 404;
            errorReason = "Not Found";
        } else if (e instanceof OConcurrentModificationException) {
            errorCode = 409;
            errorReason = "Conflict";
        } else if (e instanceof OLockException) {
            errorCode = 423;
        } else if (e instanceof UnsupportedOperationException) {
            errorCode = 501;
            errorReason = "Not Implemented";
        } else if (e instanceof IllegalArgumentException) {
            errorCode = 500;
        }
        if (e instanceof ODatabaseException || e instanceof OSecurityAccessException || e instanceof OCommandExecutionException || e instanceof OLockException) {
            Throwable cause;
            do {
                Throwable throwable = cause = e instanceof OSecurityAccessException ? e : e.getCause();
                if (cause instanceof OSecurityAccessException) {
                    if (this.account == null) {
                        errorCode = 401;
                        errorReason = "Unauthorized";
                        String xRequestedWithHeader = iRequest.getHeader("X-Requested-With");
                        if (xRequestedWithHeader == null || !xRequestedWithHeader.equals("XMLHttpRequest")) {
                            responseHeaders = this.server.getSecurity().getAuthenticationHeader(((OSecurityAccessException)cause).getDatabaseName());
                        }
                        errorMessage = null;
                    } else {
                        errorCode = 530;
                        errorReason = "The current user does not have the privileges to execute the request.";
                        errorMessage = "530 User access denied";
                    }
                    break;
                }
                if (cause == null) continue;
                e = cause;
            } while (cause != null);
        } else if (e instanceof OCommandSQLParsingException) {
            errorMessage = e.getMessage();
            errorCode = 400;
        }
        if (errorMessage == null) {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append(e);
            for (Throwable cause = e.getCause(); cause != null && cause != cause.getCause(); cause = cause.getCause()) {
                buffer.append("\r\n--> ");
                buffer.append(cause);
            }
            errorMessage = buffer.toString();
        }
        if (errorReason == null) {
            errorReason = "Internal Server Error";
            if (e instanceof NullPointerException) {
                OLogManager.instance().error((Object)this, "Internal server error:\n", e, new Object[0]);
            } else {
                OLogManager.instance().debug((Object)this, "Internal server error:\n", e, new Object[0]);
            }
        }
        try {
            this.sendError(errorCode, errorReason, responseHeaders, "text/plain", errorMessage, this.request.keepAlive);
        }
        catch (IOException e1) {
            this.sendShutdown();
        }
    }

    protected void sendTextContent(int iCode, String iReason, String iHeaders, String iContentType, String iContent, boolean iKeepAlive) throws IOException {
        boolean empty = iContent == null || iContent.length() == 0;
        this.sendStatus(empty && iCode == 200 ? 204 : iCode, iReason);
        this.sendResponseHeaders(iContentType, iKeepAlive);
        if (iHeaders != null) {
            this.writeLine(iHeaders);
        }
        byte[] binaryContent = empty ? null : iContent.getBytes(utf8);
        this.writeLine("Content-Length: " + (empty ? 0 : binaryContent.length));
        this.writeLine(null);
        if (binaryContent != null) {
            this.channel.writeBytes(binaryContent);
        }
        this.channel.flush();
    }

    protected void sendError(int iCode, String iReason, String iHeaders, String iContentType, String iContent, boolean iKeepAlive) throws IOException {
        if (!this.jsonResponseError) {
            this.sendTextContent(iCode, iReason, iHeaders, iContentType, iContent, iKeepAlive);
            return;
        }
        this.sendStatus(iCode, iReason);
        this.sendResponseHeaders("application/json", iKeepAlive);
        if (iHeaders != null) {
            this.writeLine(iHeaders);
        }
        ODocument response = new ODocument();
        ODocument error = new ODocument();
        error.field("code", (Object)iCode);
        error.field("reason", (Object)iCode);
        error.field("content", (Object)iContent);
        ArrayList<ODocument> errors = new ArrayList<ODocument>();
        errors.add(error);
        response.field("errors", errors);
        byte[] binaryContent = response.toJSON("prettyPrint").getBytes(utf8);
        this.writeLine("Content-Length: " + (binaryContent != null ? binaryContent.length : 0));
        this.writeLine(null);
        if (binaryContent != null) {
            this.channel.writeBytes(binaryContent);
        }
        this.channel.flush();
    }

    protected void writeLine(String iContent) throws IOException {
        if (iContent != null) {
            this.channel.outStream.write(iContent.getBytes());
        }
        this.channel.outStream.write(OHttpUtils.EOL);
    }

    protected void sendStatus(int iStatus, String iReason) throws IOException {
        this.writeLine(this.request.httpVersion + " " + iStatus + " " + iReason);
    }

    protected void sendResponseHeaders(String iContentType, boolean iKeepAlive) throws IOException {
        this.writeLine("Cache-Control: no-cache, no-store, max-age=0, must-revalidate");
        this.writeLine("Pragma: no-cache");
        this.writeLine("Date: " + new Date());
        this.writeLine("Content-Type: " + iContentType + "; charset=" + this.responseCharSet);
        this.writeLine("Server: " + this.connection.getData().serverInfo);
        this.writeLine("Connection: " + (iKeepAlive ? "Keep-Alive" : "close"));
        if (this.getAdditionalResponseHeaders() != null) {
            for (String h : this.getAdditionalResponseHeaders()) {
                this.writeLine(h);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readAllContent(OHttpRequest iRequest) throws IOException {
        byte in;
        iRequest.content = null;
        int contentLength = -1;
        boolean endOfHeaders = false;
        StringBuilder request = new StringBuilder(512);
        while (!this.channel.socket.isInputShutdown() && (in = this.channel.read()) != -1) {
            char currChar = (char)in;
            if (currChar == '\r') {
                if (request.length() > 0 && !endOfHeaders) {
                    String line = request.toString();
                    if (OStringSerializerHelper.startsWithIgnoreCase((String)line, (String)"Authorization: ")) {
                        String auth = line.substring("Authorization: ".length());
                        if (OStringSerializerHelper.startsWithIgnoreCase((String)auth, (String)"Basic")) {
                            iRequest.authorization = auth.substring("Basic".length() + 1);
                            iRequest.authorization = new String(Base64.getDecoder().decode(iRequest.authorization));
                        } else if (OStringSerializerHelper.startsWithIgnoreCase((String)auth, (String)"Bearer")) {
                            iRequest.bearerTokenRaw = auth.substring("Bearer".length() + 1);
                        } else {
                            if (!OStringSerializerHelper.startsWithIgnoreCase((String)auth, (String)"Negotiate")) throw new IllegalArgumentException("Only HTTP Basic and Bearer authorization are supported");
                            iRequest.authorization = "Negotiate:" + auth.substring("Negotiate".length() + 1);
                        }
                    } else if (OStringSerializerHelper.startsWithIgnoreCase((String)line, (String)"Connection: ")) {
                        iRequest.keepAlive = line.substring("Connection: ".length()).equalsIgnoreCase("Keep-Alive");
                    } else if (OStringSerializerHelper.startsWithIgnoreCase((String)line, (String)"Cookie: ")) {
                        String[] sessionItems;
                        String sessionPair = line.substring("Cookie: ".length());
                        for (String sessionItem : sessionItems = sessionPair.split(";")) {
                            String[] sessionPairItems = sessionItem.trim().split("=");
                            if (sessionPairItems.length != 2 || !"OSESSIONID".equals(sessionPairItems[0])) continue;
                            iRequest.sessionId = sessionPairItems[1];
                            break;
                        }
                    } else if (OStringSerializerHelper.startsWithIgnoreCase((String)line, (String)"Content-Length: ")) {
                        contentLength = Integer.parseInt(line.substring("Content-Length: ".length()));
                        if (contentLength > requestMaxContentLength) {
                            OLogManager.instance().warn((Object)this, "->" + this.channel.socket.getInetAddress().getHostAddress() + ": Error on content size " + contentLength + ": the maximum allowed is " + requestMaxContentLength, new Object[0]);
                        }
                    } else if (OStringSerializerHelper.startsWithIgnoreCase((String)line, (String)"Content-Type: ")) {
                        iRequest.contentType = line.substring("Content-Type: ".length());
                        if (OStringSerializerHelper.startsWithIgnoreCase((String)iRequest.contentType, (String)"multipart/form-data")) {
                            iRequest.isMultipart = true;
                            iRequest.boundary = new String(line.substring("Content-Type: ".length() + "multipart/form-data".length() + 2 + "boundary".length() + 1));
                        }
                    } else if (OStringSerializerHelper.startsWithIgnoreCase((String)line, (String)"If-Match: ")) {
                        iRequest.ifMatch = line.substring("If-Match: ".length());
                    } else if (OStringSerializerHelper.startsWithIgnoreCase((String)line, (String)"X-Forwarded-For: ")) {
                        this.connection.getData().caller = line.substring("X-Forwarded-For: ".length());
                    } else if (OStringSerializerHelper.startsWithIgnoreCase((String)line, (String)"OAuthentication: ")) {
                        iRequest.authentication = line.substring("OAuthentication: ".length());
                    } else if (OStringSerializerHelper.startsWithIgnoreCase((String)line, (String)"Expect: 100-continue")) {
                        this.sendTextContent(100, null, null, null, null, iRequest.keepAlive);
                    } else if (OStringSerializerHelper.startsWithIgnoreCase((String)line, (String)"Accept-Encoding: ")) {
                        iRequest.contentEncoding = line.substring("Accept-Encoding: ".length());
                    }
                    iRequest.addHeader(line);
                }
                if ((in = this.channel.read()) == -1) break;
                currChar = (char)in;
                if (!endOfHeaders && request.length() == 0) {
                    if (contentLength <= 0) {
                        return;
                    }
                    endOfHeaders = true;
                }
                request.setLength(0);
                continue;
            }
            if (endOfHeaders && request.length() == 0 && currChar != '\r' && currChar != '\n') {
                if (iRequest.isMultipart) {
                    iRequest.content = "";
                    iRequest.multipartStream = new OHttpMultipartBaseInputStream(this.channel.inStream, currChar, contentLength);
                    return;
                }
                byte[] buffer = new byte[contentLength];
                buffer[0] = (byte)currChar;
                this.channel.read(buffer, 1, contentLength - 1);
                iRequest.content = iRequest.contentEncoding != null && iRequest.contentEncoding.equals("gzip") ? this.deCompress(buffer) : new String(buffer);
                return;
            }
            request.append(currChar);
        }
        if (!OLogManager.instance().isDebugEnabled()) return;
        OLogManager.instance().debug((Object)this, "Error on parsing HTTP content from client %s:\n%s", new Object[]{this.channel.socket.getInetAddress().getHostAddress(), request});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        if (this.channel.socket.isInputShutdown() || this.channel.socket.isClosed()) {
            this.connectionClosed();
            return;
        }
        this.connection.getData().commandInfo = "Listening";
        this.connection.getData().commandDetail = null;
        try {
            this.channel.socket.setSoTimeout(socketTimeout);
            this.connection.getStats().lastCommandReceived = -1L;
            char c = (char)this.channel.read();
            if (this.channel.inStream.available() == 0) {
                this.connectionClosed();
                return;
            }
            this.channel.socket.setSoTimeout(socketTimeout);
            this.connection.getStats().lastCommandReceived = System.currentTimeMillis();
            this.request = new OHttpRequest(this, this.channel.inStream, this.connection.getData(), this.configuration);
            this.requestContent.setLength(0);
            this.request.isMultipart = false;
            if (c != '\n') {
                this.requestContent.append(c);
            }
            while (!this.channel.socket.isInputShutdown()) {
                c = (char)this.channel.read();
                if (c == '\r') {
                    String[] words = this.requestContent.toString().split(" ");
                    if (words.length < 3) {
                        OLogManager.instance().warn((Object)this, "->" + this.channel.socket.getInetAddress().getHostAddress() + ": Error on invalid content:\n" + this.requestContent, new Object[0]);
                        while (this.channel.inStream.available() > 0) {
                            this.channel.read();
                        }
                        break;
                    }
                    this.channel.read();
                    this.request.httpMethod = words[0].toUpperCase(Locale.ENGLISH);
                    this.request.url = words[1].trim();
                    int parametersPos = this.request.url.indexOf(63);
                    if (parametersPos > -1) {
                        this.request.parameters = OHttpUtils.getParameters(this.request.url.substring(parametersPos));
                        this.request.url = this.request.url.substring(0, parametersPos);
                    }
                    this.request.httpVersion = words[2];
                    this.readAllContent(this.request);
                    if (this.request.content != null && this.request.contentType != null && this.request.contentType.equals("application/x-www-form-urlencoded")) {
                        this.request.content = URLDecoder.decode(this.request.content, "UTF-8").trim();
                    }
                    if (OLogManager.instance().isDebugEnabled()) {
                        OLogManager.instance().debug((Object)this, "[ONetworkProtocolHttpAbstract.execute] Requested: %s %s", new Object[]{this.request.httpMethod, this.request.url});
                    }
                    this.service();
                    return;
                }
                this.requestContent.append(c);
                if (OGlobalConfiguration.NETWORK_HTTP_MAX_CONTENT_LENGTH.getValueAsInteger() <= -1 || this.requestContent.length() < 10000 + OGlobalConfiguration.NETWORK_HTTP_MAX_CONTENT_LENGTH.getValueAsInteger() * 2) continue;
                while (this.channel.inStream.available() > 0) {
                    this.channel.read();
                }
                throw new ONetworkProtocolException("Invalid http request, max content length exceeded");
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Parsing request from client " + this.channel.socket.getInetAddress().getHostAddress() + ":\n" + this.requestContent, new Object[0]);
            }
        }
        catch (SocketException e) {
            this.connectionError();
        }
        catch (SocketTimeoutException e) {
            this.timeout();
        }
        catch (Exception t) {
            if (this.request.httpMethod != null && this.request.url != null) {
                try {
                    this.sendError(505, "Error on executing of " + this.request.httpMethod + " for the resource: " + this.request.url, null, "text/plain", t.toString(), this.request.keepAlive);
                }
                catch (IOException iOException) {}
            } else {
                this.sendError(505, "Error on executing request", null, "text/plain", t.toString(), this.request.keepAlive);
            }
            this.readAllContent(this.request);
        }
        finally {
            if (this.connection.getStats().lastCommandReceived > -1L) {
                Orient.instance().getProfiler().stopChrono("server.network.requests", "Total received requests", this.connection.getStats().lastCommandReceived, "server.network.requests");
            }
            this.request = null;
            this.response = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String deCompress(byte[] zipBytes) {
        if (zipBytes == null || zipBytes.length == 0) {
            return null;
        }
        GZIPInputStream gzip = null;
        ByteArrayInputStream in = null;
        ByteArrayOutputStream baos = null;
        try {
            String newstr;
            in = new ByteArrayInputStream(zipBytes);
            gzip = new GZIPInputStream((InputStream)in, 16384);
            byte[] buffer = new byte[1024];
            baos = new ByteArrayOutputStream();
            int len = -1;
            while ((len = gzip.read(buffer, 0, buffer.length)) != -1) {
                baos.write(buffer, 0, len);
            }
            String string = newstr = new String(baos.toByteArray(), "UTF-8");
            return string;
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "Error on decompressing HTTP response", (Throwable)ex, new Object[0]);
        }
        finally {
            try {
                if (gzip != null) {
                    gzip.close();
                }
                if (in != null) {
                    in.close();
                }
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    protected void connectionClosed() {
        Orient.instance().getProfiler().updateCounter("server.http." + this.listeningAddress + ".closed", "Close HTTP connection", 1L, "server.http.*.closed");
        this.sendShutdown();
    }

    protected void timeout() {
        Orient.instance().getProfiler().updateCounter("server.http." + this.listeningAddress + ".timeout", "Timeout of HTTP connection", 1L, "server.http.*.timeout");
        this.sendShutdown();
    }

    protected void connectionError() {
        Orient.instance().getProfiler().updateCounter("server.http." + this.listeningAddress + ".errors", "Error on HTTP connection", 1L, "server.http.*.errors");
        this.sendShutdown();
    }

    protected void registerStatelessCommands(OServerNetworkListener iListener) {
        this.cmdManager = new OHttpNetworkCommandManager(this.server, null);
        this.cmdManager.registerCommand(new OServerCommandGetConnect());
        this.cmdManager.registerCommand(new OServerCommandGetDisconnect());
        this.cmdManager.registerCommand(new OServerCommandGetClass());
        this.cmdManager.registerCommand(new OServerCommandGetCluster());
        this.cmdManager.registerCommand(new OServerCommandGetDatabase());
        this.cmdManager.registerCommand(new OServerCommandGetDictionary());
        this.cmdManager.registerCommand(new OServerCommandGetDocument());
        this.cmdManager.registerCommand(new OServerCommandGetDocumentByClass());
        this.cmdManager.registerCommand(new OServerCommandGetQuery());
        this.cmdManager.registerCommand(new OServerCommandGetServer());
        this.cmdManager.registerCommand(new OServerCommandGetServerVersion());
        this.cmdManager.registerCommand(new OServerCommandGetConnections());
        this.cmdManager.registerCommand(new OServerCommandGetStorageAllocation());
        this.cmdManager.registerCommand(new OServerCommandGetFileDownload());
        this.cmdManager.registerCommand(new OServerCommandGetIndex());
        this.cmdManager.registerCommand(new OServerCommandGetListDatabases());
        this.cmdManager.registerCommand(new OServerCommandIsEnterprise());
        this.cmdManager.registerCommand(new OServerCommandGetExportDatabase());
        this.cmdManager.registerCommand(new OServerCommandPatchDocument());
        this.cmdManager.registerCommand(new OServerCommandPostBatch());
        this.cmdManager.registerCommand(new OServerCommandPostClass());
        this.cmdManager.registerCommand(new OServerCommandPostCommandGraph());
        this.cmdManager.registerCommand(new OServerCommandPostDatabase());
        this.cmdManager.registerCommand(new OServerCommandPostInstallDatabase());
        this.cmdManager.registerCommand(new OServerCommandPostDocument());
        this.cmdManager.registerCommand(new OServerCommandPostImportRecords());
        this.cmdManager.registerCommand(new OServerCommandPostProperty());
        this.cmdManager.registerCommand(new OServerCommandPostConnection());
        this.cmdManager.registerCommand(new OServerCommandPostServer());
        this.cmdManager.registerCommand(new OServerCommandPostStudio());
        this.cmdManager.registerCommand(new OServerCommandPutDocument());
        this.cmdManager.registerCommand(new OServerCommandPutIndex());
        this.cmdManager.registerCommand(new OServerCommandDeleteClass());
        this.cmdManager.registerCommand(new OServerCommandDeleteDatabase());
        this.cmdManager.registerCommand(new OServerCommandDeleteDocument());
        this.cmdManager.registerCommand(new OServerCommandDeleteProperty());
        this.cmdManager.registerCommand(new OServerCommandDeleteIndex());
        this.cmdManager.registerCommand(new OServerCommandOptions());
        this.cmdManager.registerCommand(new OServerCommandFunction());
        this.cmdManager.registerCommand(new OServerCommandPostKillDbConnection());
        this.cmdManager.registerCommand(new OServerCommandGetSupportedLanguages());
        this.cmdManager.registerCommand(new OServerCommandPostAuthToken());
        this.cmdManager.registerCommand(new OServerCommandGetSSO());
        this.cmdManager.registerCommand(new OServerCommandGetPing());
        for (OServerCommandConfiguration oServerCommandConfiguration : iListener.getStatefulCommands()) {
            try {
                this.cmdManager.registerCommand(OServerNetworkListener.createCommand(this.server, oServerCommandConfiguration));
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on creating stateful command '%s'", (Throwable)e, new Object[]{oServerCommandConfiguration.implementation});
            }
        }
        for (OServerCommand oServerCommand : iListener.getStatelessCommands()) {
            this.cmdManager.registerCommand(oServerCommand);
        }
    }

    private String getCommandString(String command) {
        int getQueryPosition = command.indexOf(63);
        StringBuilder commandString = new StringBuilder(256);
        commandString.append(this.request.httpMethod);
        commandString.append(COMMAND_SEPARATOR);
        if (getQueryPosition > -1) {
            commandString.append(command.substring(0, getQueryPosition));
        } else {
            commandString.append(command);
        }
        return commandString.toString();
    }
}

