/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.conflict;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolver;
import com.orientechnologies.orient.server.distributed.conflict.OMajorityDistributedConflictResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OContentDistributedConflictResolver
extends OMajorityDistributedConflictResolver {
    public static final String NAME = "content";

    @Override
    public ODistributedConflictResolver.OConflictResult onConflict(String databaseName, String clusterName, ORecordId rid, ODistributedServerManager dManager, Map<Object, List<String>> candidates, ODocument config) {
        ODistributedConflictResolver.OConflictResult result = new ODistributedConflictResolver.OConflictResult();
        if (!candidates.isEmpty()) {
            HashMap candidatesGroupedByContent = new HashMap();
            for (Map.Entry<Object, List<String>> entry : candidates.entrySet()) {
                Object object = entry.getKey();
                if (!(object instanceof ORawBuffer)) continue;
                byte[] byArray = ((ORawBuffer)object).buffer;
                boolean matched = false;
                for (Map.Entry matchEntry : candidatesGroupedByContent.entrySet()) {
                    if (!Arrays.equals(byArray, (byte[])matchEntry.getKey())) continue;
                    ((List)matchEntry.getValue()).addAll((Collection)entry.getValue());
                    matched = true;
                    break;
                }
                if (matched) continue;
                candidatesGroupedByContent.put(byArray, entry.getValue());
            }
            if (!candidatesGroupedByContent.isEmpty()) {
                int maxServerList = -1;
                for (Map.Entry entry : candidatesGroupedByContent.entrySet()) {
                    List list = (List)entry.getValue();
                    if (list.size() <= maxServerList) continue;
                    maxServerList = list.size();
                }
                ArrayList winners = new ArrayList();
                for (Map.Entry entry : candidatesGroupedByContent.entrySet()) {
                    List servers = (List)entry.getValue();
                    if (servers.size() != maxServerList) continue;
                    winners.add(entry.getKey());
                }
                if (winners.size() == 1) {
                    int n;
                    byte[] byArray = (byte[])winners.get(0);
                    int n2 = -1;
                    for (Map.Entry<Object, List<String>> entry : candidates.entrySet()) {
                        byte[] content;
                        Object key = entry.getKey();
                        if (!(key instanceof ORawBuffer) || !Arrays.equals(byArray, content = ((ORawBuffer)key).buffer) || ((ORawBuffer)key).version <= n) continue;
                        n = ((ORawBuffer)key).version;
                        result.winner = key;
                    }
                    OLogManager.instance().debug((Object)this, "Content Conflict Resolver decided the value '%s' is the winner for record %s, because the content is the majority. Assigning the highest version (%d)", new Object[]{result.winner, rid, n});
                } else {
                    result.candidates = candidates;
                    OLogManager.instance().debug((Object)this, "Content Conflict Resolver cannot decide the winner for record %s, because there is no majoriy in the content", new Object[]{rid});
                }
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

