/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPage;
import java.nio.ByteBuffer;

public class OWALPageV1
implements OWALPage {
    static final long MAGIC_NUMBER = 4207608830L;
    static final int RECORDS_OFFSET = 16;
    static final int MAX_ENTRY_SIZE = PAGE_SIZE - 16;
    private final ByteBuffer buffer;

    OWALPageV1(ByteBuffer buffer, boolean isNew) {
        this.buffer = buffer;
        if (isNew) {
            buffer.position(4);
            buffer.putLong(4207608830L);
            buffer.putInt(MAX_ENTRY_SIZE);
        }
    }

    @Override
    public byte[] getRecord(int position) {
        this.buffer.position(position + 2);
        int recordSize = this.buffer.getInt();
        byte[] record = new byte[recordSize];
        this.buffer.get(record);
        return record;
    }

    @Override
    public boolean mergeWithNextPage(int position) {
        return this.buffer.get(position) > 0;
    }

    @Override
    public int getFreeSpace() {
        return this.buffer.getInt(12);
    }

    static int calculateSerializedSize(int recordSize) {
        return recordSize + 4 + 2;
    }

    static int calculateRecordSize(int serializedSize) {
        return serializedSize - 4 - 2;
    }
}

