/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.core.IMap;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.Preconditions;

class DefaultQueryCacheRequest
implements QueryCacheRequest {
    private IMap map;
    private String cacheName;
    private Predicate predicate;
    private Boolean includeValue;
    private MapListener listener;
    private QueryCacheContext context;
    private String mapName;
    private String userGivenCacheName;

    DefaultQueryCacheRequest() {
    }

    @Override
    public QueryCacheRequest forMap(IMap map) {
        this.map = Preconditions.checkNotNull(map, "map cannot be null");
        this.mapName = map.getName();
        return this;
    }

    @Override
    public QueryCacheRequest withCacheName(String cacheName) {
        this.cacheName = Preconditions.checkHasText(cacheName, "cacheName");
        return this;
    }

    @Override
    public QueryCacheRequest withUserGivenCacheName(String userGivenCacheName) {
        this.userGivenCacheName = Preconditions.checkHasText(userGivenCacheName, "userGivenCacheName");
        return this;
    }

    @Override
    public QueryCacheRequest withPredicate(Predicate predicate) {
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, "predicate");
        this.predicate = predicate;
        return this;
    }

    @Override
    public QueryCacheRequest withListener(MapListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public QueryCacheRequest withIncludeValue(Boolean includeValue) {
        this.includeValue = includeValue;
        return this;
    }

    @Override
    public QueryCacheRequest withContext(QueryCacheContext context) {
        this.context = Preconditions.checkNotNull(context, "context can not be null");
        return this;
    }

    @Override
    public IMap getMap() {
        return this.map;
    }

    @Override
    public String getMapName() {
        return this.mapName;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public String getUserGivenCacheName() {
        return this.userGivenCacheName;
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public MapListener getListener() {
        return this.listener;
    }

    @Override
    public Boolean isIncludeValue() {
        return this.includeValue;
    }

    @Override
    public QueryCacheContext getContext() {
        return this.context;
    }
}

