/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MapIndexConfigReadOnly;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.query.QueryConstants;
import com.hazelcast.util.Preconditions;

public class MapIndexConfig {
    private static final ILogger LOG = Logger.getLogger(MapIndexConfig.class);
    private String attribute;
    private boolean ordered;
    private MapIndexConfigReadOnly readOnly;

    public MapIndexConfig() {
    }

    public MapIndexConfig(String attribute, boolean ordered) {
        this.setAttribute(attribute);
        this.setOrdered(ordered);
    }

    public MapIndexConfig(MapIndexConfig config) {
        this.attribute = config.getAttribute();
        this.ordered = config.isOrdered();
    }

    public MapIndexConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new MapIndexConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public MapIndexConfig setAttribute(String attribute) {
        this.attribute = MapIndexConfig.validateIndexAttribute(attribute);
        return this;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public MapIndexConfig setOrdered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public String toString() {
        return "MapIndexConfig{attribute='" + this.attribute + "', ordered=" + this.ordered + '}';
    }

    public static String validateIndexAttribute(String attribute) {
        Preconditions.checkHasText(attribute, "Map index attribute must contain text");
        String keyPrefix = QueryConstants.KEY_ATTRIBUTE_NAME.value();
        if (attribute.startsWith(keyPrefix) && attribute.length() > keyPrefix.length() && attribute.charAt(keyPrefix.length()) != '#') {
            LOG.warning(QueryConstants.KEY_ATTRIBUTE_NAME.value() + " used without a following '#' char in index attribute '" + attribute + "'. Don't you want to index a key?");
        }
        return attribute;
    }
}

