/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tx;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;

public abstract class OLuceneTxChangesAbstract
implements OLuceneTxChanges {
    public static final String TMP = "_tmp_rid";
    protected final IndexWriter writer;
    protected final OLuceneIndexEngine engine;
    protected final IndexWriter deletedIdx;

    public OLuceneTxChangesAbstract(OLuceneIndexEngine engine, IndexWriter writer, IndexWriter deletedIdx) {
        this.writer = writer;
        this.engine = engine;
        this.deletedIdx = deletedIdx;
    }

    @Override
    public IndexSearcher searcher() {
        try {
            return new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.writer, (boolean)true));
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error during searcher instantiation", (Throwable)e, new Object[0]);
            return null;
        }
    }

    @Override
    public long deletedDocs(Query query, Filter filter) {
        try {
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.deletedIdx, (boolean)true));
            if (filter != null) {
                TopDocs search = indexSearcher.search(query, filter, Integer.MAX_VALUE);
                return search.totalHits;
            }
            TopDocs search = indexSearcher.search(query, Integer.MAX_VALUE);
            return search.totalHits;
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error during searcher instantiation", (Throwable)e, new Object[0]);
            return 0L;
        }
    }
}

