/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.lucene.analyzer.OLuceneAnalyzerFactory;
import com.orientechnologies.lucene.analyzer.OLucenePerFieldAnalyzerWrapper;
import com.orientechnologies.lucene.builder.OLuceneDocumentBuilder;
import com.orientechnologies.lucene.builder.OLuceneQueryBuilder;
import com.orientechnologies.lucene.engine.OLuceneClassIndexContext;
import com.orientechnologies.lucene.engine.OLuceneFacetManager;
import com.orientechnologies.lucene.engine.OLuceneIndexWriterFactory;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TrackingIndexWriter;
import org.apache.lucene.search.ControlledRealTimeReopenThread;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class OLuceneStorage
extends OSharedResourceAdaptiveExternal
implements OOrientListener {
    private final String name;
    private final ODocument metadata;
    protected OLuceneFacetManager facetManager;
    protected TimerTask commitTask;
    protected AtomicBoolean closed = new AtomicBoolean(true);
    protected TrackingIndexWriter mgrWriter;
    protected SearcherManager searcherManager;
    protected ControlledRealTimeReopenThread nrt;
    private OLuceneDocumentBuilder builder;
    private OLuceneQueryBuilder queryBuilder;
    private long reopenToken;
    private Analyzer indexAnalyzer;
    private Analyzer queryAnalyzer;

    public OLuceneStorage(String name, OLuceneDocumentBuilder builder, OLuceneQueryBuilder queryBuilder, ODocument metadata) {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.MVRBTREE_TIMEOUT.getValueAsInteger(), true);
        this.name = name;
        this.builder = builder;
        this.queryBuilder = queryBuilder;
        this.metadata = metadata;
        this.indexAnalyzer = new OLucenePerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer());
        this.queryAnalyzer = new OLucenePerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer());
        try {
            this.reOpen();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on initializing Lucene index", (Throwable)e, new Object[0]);
        }
        Orient.instance().registerListener((OOrientListener)this);
        this.commitTask = new TimerTask(){

            @Override
            public void run() {
                if (Boolean.FALSE.equals(OLuceneStorage.this.closed.get())) {
                    OLuceneStorage.this.commit();
                }
            }
        };
        Orient.instance().scheduleTask(this.commitTask, 10000L, 10000L);
        OLogManager.instance().info((Object)this, "Index storage CREATED, timerTASK scheduled", new Object[0]);
    }

    private void reOpen() throws IOException {
        if (this.mgrWriter != null) {
            OLogManager.instance().info((Object)this, "index storage is open don't reopen", new Object[0]);
            return;
        }
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().get();
        OAbstractPaginatedStorage storageLocalAbstract = (OAbstractPaginatedStorage)database.getStorage().getUnderlying();
        RAMDirectory dir = null;
        if (storageLocalAbstract instanceof OLocalPaginatedStorage) {
            String pathname = this.getIndexPath((OLocalPaginatedStorage)storageLocalAbstract);
            OLogManager.instance().info((Object)this, "Opening NIOFS Lucene db=%s, path=%s", new Object[]{database.getName(), pathname});
            dir = NIOFSDirectory.open((Path)new File(pathname).toPath());
        } else {
            OLogManager.instance().info((Object)this, "Opening RAM Lucene index db=%s", new Object[]{database.getName()});
            dir = new RAMDirectory();
        }
        IndexWriter indexWriter = this.createIndexWriter((Directory)dir);
        this.mgrWriter = new TrackingIndexWriter(indexWriter);
        this.searcherManager = new SearcherManager(indexWriter, true, null);
        if (this.nrt != null) {
            this.nrt.close();
        }
        this.nrt = new ControlledRealTimeReopenThread(this.mgrWriter, (ReferenceManager)this.searcherManager, 60.0, 0.1);
        this.nrt.setDaemon(true);
        this.nrt.start();
        this.flush();
        OLogManager.instance().info((Object)this, "REOPEN DONE", new Object[0]);
    }

    public void commit() {
        try {
            OLogManager.instance().info((Object)this, "committing", new Object[0]);
            IndexWriter indexWriter = this.mgrWriter.getIndexWriter();
            indexWriter.forceMergeDeletes();
            indexWriter.commit();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on committing Lucene index", (Throwable)e, new Object[0]);
        }
    }

    private String getIndexPath(OLocalPaginatedStorage storageLocalAbstract) {
        return this.getIndexPath(storageLocalAbstract, "databaseIndex");
    }

    public IndexWriter createIndexWriter(Directory directory) throws IOException {
        OLuceneIndexWriterFactory fc = new OLuceneIndexWriterFactory();
        OLogManager.instance().debug((Object)this, "Creating Lucene index in '%s'...", new Object[]{directory});
        return fc.createIndexWriter(directory, this.metadata, this.indexAnalyzer());
    }

    public void flush() {
        this.commit();
    }

    private String getIndexPath(OLocalPaginatedStorage storageLocalAbstract, String indexName) {
        return storageLocalAbstract.getStoragePath() + File.separator + "luceneIndexes" + File.separator + indexName;
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public void initIndex(OLuceneClassIndexContext indexContext) {
        OLogManager.instance().info((Object)this, "START INIT initIndex:: name " + indexContext.name + " def :: " + indexContext.definition, new Object[0]);
        OLuceneAnalyzerFactory afc = new OLuceneAnalyzerFactory();
        indexContext.metadata.field("prefix_with_class_name", (Object)true, new OType[]{OType.BOOLEAN});
        this.indexAnalyzer = afc.createAnalyzer(indexContext.definition, OLuceneAnalyzerFactory.AnalyzerKind.INDEX, indexContext.metadata);
        this.queryAnalyzer = afc.createAnalyzer(indexContext.definition, OLuceneAnalyzerFactory.AnalyzerKind.QUERY, indexContext.metadata);
        OLogManager.instance().info((Object)this, "DONE INIT initIndex:: indexAnalyzer::  " + this.indexAnalyzer + " queryanalzer:: " + this.queryAnalyzer, new Object[0]);
    }

    public boolean remove(Object key, OIdentifiable value) {
        return false;
    }

    public long size() {
        try {
            return this.searcher().getIndexReader().numDocs();
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Can not calculate amount of documents", (Throwable)e, new Object[0]);
            return this.mgrWriter.getIndexWriter().maxDoc();
        }
    }

    public IndexSearcher searcher() throws IOException {
        try {
            this.nrt.waitForGeneration(this.reopenToken);
            return (IndexSearcher)this.searcherManager.acquire();
        }
        catch (InterruptedException e) {
            OLogManager.instance().error((Object)this, "Error on get searcher from Lucene index", (Throwable)e, new Object[0]);
            return null;
        }
    }

    public OLuceneTxChanges buildTxChanges() throws IOException {
        throw new RuntimeException("DON'T CALL ME");
    }

    public Query deleteQuery(String indexName, Object key, OIdentifiable value) {
        OLogManager.instance().info((Object)this, "delete with query in index::  " + indexName, new Object[0]);
        return null;
    }

    public void init() {
        OLogManager.instance().info((Object)this, "INIT", new Object[0]);
    }

    public void create(OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize) {
        OLogManager.instance().info((Object)this, "CREATE:: ", new Object[0]);
    }

    public void delete(String indexName) {
        OLogManager.instance().info((Object)this, "DELETING:: " + indexName, new Object[0]);
    }

    public void delete(ODatabaseInternal database) {
        OLogManager.instance().info((Object)this, "DELETING STORAGE:: ", new Object[0]);
        this.close();
        OAbstractPaginatedStorage storageLocalAbstract = (OAbstractPaginatedStorage)database.getStorage().getUnderlying();
        if (storageLocalAbstract instanceof OLocalPaginatedStorage) {
            String pathname = this.getIndexPath((OLocalPaginatedStorage)storageLocalAbstract);
            OFileUtils.deleteRecursively((File)new File(pathname));
        }
    }

    public void close() {
        OLogManager.instance().info((Object)this, "CLOSING  engine", new Object[0]);
        try {
            this.closeIndex();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on closing Lucene index", (Throwable)e, new Object[0]);
        }
    }

    protected void closeIndex() throws IOException {
        OLogManager.instance().debug((Object)this, "Closing Lucene engine'", new Object[0]);
        if (this.nrt != null) {
            this.nrt.interrupt();
            this.nrt.close();
        }
        if (this.commitTask != null) {
            this.commitTask.cancel();
        }
        if (this.searcherManager != null) {
            this.searcherManager.close();
        }
        if (this.mgrWriter != null) {
            this.mgrWriter.getIndexWriter().forceMergeDeletes();
            this.mgrWriter.getIndexWriter().commit();
            this.mgrWriter.getIndexWriter().close();
        }
    }

    public void deleteWithoutLoad(String indexName) {
        OLogManager.instance().info((Object)this, "DELETing withoutLoAD ::: " + indexName, new Object[0]);
    }

    public void load(String indexName, OBinarySerializer valueSerializer, boolean isAutomatic, OBinarySerializer keySerializer, OType[] keyTypes, boolean nullPointerSupport, int keySize) {
        OLogManager.instance().info((Object)this, "LOAD:: " + indexName, new Object[0]);
    }

    public boolean contains(Object key) {
        return false;
    }

    public boolean remove(Object key) {
        return false;
    }

    public void clear(String indexName) {
        OLogManager.instance().info((Object)this, "clear index:: " + indexName, new Object[0]);
    }

    public void addDocument(Document doc) {
        try {
            OLogManager.instance().debug((Object)this, "add document::  " + doc, new Object[0]);
            Term term = new Term("RID", doc.get("RID"));
            this.reopenToken = this.mgrWriter.updateDocument(term, (Iterable)doc);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on adding new document '%s' to Lucene index", (Throwable)e, new Object[]{doc});
        }
    }

    public Object getFirstKey() {
        return null;
    }

    public Object getLastKey() {
        return null;
    }

    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        return null;
    }

    public OIndexCursor cursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        return null;
    }

    public OIndexCursor descCursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        return null;
    }

    public OIndexKeyCursor keyCursor() {
        return null;
    }

    public long size(OIndexEngine.ValuesTransformer transformer) {
        return 0L;
    }

    public boolean hasRangeQuerySupport() {
        return false;
    }

    public int getVersion() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public Analyzer queryAnalyzer() {
        return this.queryAnalyzer;
    }

    public void onShutdown() {
        OLogManager.instance().info((Object)this, "ENGINE SHUTDONW", new Object[0]);
        this.close();
    }

    public void onStorageRegistered(OStorage storage) {
    }

    public void onStorageUnregistered(OStorage storage) {
    }
}

