/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.engine.OLuceneIndexEngineAbstract;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexEngineException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class OLuceneFacetManager {
    public static final String FACET_FIELDS = "facetFields";
    protected static final String FACET = "_facet";
    private final OStorage storage;
    protected TaxonomyWriter taxonomyWriter;
    protected FacetsConfig config = new FacetsConfig();
    protected String facetField;
    private OLuceneIndexEngineAbstract owner;
    private ODocument metadata;

    public OLuceneFacetManager(OStorage storage, OLuceneIndexEngineAbstract owner, ODocument metadata) throws IOException {
        this.owner = owner;
        this.storage = storage;
        this.metadata = metadata;
        this.buildFacetIndexIfNeeded();
    }

    protected void buildFacetIndexIfNeeded() throws IOException {
        if (this.metadata != null && this.metadata.containsField(FACET_FIELDS)) {
            ODatabaseDocumentInternal database = this.owner.getDatabase();
            Iterable iterable = (Iterable)this.metadata.field(FACET_FIELDS);
            if (iterable != null) {
                Directory dir = this.getTaxDirectory(database);
                this.taxonomyWriter = new DirectoryTaxonomyWriter(dir, IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    String s;
                    this.facetField = s = (String)iterator.next();
                    this.config.setHierarchical(s, true);
                }
            }
        }
    }

    private Directory getTaxDirectory(ODatabaseDocumentInternal database) throws IOException {
        OAbstractPaginatedStorage storageLocalAbstract = (OAbstractPaginatedStorage)database.getStorage().getUnderlying();
        if (storageLocalAbstract instanceof OLocalPaginatedStorage) {
            String pathname = this.getIndexFacetPath((OLocalPaginatedStorage)storageLocalAbstract);
            return NIOFSDirectory.open((Path)new File(pathname).toPath());
        }
        return new RAMDirectory();
    }

    protected String getIndexFacetPath(OLocalPaginatedStorage storageLocalAbstract) {
        return storageLocalAbstract.getStoragePath() + File.separator + "luceneIndexes" + File.separator + this.owner.name + FACET;
    }

    public void delete() {
        if (this.storage instanceof OLocalPaginatedStorage) {
            File f = new File(this.getIndexFacetPath((OLocalPaginatedStorage)this.storage));
            OFileUtils.deleteRecursively((File)f);
            f = new File(this.owner.getIndexBasePath((OLocalPaginatedStorage)this.storage));
            OFileUtils.deleteFolderIfEmpty((File)f);
        }
    }

    protected Boolean supportsFacets() {
        return this.taxonomyWriter != null;
    }

    protected boolean isFacetField(String field) {
        if (this.metadata == null) {
            return false;
        }
        if (this.metadata.field(FACET_FIELDS) == null) {
            return false;
        }
        Collection fields = (Collection)this.metadata.field(FACET_FIELDS);
        return fields.contains(field);
    }

    protected IndexableField buildFacetField(String f, Object val) {
        String[] path = null;
        if (val instanceof String) {
            path = ((String)val).split("/");
        } else if (val instanceof Iterable) {
            Iterable iterable = (Iterable)val;
            ArrayList<String> values = new ArrayList<String>();
            for (Object s : iterable) {
                if (s instanceof String) {
                    values.add((String)s);
                    continue;
                }
                throw new OIndexEngineException("Cannot facet value " + val + " because it is not a string", null);
            }
            path = values.toArray(new String[values.size()]);
        }
        return new FacetField(f, path);
    }

    public Document buildDocument(Document doc) throws IOException {
        return this.config.build(this.taxonomyWriter, doc);
    }

    public void commit() {
        try {
            if (this.taxonomyWriter != null) {
                this.taxonomyWriter.commit();
            }
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error during taxonomy commit", (Throwable)e, new Object[0]);
        }
    }

    public void addFacetContext(OLuceneQueryContext queryContext, Object key) throws IOException {
        queryContext.setFacet(true);
        queryContext.setFacetField(this.facetField);
        queryContext.setFacetConfig(this.config);
        queryContext.setReader((TaxonomyReader)new DirectoryTaxonomyReader(this.getTaxDirectory(this.owner.getDatabase())));
        if (key instanceof OCompositeKey) {
            List keys = ((OCompositeKey)key).getKeys();
            for (Object o : keys) {
                if (!(o instanceof Map)) continue;
                String drillDown = (String)((Map)o).get("drillDown");
                queryContext.setDrillDownQuery(drillDown);
            }
        }
    }
}

