/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.engine;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OLuceneClassIndexContext {
    protected final OIndexDefinition definition;
    protected final String name;
    protected final boolean automatic;
    protected final ODocument metadata;
    protected final Map<String, Boolean> fieldsToStore = new HashMap<String, Boolean>();
    protected final OClass indexClass;

    public OLuceneClassIndexContext(OSchema schema, OIndexDefinition definition, String name, boolean automatic, ODocument metadata) {
        this.definition = definition;
        this.name = name;
        this.automatic = automatic;
        this.metadata = metadata;
        OLogManager.instance().info((Object)this, "index definition:: " + definition, new Object[0]);
        this.indexClass = schema.getClass(definition.getClassName());
        this.updateFieldToStore(definition);
    }

    private void updateFieldToStore(OIndexDefinition indexDefinition) {
        List fields = indexDefinition.getFields();
        for (String field : fields) {
            OProperty property = this.indexClass.getProperty(field);
            if (property.getType().isEmbedded() && property.getLinkedType() != null) {
                this.fieldsToStore.put(field, true);
                continue;
            }
            this.fieldsToStore.put(field, false);
        }
    }

    public boolean isFieldToStore(String field) {
        if (this.fieldsToStore.containsKey(field)) {
            return this.fieldsToStore.get(field);
        }
        return false;
    }
}

