/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.collections;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.engine.OLuceneIndexEngineAbstract;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;

public abstract class OLuceneAbstractResultSet
implements Set<OIdentifiable> {
    protected Integer pageSize = 10000;
    protected final String indexName;
    protected final Query query;
    protected final OLuceneIndexEngine engine;
    protected final OLuceneQueryContext queryContext;
    protected TopDocs topDocs;

    public OLuceneAbstractResultSet(OLuceneIndexEngine engine, OLuceneQueryContext queryContext) {
        this.engine = engine;
        this.queryContext = queryContext;
        this.query = this.enhanceQuery(queryContext.query);
        this.pageSize = (Integer)OGlobalConfiguration.LUCENE_QUERY_PAGE_SIZE.getValue();
        this.indexName = engine.indexName();
        this.fetchFirstBatch();
    }

    protected Query enhanceQuery(Query query) {
        return query;
    }

    protected void fetchFirstBatch() {
        try {
            switch (this.queryContext.cfg) {
                case NO_FILTER_NO_SORT: {
                    this.topDocs = this.queryContext.getSearcher().search(this.query, this.pageSize.intValue());
                    break;
                }
                case FILTER_SORT: {
                    this.topDocs = this.queryContext.getSearcher().search(this.query, this.queryContext.filter, this.pageSize.intValue(), this.queryContext.sort);
                    break;
                }
                case FILTER: {
                    this.topDocs = this.queryContext.getSearcher().search(this.query, this.queryContext.filter, this.pageSize.intValue());
                    break;
                }
                case SORT: {
                    this.topDocs = this.queryContext.getSearcher().search(this.query, this.pageSize.intValue(), this.queryContext.sort);
                }
            }
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on fetching document by query '%s' to Lucene index", (Throwable)e, new Object[]{this.query});
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(OIdentifiable oIdentifiable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void sendLookupTime(OCommandContext commandContext, long start) {
        OLuceneIndexEngineAbstract.sendLookupTime(this.indexName, commandContext, this.topDocs, -1, start);
    }
}

