/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.builder;

import com.orientechnologies.lucene.OLuceneIndexType;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;

public class OLuceneDocumentBuilder {
    public Document build(OIndexDefinition definition, Object key, OIdentifiable value, Map<String, Boolean> fieldsToStore, ODocument metadata) {
        Document doc = new Document();
        if (value != null) {
            doc.add((IndexableField)OLuceneIndexType.createField("RID", value.getIdentity().toString(), Field.Store.YES));
            doc.add((IndexableField)OLuceneIndexType.createField("_CLUSTER", "" + value.getIdentity().getClusterId(), Field.Store.YES));
            if (definition.getClassName() != null) {
                doc.add((IndexableField)OLuceneIndexType.createField("_CLASS", definition.getClassName(), Field.Store.YES));
            }
        }
        List<Object> formattedKey = this.formatKeys(definition, key);
        int i = 0;
        for (String field : definition.getFields()) {
            Object val = formattedKey.get(i);
            ++i;
            if (val == null) continue;
            doc.add((IndexableField)OLuceneIndexType.createField(field, val, Field.Store.YES));
            doc.add((IndexableField)OLuceneIndexType.createField(definition.getClassName() + "." + field, val, Field.Store.YES));
        }
        return doc;
    }

    private List<Object> formatKeys(OIndexDefinition definition, Object key) {
        ArrayList<Object> keys;
        if (key instanceof OCompositeKey) {
            keys = ((OCompositeKey)key).getKeys();
        } else if (key instanceof List) {
            keys = (List)key;
        } else {
            keys = new ArrayList<Object>();
            keys.add(key);
        }
        for (int i = keys.size(); i < definition.getFields().size(); ++i) {
            keys.add("");
        }
        return keys;
    }

    protected Field.Store isToStore(String f, Map<String, Boolean> collectionFields) {
        return collectionFields.get(f) != false ? Field.Store.YES : Field.Store.NO;
    }
}

