/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.jpa;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;

final class OJPAProperties
extends Properties {
    private static final long serialVersionUID = -8158054712863843518L;
    public static final String URL = "javax.persistence.jdbc.url";
    public static final String USER = "javax.persistence.jdbc.user";
    public static final String PASSWORD = "javax.persistence.jdbc.password";
    public static final String ENTITY_CLASSES_PACKAGE = "com.orientdb.entityClasses";

    public OJPAProperties() {
    }

    public OJPAProperties(Map<String, Object> properties) {
        this.putAll(properties);
        if (properties == null) {
            throw new IllegalStateException("Map properties for entity manager should not be null");
        }
        if (!this.checkContainsValue(URL)) {
            throw new IllegalStateException("URL propertiy for entity manager should not be null or empty");
        }
        if (!this.checkContainsValue(USER)) {
            throw new IllegalStateException("User propertiy for entity manager should not be null or empty");
        }
    }

    public Map<String, Object> getUnmodifiableProperties() {
        return Collections.unmodifiableMap(this);
    }

    public String getUser() {
        return this.getProperty(USER);
    }

    public String getPassword() {
        return this.getProperty(PASSWORD);
    }

    public String getURL() {
        return this.getProperty(URL);
    }

    public String getEntityClasses() {
        return this.getProperty(ENTITY_CLASSES_PACKAGE);
    }

    public boolean isEntityClasses() {
        return this.checkContainsValue(ENTITY_CLASSES_PACKAGE);
    }

    private boolean checkContainsValue(String property) {
        if (!this.containsKey(property)) {
            return false;
        }
        String value = (String)this.get(property);
        return value != null && !value.isEmpty();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        for (Map.Entry<Object, Object> property : this.entrySet()) {
            builder.append(',').append(property.getKey()).append('=').append(property.getValue());
        }
        return builder.toString();
    }
}

