/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.hazelcast;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapClearedListener;
import com.hazelcast.map.listener.MapListener;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OHazelcastDistributedMap
extends ConcurrentHashMap<String, Object>
implements EntryAddedListener<String, Object>,
EntryRemovedListener<String, Object>,
MapClearedListener,
EntryUpdatedListener<String, Object> {
    private final OHazelcastPlugin dManager;
    private final IMap<String, Object> hzMap;
    private final String membershipListenerRegistration;
    public static final String ORIENTDB_MAP = "orientdb";

    public OHazelcastDistributedMap(OHazelcastPlugin manager, HazelcastInstance hz) {
        this.dManager = manager;
        this.hzMap = hz.getMap(ORIENTDB_MAP);
        this.membershipListenerRegistration = this.hzMap.addEntryListener((MapListener)this, true);
        super.putAll(this.hzMap);
    }

    public IMap<String, Object> getHazelcastMap() {
        return this.hzMap;
    }

    @Override
    public Object get(Object key) {
        return this.hzMap.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hzMap.containsKey(key);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.hzMap.entrySet();
    }

    public Set<Map.Entry<String, Object>> localEntrySet() {
        return super.entrySet();
    }

    public Object getLocalCachedValue(Object key) {
        Object res = super.get(key);
        if (res != null) {
            return res;
        }
        try {
            return this.hzMap.get(key);
        }
        catch (HazelcastInstanceNotActiveException e) {
            return null;
        }
    }

    @Override
    public Object put(String key, Object value) {
        try {
            this.hzMap.put((Object)key, value);
        }
        catch (HazelcastInstanceNotActiveException hazelcastInstanceNotActiveException) {
            // empty catch block
        }
        return super.put(key, value);
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        try {
            this.hzMap.putIfAbsent((Object)key, value);
        }
        catch (HazelcastInstanceNotActiveException hazelcastInstanceNotActiveException) {
            // empty catch block
        }
        return super.putIfAbsent(key, value);
    }

    public Object putInLocalCache(String key, Object value) {
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        try {
            this.hzMap.remove(key);
        }
        catch (HazelcastInstanceNotActiveException hazelcastInstanceNotActiveException) {
            // empty catch block
        }
        return super.remove(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        try {
            this.hzMap.remove(key, value);
        }
        catch (HazelcastInstanceNotActiveException hazelcastInstanceNotActiveException) {
            // empty catch block
        }
        return super.remove(key, value);
    }

    public void entryAdded(EntryEvent<String, Object> event) {
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)("Map entry added " + (String)event.getKey() + "=" + event.getValue() + " from server " + this.dManager.getNodeName(event.getMember())), (Object[])new Object[0]);
        }
        super.put(event.getKey(), event.getValue());
    }

    public void entryUpdated(EntryEvent<String, Object> event) {
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)("Map entry updated " + (String)event.getKey() + "=" + event.getValue() + " from server " + this.dManager.getNodeName(event.getMember())), (Object[])new Object[0]);
        }
        super.put(event.getKey(), event.getValue());
    }

    public void entryRemoved(EntryEvent<String, Object> event) {
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)("Map entry removed " + (String)event.getKey() + "=" + event.getValue() + " from " + this.dManager.getNodeName(event.getMember())), (Object[])new Object[0]);
        }
        super.remove(event.getKey());
    }

    public void mapCleared(MapEvent event) {
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)("Map cleared from server " + this.dManager.getNodeName(event.getMember())), (Object[])new Object[0]);
        }
        super.clear();
    }

    public void destroy() {
        this.clear();
        this.hzMap.removeEntryListener(this.membershipListenerRegistration);
    }

    public void clearLocalCache() {
        super.clear();
    }

    public Set<String> getKeySet() {
        OHazelcastDistributedMap map = this;
        return map.keySet();
    }
}

