/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.task.OFixCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OResurrectRecordTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import java.util.List;

public class ODeleteRecordTask
extends OAbstractRecordReplicatedTask {
    public static final int FACTORYID = 4;
    private byte[] previousRecordContent;
    private int previousRecordVersion;

    public ODeleteRecordTask() {
    }

    public ODeleteRecordTask(ORecord record) {
        this.init(record);
    }

    public ODeleteRecordTask init(ORecordId rid, int version) {
        super.init(rid, version);
        return this;
    }

    public ORecord getRecord() {
        return null;
    }

    public Object executeRecordTask(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Deleting record %s/%s v.%d (reqId=%s)", (Object[])new Object[]{database.getName(), this.rid.toString(), this.version, requestId});
        this.prepareUndoOperation();
        if (this.previousRecord == null) {
            return true;
        }
        final ORecord loadedRecord = this.previousRecord;
        try {
            if (loadedRecord instanceof ODocument) {
                if (((ODocument)loadedRecord).getSchemaClass().isEdgeType()) {
                    OGraphCommandExecutorSQLFactory.runInConfiguredTxMode((OGraphCommandExecutorSQLFactory.GraphCallBack)new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                        public Object call(OrientBaseGraph graph) {
                            graph.getEdge((Object)loadedRecord).remove();
                            return null;
                        }
                    });
                    return true;
                }
                if (((ODocument)loadedRecord).getSchemaClass().isVertexType()) {
                    OGraphCommandExecutorSQLFactory.runInConfiguredTxMode((OGraphCommandExecutorSQLFactory.GraphCallBack)new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                        public Object call(OrientBaseGraph graph) {
                            graph.getVertex((Object)loadedRecord).remove();
                            return null;
                        }
                    });
                    return true;
                }
            }
            loadedRecord.delete();
        }
        catch (ORecordNotFoundException oRecordNotFoundException) {
            // empty catch block
        }
        return true;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    public ORemoteTask getFixTask(ODistributedRequest iRequest, ORemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNodeName, ODistributedServerManager dManager) {
        return ((OFixCreateRecordTask)dManager.getTaskFactoryManager().getFactoryByServerName(executorNodeName).createTask(20)).init(this.rid, this.version);
    }

    public ORemoteTask getUndoTask(ODistributedServerManager dManager, ODistributedRequestId reqId, List<String> servers) {
        if (this.previousRecord == null) {
            return null;
        }
        this.previousRecord = Orient.instance().getRecordFactoryManager().newInstance(ORecordInternal.getRecordType((ORecord)this.previousRecord));
        ORecordInternal.fill((ORecord)this.previousRecord, (ORID)this.rid, (int)this.previousRecordVersion, (byte[])this.previousRecordContent, (boolean)true);
        OResurrectRecordTask task = ((OResurrectRecordTask)dManager.getTaskFactoryManager().getFactoryByServerNames(servers).createTask(11)).init(this.previousRecord);
        task.setLockRecords(false);
        return task;
    }

    public void checkRecordExists() {
    }

    public String getName() {
        return "record_delete";
    }

    public String toString() {
        return this.getName() + "(" + this.rid + ")";
    }

    public int getFactoryId() {
        return 4;
    }

    public boolean isIdempotent() {
        return false;
    }

    public ORecord prepareUndoOperation() {
        if (this.previousRecord == null) {
            OStorageOperationResult loaded = ODatabaseRecordThreadLocal.instance().get().getStorage().getUnderlying().readRecord(this.rid, null, true, false, null);
            if (loaded == null || loaded.getResult() == null) {
                return null;
            }
            this.previousRecordContent = ((ORawBuffer)loaded.getResult()).buffer;
            this.previousRecordVersion = ((ORawBuffer)loaded.getResult()).version;
            this.previousRecord = Orient.instance().getRecordFactoryManager().newInstance(((ORawBuffer)loaded.getResult()).recordType);
            ORecordInternal.fill((ORecord)this.previousRecord, (ORID)this.rid, (int)this.previousRecordVersion, (byte[])((ORawBuffer)loaded.getResult()).getBuffer(), (boolean)false);
        }
        return this.previousRecord;
    }
}

