/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class OLocalClusterWrapperStrategy
implements OClusterSelectionStrategy {
    private OClass cls;
    private final ODistributedServerManager manager;
    private final String nodeName;
    private final String databaseName;
    private int lastVersion = -1;
    private OClusterSelectionStrategy wrapped;
    private OLocalScopedClass localScopedClass;

    public OLocalClusterWrapperStrategy(ODistributedServerManager iManager, String iDatabaseName, OClass iClass, OClusterSelectionStrategy wrapped) {
        this.manager = iManager;
        this.nodeName = iManager.getLocalNodeName();
        this.databaseName = iDatabaseName;
        this.cls = iClass;
        this.localScopedClass = null;
        this.wrapped = wrapped;
    }

    public int getCluster(OClass iClass, ODocument doc) {
        if (!iClass.equals(this.cls)) {
            throw new IllegalArgumentException("Class '" + iClass + "' is different than the configured one: " + this.cls);
        }
        OStorage storage = ODatabaseRecordThreadLocal.instance().get().getStorage();
        if (!(storage instanceof ODistributedStorage)) {
            throw new IllegalStateException("Storage is not distributed");
        }
        if (this.localScopedClass == null) {
            this.readConfiguration();
        } else if (this.lastVersion != ((ODistributedStorage)storage).getConfigurationUpdated()) {
            this.readConfiguration();
            ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"New cluster list for class '%s': %s (dCfgVersion=%d)", (Object[])new Object[]{this.cls.getName(), Arrays.toString(this.localScopedClass.bestClusterIds), this.lastVersion});
        }
        int size = this.localScopedClass.bestClusterIds.length;
        if (size == 0) {
            return -1;
        }
        if (size == 1) {
            return this.localScopedClass.bestClusterIds[0];
        }
        int cluster = this.wrapped.getCluster((OClass)this.localScopedClass, doc);
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, (String)this.manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Selected cluster %d for class '%s' from %s (threadId=%d dCfgVersion=%d)", (Object[])new Object[]{cluster, this.cls.getName(), Arrays.toString(this.localScopedClass.bestClusterIds), Thread.currentThread().getId(), this.lastVersion});
        }
        return cluster;
    }

    public String getName() {
        return this.wrapped.getName();
    }

    protected ODistributedConfiguration readConfiguration() {
        if (this.cls.isAbstract()) {
            throw new IllegalArgumentException("Cannot create a new instance of abstract class");
        }
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        int[] clusterIds = this.cls.getClusterIds();
        ArrayList<String> clusterNames = new ArrayList<String>(clusterIds.length);
        for (int c : clusterIds) {
            clusterNames.add(db.getClusterNameById(c).toLowerCase(Locale.ENGLISH));
        }
        ODistributedConfiguration cfg = this.manager.getDatabaseConfiguration(this.databaseName);
        List bestClusters = cfg.getOwnedClustersByServer(clusterNames, this.nodeName);
        if (bestClusters.isEmpty()) {
            OModifiableDistributedConfiguration modifiableCfg = cfg.modify();
            this.manager.reassignClustersOwnership(this.nodeName, this.databaseName, modifiableCfg, true);
            cfg = modifiableCfg;
            db.activateOnCurrentThread();
            clusterNames.clear();
            for (int c : clusterIds = this.cls.getClusterIds()) {
                clusterNames.add(db.getClusterNameById(c).toLowerCase(Locale.ENGLISH));
            }
            bestClusters = cfg.getOwnedClustersByServer(clusterNames, this.nodeName);
            if (bestClusters.isEmpty()) {
                StringBuilder buffer = new StringBuilder();
                for (String c : clusterNames) {
                    if (buffer.length() > 0) {
                        buffer.append(" ");
                    }
                    buffer.append(" ");
                    buffer.append(c);
                    buffer.append(":");
                    buffer.append(cfg.getServers(c, null));
                }
                ODistributedServerLog.warn((Object)this, (String)this.manager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Cannot find best cluster for class '%s'. Configured servers for clusters %s are %s (dCfgVersion=%d)", (Object[])new Object[]{this.cls.getName(), clusterNames, buffer.toString(), cfg.getVersion()});
                throw new ODatabaseException("Cannot find best cluster for class '" + this.cls.getName() + "' on server '" + this.nodeName + "' (clusterStrategy=" + this.getName() + " dCfgVersion=" + cfg.getVersion() + ")");
            }
        }
        db.activateOnCurrentThread();
        int[] newBestClusters = new int[bestClusters.size()];
        int i = 0;
        for (String c : bestClusters) {
            newBestClusters[i++] = db.getClusterIdByName(c);
        }
        this.localScopedClass = new OLocalScopedClass((OClassImpl)this.cls, newBestClusters);
        ODistributedStorage storage = (ODistributedStorage)this.manager.getStorage(this.databaseName);
        this.lastVersion = storage.getConfigurationUpdated();
        return cfg;
    }

    private class OLocalScopedClass
    extends OClassImpl {
        public OClassImpl wrapped;
        public volatile int[] bestClusterIds;

        public OLocalScopedClass(OClassImpl wrapping, int[] newBestClusters) {
            super(wrapping.getOwner(), wrapping.getName());
            this.wrapped = wrapping;
            this.bestClusterIds = newBestClusters;
        }

        public int[] getClusterIds() {
            return this.bestClusterIds;
        }
    }
}

