/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientDynaElementIterable;
import java.util.Iterator;
import java.util.Map;

public class OrientGraphCommand
implements OCommandRequest {
    private OrientBaseGraph graph;
    private OCommandRequest underlying;

    public OrientGraphCommand(OrientBaseGraph iGraph, OCommandRequest iCommand) {
        this.graph = iGraph;
        this.underlying = iCommand;
    }

    public <RET> RET execute(Object ... iArgs) {
        Object result = this.underlying.execute(iArgs);
        if (!(result instanceof Map) && OMultiValue.isMultiValue((Object)result)) {
            result = new OrientDynaElementIterable(this.graph, ((Iterable)result).iterator());
        } else if (result instanceof Iterator) {
            result = new OrientDynaElementIterable(this.graph, (Iterator)result);
        } else if (result instanceof OIdentifiable) {
            result = this.graph.getElement(result);
        }
        return (RET)result;
    }

    public int getLimit() {
        return this.underlying.getLimit();
    }

    public OCommandRequest setLimit(int iLimit) {
        this.underlying.setLimit(iLimit);
        return this;
    }

    public long getTimeoutTime() {
        return this.underlying.getTimeoutTime();
    }

    public OCommandContext.TIMEOUT_STRATEGY getTimeoutStrategy() {
        return this.underlying.getTimeoutStrategy();
    }

    public void setTimeout(long timeout, OCommandContext.TIMEOUT_STRATEGY strategy) {
        this.underlying.setTimeout(timeout, strategy);
    }

    public boolean isIdempotent() {
        return this.underlying.isIdempotent();
    }

    public String getFetchPlan() {
        return this.underlying.getFetchPlan();
    }

    public <RET extends OCommandRequest> RET setFetchPlan(String iFetchPlan) {
        this.underlying.setFetchPlan(iFetchPlan);
        return (RET)this;
    }

    public void setUseCache(boolean iUseCache) {
        this.underlying.setUseCache(iUseCache);
    }

    public OCommandContext getContext() {
        return this.underlying.getContext();
    }

    public OCommandRequest setContext(OCommandContext iContext) {
        this.underlying.setContext(iContext);
        return this;
    }
}

