/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLProcessHaltedException;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.transformer.OAbstractTransformer;

public class OFlowTransformer
extends OAbstractTransformer {
    private String operation;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{operation:{optional:false,description:'Flow operation between: skip and halt'}}],input:['Object'],output:'Object'}");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        this.operation = (String)iConfiguration.field("operation");
        if (this.operation == null) {
            throw new OConfigurationException("Flow transformer has not mandatory 'operation' field");
        }
        if (!this.operation.equalsIgnoreCase("halt") && !this.operation.equalsIgnoreCase("skip")) {
            throw new OConfigurationException("Flow transformer has invalid 'operation' field='" + this.operation + "', while supported are: 'skip' and 'halt'");
        }
    }

    @Override
    public String getName() {
        return "flow";
    }

    @Override
    public Object executeTransform(Object input) {
        if (this.operation.equalsIgnoreCase("skip")) {
            return null;
        }
        throw new OETLProcessHaltedException("Process stopped because this condition: " + this.ifExpression);
    }
}

