/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLPipeline;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.block.OBlock;
import com.orientechnologies.orient.etl.transformer.OAbstractTransformer;

public class OBlockTransformer
extends OAbstractTransformer {
    private OBlock block;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{block:{optional:false,description:'Block to execute'}}]}");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        String[] fieldNames = iConfiguration.fieldNames();
        try {
            this.block = this.processor.getFactory().getBlock(fieldNames[0]);
            this.block.configure(this.processor, (ODocument)iConfiguration.field(fieldNames[0]), this.context);
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OConfigurationException("[Block transformer] Error on configuring inner block"), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "block";
    }

    @Override
    public void setPipeline(OETLPipeline iPipeline) {
        super.setPipeline(iPipeline);
        this.block.setContext(this.context);
    }

    @Override
    protected Object executeTransform(Object input) {
        this.context.setVariable("input", input);
        this.block.execute();
        return input;
    }
}

