/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.source;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.source.OAbstractSource;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;

public class OContentSource
extends OAbstractSource {
    protected BufferedReader reader;

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        String stringContent;
        Object value = iConfiguration.field("value");
        if (value != null) {
            if (value instanceof ODocument) {
                stringContent = ((ODocument)value).toJSON((String)null);
            } else if (OMultiValue.isMultiValue((Object)value)) {
                stringContent = "[";
                int i = 0;
                for (Object o : OMultiValue.getMultiValueIterable((Object)value)) {
                    if (o == null) continue;
                    if (i > 0) {
                        stringContent = stringContent + ",";
                    }
                    stringContent = o instanceof ODocument ? stringContent + ((ODocument)o).toJSON((String)null) : stringContent + o.toString();
                    ++i;
                }
                stringContent = stringContent + "]";
            } else {
                stringContent = value.toString();
            }
        } else {
            throw new IllegalArgumentException(this.getName() + " Source has no 'value' set");
        }
        this.reader = new BufferedReader(new StringReader(stringContent));
    }

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{}");
    }

    @Override
    public String getUnit() {
        return "bytes";
    }

    @Override
    public String getName() {
        return "content";
    }

    @Override
    public Reader read() {
        return this.reader;
    }
}

