/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.loader;

import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.etl.OETLPipeline;
import com.orientechnologies.orient.etl.OETLProcessHaltedException;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.loader.OAbstractLoader;
import com.orientechnologies.orient.etl.loader.OLoader;
import com.orientechnologies.orient.etl.loader.OLoaderException;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;

public class OOrientDBLoader
extends OAbstractLoader
implements OLoader {
    private static String NOT_DEF = "not_defined";
    protected String clusterName;
    protected String className;
    protected List<ODocument> classes;
    protected List<ODocument> indexes;
    protected OClass schemaClass;
    protected String dbURL;
    protected String dbUser = "admin";
    protected String dbPassword = "admin";
    protected String serverUser = NOT_DEF;
    protected String serverPassword = NOT_DEF;
    protected boolean dbAutoCreate = true;
    protected boolean dbAutoDropIfExists = false;
    protected boolean dbAutoCreateProperties = false;
    protected boolean useLightweightEdges = false;
    protected boolean standardElementConstraints = true;
    protected boolean tx = false;
    protected int batchCommitSize = 0;
    protected AtomicLong batchCounter = new AtomicLong(0L);
    protected DB_TYPE dbType = DB_TYPE.DOCUMENT;
    protected boolean wal = true;
    protected boolean txUseLog = false;
    private boolean skipDuplicates = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load(OETLPipeline pipeline, Object input, OCommandContext context) {
        ODatabaseDocument documentDatabase;
        if (input == null) {
            return;
        }
        if (this.dbAutoCreateProperties) {
            this.autoCreateProperties(pipeline, input);
        }
        if (this.tx && this.dbType == DB_TYPE.DOCUMENT && !(documentDatabase = pipeline.getDocumentDatabase()).getTransaction().isActive()) {
            documentDatabase.begin();
            documentDatabase.getTransaction().setUsingLog(this.txUseLog);
        }
        if (input instanceof OrientVertex) {
            OrientVertex v = (OrientVertex)input;
            try {
                v.save(this.clusterName);
            }
            catch (ORecordDuplicatedException e) {
                if (!this.skipDuplicates) throw e;
            }
        } else if (input instanceof ODocument) {
            ODocument doc = (ODocument)input;
            if (this.className != null) {
                doc.setClassName(this.className);
            }
            if (doc.getClassName() == null) {
                throw new OETLProcessHaltedException("Cannot insert new document " + doc + " because it has not class");
            }
            if (this.clusterName != null) {
                doc.save(this.clusterName);
            } else {
                doc.save();
            }
        } else {
            OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "input type not supported::  %s", new Object[]{input.getClass()});
        }
        this.progress.incrementAndGet();
        if (this.batchCommitSize > 0 && this.batchCounter.get() > (long)this.batchCommitSize) {
            if (this.dbType == DB_TYPE.DOCUMENT) {
                documentDatabase = pipeline.getDocumentDatabase();
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "committing batch", new Object[0]);
                documentDatabase.commit();
                documentDatabase.begin();
                documentDatabase.getTransaction().setUsingLog(this.txUseLog);
            } else {
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "committing batch", new Object[0]);
                pipeline.getGraphDatabase().commit();
            }
            this.batchCounter.set(0L);
            return;
        }
        this.batchCounter.incrementAndGet();
    }

    @Override
    public String getUnit() {
        return this.dbType == DB_TYPE.DOCUMENT ? "documents" : "vertices";
    }

    @Override
    public void rollback(OETLPipeline pipeline) {
        if (this.tx) {
            if (this.dbType == DB_TYPE.DOCUMENT) {
                ODatabaseDocument documentDatabase = pipeline.getDocumentDatabase();
                if (documentDatabase.getTransaction().isActive()) {
                    documentDatabase.rollback();
                }
            } else {
                pipeline.getGraphDatabase().rollback();
            }
        }
    }

    private void autoCreateProperties(OETLPipeline pipeline, Object input) {
        if (this.dbType == DB_TYPE.DOCUMENT && input instanceof ODocument) {
            this.auroCreatePropertiesOnDocument(pipeline, (ODocument)input);
        } else if (this.dbType == DB_TYPE.GRAPH && input instanceof OrientElement) {
            this.autoCreatePropertiesOnElement(pipeline, (OrientElement)input);
        }
    }

    private void autoCreatePropertiesOnElement(OETLPipeline pipeline, OrientElement element) {
        String clsName;
        String string = this.className != null ? this.className : (clsName = element instanceof OrientVertex ? element.getLabel() : element.getLabel());
        if (clsName == null) {
            throw new IllegalArgumentException("No class defined on graph element: " + element);
        }
        OClass cls = this.getOrCreateClass(pipeline, clsName, element.getBaseClassName());
        for (String f : element.getPropertyKeys()) {
            String newName = this.transformFieldName(f);
            String fName = newName != null ? newName : f;
            OProperty p = cls.getProperty(fName);
            if (p != null) continue;
            Object fValue = element.getProperty(f);
            this.createProperty(cls, fName, fValue);
            if (newName == null) continue;
            element.removeProperty(f);
            element.setProperty(newName, fValue);
        }
    }

    private void auroCreatePropertiesOnDocument(OETLPipeline pipeline, ODocument doc) {
        OClass cls = this.className != null ? this.getOrCreateClass(pipeline, this.className, null) : doc.getSchemaClass();
        for (String f : doc.fieldNames()) {
            String newName = this.transformFieldName(f);
            String fName = newName != null ? newName : f;
            OProperty p = cls.getProperty(fName);
            if (p != null) continue;
            Object fValue = doc.field(f);
            this.createProperty(cls, fName, fValue);
            if (newName == null) continue;
            doc.removeField(f);
            doc.field(newName, fValue);
        }
    }

    private String transformFieldName(String f) {
        char first = f.charAt(0);
        if (Character.isDigit(first)) {
            return "field" + Character.toUpperCase(first) + (f.length() > 1 ? f.substring(1) : "");
        }
        return null;
    }

    protected void createProperty(OClass cls, String f, Object fValue) {
        if (fValue != null) {
            OType fType = OType.getTypeByClass(fValue.getClass());
            try {
                cls.createProperty(f, fType);
            }
            catch (OSchemaException oSchemaException) {
                // empty catch block
            }
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "created property [%s.%s] of type [%s]", cls.getName(), f, fType);
        }
    }

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[{dbUrl:{optional:false,description:'Database URL'}},{dbUser:{optional:true,description:'Database user, default is admin'}},{dbPassword:{optional:true,description:'Database password, default is admin'}},{dbType:{optional:true,description:'Database type, default is document',values:" + this.stringArray2Json((Object[])DB_TYPE.values()) + "}},{class:{optional:true,description:'Record class name'}},{tx:{optional:true,description:'Transaction mode: true executes in transaction, false for atomic operations'}},{dbAutoCreate:{optional:true,description:'Auto create the database if not exists. Default is true'}},{dbAutoCreateProperties:{optional:true,description:'Auto create properties in schema'}},{dbAutoDropIfExists:{optional:true,description:'Auto drop the database if already exists. Default is false.'}},{batchCommit:{optional:true,description:'Auto commit every X items. This speed up creation of edges.'}},{wal:{optional:true,description:'Use the WAL (Write Ahead Log)'}},{useLightweightEdges:{optional:true,description:'Enable/Disable LightweightEdges in Graphs. Default is false'}},{standardElementConstraints:{optional:true,description:'Enable/Disable Standard Blueprints constraints on names. Default is true'}},{cluster:{optional:true,description:'Cluster name where to store the new record'}},{settings:{optional:true,description:'OrientDB settings as a map'}},{classes:{optional:true,description:'Classes used. It assure the classes exist or in case create them'}},{indexes:{optional:true,description:'Indexes used. It assure the indexes exist or in case create them'}}],input:['OrientVertex','ODocument']}");
    }

    @Override
    public void configure(OETLProcessor iProcessor, ODocument conf, OCommandContext iContext) {
        super.configure(iProcessor, conf, iContext);
        if (conf.containsField("dbURL")) {
            this.dbURL = (String)this.resolve(conf.field("dbURL"));
        }
        if (conf.containsField("dbUser")) {
            this.dbUser = (String)this.resolve(conf.field("dbUser"));
        }
        if (conf.containsField("dbPassword")) {
            this.dbPassword = (String)this.resolve(conf.field("dbPassword"));
        }
        if (conf.containsField("serverUser")) {
            this.serverUser = (String)this.resolve(conf.field("serverUser"));
        }
        if (conf.containsField("serverPassword")) {
            this.serverPassword = (String)this.resolve(conf.field("serverPassword"));
        }
        if (conf.containsField("dbType")) {
            this.dbType = DB_TYPE.valueOf(conf.field("dbType").toString().toUpperCase(Locale.ENGLISH));
        }
        if (conf.containsField("tx")) {
            this.tx = (Boolean)conf.field("tx");
        }
        if (conf.containsField("wal")) {
            this.wal = (Boolean)conf.field("wal");
        }
        if (conf.containsField("txUseLog")) {
            this.txUseLog = (Boolean)conf.field("txUseLog");
        }
        if (conf.containsField("batchCommit")) {
            this.batchCommitSize = (Integer)conf.field("batchCommit");
        }
        if (conf.containsField("dbAutoCreate")) {
            this.dbAutoCreate = (Boolean)conf.field("dbAutoCreate");
        }
        if (conf.containsField("dbAutoDropIfExists")) {
            this.dbAutoDropIfExists = (Boolean)conf.field("dbAutoDropIfExists");
        }
        if (conf.containsField("dbAutoCreateProperties")) {
            this.dbAutoCreateProperties = (Boolean)conf.field("dbAutoCreateProperties");
        }
        if (conf.containsField("useLightweightEdges")) {
            this.useLightweightEdges = (Boolean)conf.field("useLightweightEdges");
        }
        if (conf.containsField("standardElementConstraints")) {
            this.standardElementConstraints = (Boolean)conf.field("standardElementConstraints");
        }
        if (conf.containsField("skipDuplicates")) {
            this.skipDuplicates = (Boolean)conf.field("skipDuplicates");
        }
        this.clusterName = (String)conf.field("cluster");
        this.className = (String)conf.field("class");
        this.indexes = (List)conf.field("indexes");
        this.classes = (List)conf.field("classes");
        if (conf.containsField("settings")) {
            ODocument settings = (ODocument)conf.field("settings");
            settings.setAllowChainedAccess(false);
            for (String s : settings.fieldNames()) {
                OGlobalConfiguration v = OGlobalConfiguration.findByKey((String)s);
                if (v == null) continue;
                v.setValue(settings.field(s));
            }
        }
        OGlobalConfiguration.USE_WAL.setValue((Object)this.wal);
        if (this.dbURL.startsWith("remote")) {
            this.manageRemoteDatabase();
        } else {
            switch (this.dbType) {
                case DOCUMENT: {
                    this.configureDocumentDB();
                    break;
                }
                case GRAPH: {
                    this.configureGraphDB();
                }
            }
        }
    }

    private void manageRemoteDatabase() {
        if (!this.dbAutoCreate && !this.dbAutoDropIfExists) {
            this.log(OETLProcessor.LOG_LEVELS.INFO, "nothing setup  on remote database " + this.dbURL, new Object[0]);
            return;
        }
        if (this.dbAutoCreate) {
            if (NOT_DEF.equals(this.serverPassword) || NOT_DEF.equals(this.serverUser)) {
                this.log(OETLProcessor.LOG_LEVELS.ERROR, "please provide server administrator credentials", new Object[0]);
                throw new OLoaderException("unable to manage remote db without server admin credentials");
            }
            ODatabaseDocumentTx documentDatabase = new ODatabaseDocumentTx(this.dbURL);
            try {
                OServerAdmin admin = new OServerAdmin(documentDatabase.getURL()).connect(this.serverUser, this.serverPassword);
                boolean exists = admin.existsDatabase();
                if (!exists && this.dbAutoCreate) {
                    this.log(OETLProcessor.LOG_LEVELS.INFO, "creating database: " + this.dbURL, new Object[0]);
                    admin.createDatabase(documentDatabase.getName(), this.dbType.name(), "plocal");
                } else if (exists && this.dbAutoDropIfExists) {
                    this.log(OETLProcessor.LOG_LEVELS.INFO, "dropping database: " + this.dbURL, new Object[0]);
                    admin.dropDatabase(documentDatabase.getName(), documentDatabase.getType());
                    this.log(OETLProcessor.LOG_LEVELS.INFO, "creating database: " + this.dbURL, new Object[0]);
                    admin.createDatabase(documentDatabase.getName(), this.dbType.name(), "plocal");
                }
                admin.close();
            }
            catch (IOException e) {
                throw new OLoaderException(e);
            }
            documentDatabase.activateOnCurrentThread();
            documentDatabase.close();
        }
    }

    private void configureDocumentDB() {
        ODatabaseDocumentTx documentDatabase = new ODatabaseDocumentTx(this.dbURL);
        if (documentDatabase.exists() && this.dbAutoDropIfExists) {
            this.log(OETLProcessor.LOG_LEVELS.INFO, "Dropping existent database '%s'...", this.dbURL);
            documentDatabase.open(this.dbUser, this.dbPassword);
            documentDatabase.drop();
        }
        if (documentDatabase.exists()) {
            this.log(OETLProcessor.LOG_LEVELS.INFO, "Opening database '%s'...", this.dbURL);
            documentDatabase.open(this.dbUser, this.dbPassword);
        } else if (this.dbAutoCreate) {
            documentDatabase.create();
        } else {
            throw new IllegalArgumentException("Database '" + this.dbURL + "' not exists and 'dbAutoCreate' setting is false");
        }
        documentDatabase.close();
    }

    private void configureGraphDB() {
        OrientGraphFactory factory = new OrientGraphFactory(this.dbURL, this.dbUser, this.dbPassword);
        if (this.dbAutoDropIfExists && factory.exists()) {
            this.log(OETLProcessor.LOG_LEVELS.INFO, "Dropping existent database '%s'...", this.dbURL);
            factory.drop();
        }
        if (!factory.exists()) {
            factory = new OrientGraphFactory(this.dbURL, this.dbUser, this.dbPassword);
        }
        OrientGraph graphDatabase = this.tx ? factory.getTx() : factory.getNoTx();
        graphDatabase.shutdown();
    }

    @Override
    public void begin() {
    }

    @Override
    public void end() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginLoader(OETLPipeline pipeline) {
        OOrientDBLoader oOrientDBLoader = this;
        synchronized (oOrientDBLoader) {
            ODatabaseDocumentTx documentDatabase = null;
            OrientGraph graphDatabase = null;
            OrientGraphFactory factory = new OrientGraphFactory(this.dbURL, this.dbUser, this.dbPassword);
            graphDatabase = this.tx ? factory.getTx() : factory.getNoTx();
            graphDatabase.setUseLightweightEdges(this.useLightweightEdges);
            graphDatabase.setStandardElementConstraints(this.standardElementConstraints);
            documentDatabase = graphDatabase.getRawGraph();
            pipeline.setDocumentDatabase((ODatabaseDocument)documentDatabase);
            pipeline.setGraphDatabase((OrientBaseGraph)graphDatabase);
            this.createSchema(pipeline, (ODatabaseDocument)documentDatabase);
            documentDatabase.getMetadata().getSchema().reload();
            documentDatabase.declareIntent((OIntent)new OIntentMassiveInsert());
        }
    }

    private void createSchema(OETLPipeline pipeline, ODatabaseDocument documentDatabase) {
        if (this.classes != null) {
            for (ODocument cls : this.classes) {
                this.schemaClass = this.getOrCreateClass(pipeline, (String)cls.field("name"), (String)cls.field("extends"));
                Integer clusters = (Integer)cls.field("clusters");
                if (clusters != null) {
                    OClassImpl.addClusters((OClass)this.schemaClass, (int)clusters);
                }
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "%s: found %d %s in class '%s'", this.getName(), this.schemaClass.count(), this.getUnit(), this.className);
            }
        }
        if (this.className != null) {
            this.schemaClass = this.getOrCreateClass(pipeline, this.className, null);
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "%s: found %d %s in class '%s'", this.getName(), this.schemaClass.count(), this.getUnit(), this.className);
        }
        if (this.indexes != null) {
            for (ODocument idx : this.indexes) {
                OIndex index;
                ODocument metadata = (ODocument)this.resolve(idx.field("metadata"));
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "%s: found metadata field '%s'", this.getName(), metadata);
                String idxName = (String)this.resolve(idx.field("name"));
                if (idxName != null && (index = documentDatabase.getMetadata().getIndexManager().getIndex(idxName)) != null) continue;
                String idxClass = (String)this.resolve(idx.field("class"));
                if (idxClass == null) {
                    throw new OConfigurationException("Index 'class' missed in OrientDB Loader");
                }
                OClass cls = this.getOrCreateClass(pipeline, idxClass, null);
                String idxType = (String)idx.field("type");
                if (idxType == null) {
                    throw new OConfigurationException("Index 'type' missed in OrientDB Loader for index '" + idxName + "'");
                }
                String algorithm = (String)idx.field("algorithm");
                List idxFields = (List)idx.field("fields");
                if (idxFields == null) {
                    throw new OConfigurationException("Index 'fields' missed in OrientDB Loader");
                }
                String[] fields = new String[idxFields.size()];
                for (int f = 0; f < fields.length; ++f) {
                    String fieldName = (String)idxFields.get(f);
                    String[] fieldNameParts = fieldName.split(":");
                    if (!cls.existsProperty(fieldNameParts[0])) {
                        if (fieldNameParts.length < 2) {
                            throw new OConfigurationException("Index field type missed in OrientDB Loader for field '" + fieldName + "'");
                        }
                        String fieldType = fieldNameParts[1].toUpperCase(Locale.ENGLISH);
                        OType type = OType.valueOf((String)fieldType);
                        cls.createProperty(fieldNameParts[0], type);
                        this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDBLoader: created property '%s.%s' of type: %s", idxClass, fieldNameParts[0], fieldNameParts[1]);
                    }
                    fields[f] = fieldNameParts[0];
                }
                if (idxName == null) {
                    idxName = idxClass + ".";
                    for (int i = 0; i < fields.length; ++i) {
                        if (i > 0) {
                            idxName = idxName + '_';
                        }
                        idxName = idxName + fields[i];
                    }
                }
                if ((index = documentDatabase.getMetadata().getIndexManager().getIndex(idxName)) != null) continue;
                index = cls.createIndex(idxName, idxType, null, metadata, algorithm, fields);
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDocumentLoader: created index '%s' type '%s' against Class '%s', fields %s", idxName, idxType, idxClass, idxFields);
            }
        }
    }

    protected OClass getOrCreateClass(OETLPipeline pipeline, String iClassName, String iSuperClass) {
        int clusterIdByName;
        OClass cls = this.dbType == DB_TYPE.DOCUMENT ? this.getOrCreateClassOnDocument(pipeline, iClassName, iSuperClass) : this.getOrCreateClassOnGraph(pipeline, iClassName, iSuperClass);
        if (this.clusterName != null && (clusterIdByName = pipeline.getDocumentDatabase().getClusterIdByName(this.clusterName)) == -1) {
            cls.addCluster(this.clusterName);
        }
        return cls;
    }

    @Override
    public String getName() {
        return "orientdb";
    }

    private OClass getOrCreateClassOnDocument(OETLPipeline pipeline, String iClassName, String iSuperClass) {
        OClass cls;
        ODatabaseDocument documentDatabase = pipeline.getDocumentDatabase();
        if (documentDatabase.getMetadata().getSchema().existsClass(iClassName)) {
            cls = documentDatabase.getMetadata().getSchema().getClass(iClassName);
        } else if (iSuperClass != null) {
            OClass superClass = documentDatabase.getMetadata().getSchema().getClass(iSuperClass);
            if (superClass == null) {
                throw new OLoaderException("Cannot find super class '" + iSuperClass + "'");
            }
            cls = documentDatabase.getMetadata().getSchema().createClass(iClassName, superClass);
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDBLoader: created class '%s' extends '%s'", iClassName, iSuperClass);
        } else {
            cls = documentDatabase.getMetadata().getSchema().createClass(iClassName);
            this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDBLoader: created class '%s'", iClassName);
        }
        return cls;
    }

    private OClass getOrCreateClassOnGraph(OETLPipeline pipeline, String iClassName, String iSuperClass) {
        OrientBaseGraph graphDatabase = pipeline.getGraphDatabase();
        OSchemaProxy schema = graphDatabase.getRawGraph().getMetadata().getSchema();
        OClass cls = schema.getClass(iClassName);
        if (cls == null) {
            if (iSuperClass != null) {
                OClass superClass = graphDatabase.getRawGraph().getMetadata().getSchema().getClass(iSuperClass);
                if (superClass == null) {
                    throw new OLoaderException("Cannot find super class '" + iSuperClass + "'");
                }
                if (graphDatabase.getVertexBaseType().isSuperClassOf(superClass)) {
                    cls = graphDatabase.createVertexType(iClassName, superClass);
                    this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDBLoader: created vertex class '%s' extends '%s'", iClassName, iSuperClass);
                } else {
                    cls = graphDatabase.createEdgeType(iClassName, superClass);
                    this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDBLoader: created edge class '%s' extends '%s'", iClassName, iSuperClass);
                }
            } else {
                cls = graphDatabase.createVertexType(iClassName);
                this.log(OETLProcessor.LOG_LEVELS.DEBUG, "- OrientDBLoader: created vertex class '%s'", iClassName);
            }
        }
        return cls;
    }

    @Override
    public void endLoader(OETLPipeline pipeline) {
        this.log(OETLProcessor.LOG_LEVELS.INFO, "committing", new Object[0]);
        if (this.dbType == DB_TYPE.DOCUMENT) {
            pipeline.getDocumentDatabase().commit();
        } else {
            pipeline.getGraphDatabase().commit();
        }
    }

    protected static enum DB_TYPE {
        DOCUMENT,
        GRAPH;

    }
}

