/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.http;

import com.orientechnologies.common.thread.OThreadPoolExecutorWithLogging;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.http.OETLJob;
import com.orientechnologies.orient.etl.http.OETLListener;
import com.orientechnologies.orient.etl.util.OMigrationConfigManager;
import com.orientechnologies.orient.server.OServer;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class OETLHandler {
    private ExecutorService pool = new OThreadPoolExecutorWithLogging(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue());
    private OETLJob currentJob = null;

    public void executeImport(ODocument cfg, OServer server) {
        OETLJob job = new OETLJob(cfg, server, new OETLListener(){

            @Override
            public void onEnd(OETLJob etlJob) {
                OETLHandler.this.currentJob = null;
            }
        });
        job.validate();
        this.currentJob = job;
        this.pool.execute(job);
    }

    public void checkConnection(ODocument args) throws Exception {
    }

    public ODocument status() {
        ODocument status = new ODocument();
        ArrayList<ODocument> jobs = new ArrayList<ODocument>();
        if (this.currentJob != null) {
            jobs.add(this.currentJob.status());
        }
        status.field("jobs", jobs);
        return status;
    }

    public void saveConfiguration(ODocument args, OServer server) throws Exception {
        String outDBName = (String)args.field("outDBName");
        ODocument migrationConfig = new ODocument().fromJSON((String)args.field("migrationConfig"), "noMap");
        String configName = (String)args.field("configName");
        String protocol = (String)args.field("protocol");
        if (outDBName == null) {
            throw new IllegalArgumentException("target database name is null.");
        }
        String outOrientGraphUri = server.getDatabaseDirectory() + outDBName;
        String dbURL = protocol + ":" + outOrientGraphUri;
        ODocument loader = (ODocument)migrationConfig.field("loader");
        if (loader.field("orientdb") != null) {
            ((ODocument)loader.field("orientdb")).field("dbURL", (Object)dbURL);
        }
        if (migrationConfig == null) {
            throw new IllegalArgumentException("Migration config is null.");
        }
        OMigrationConfigManager.writeConfigurationInTargetDB(migrationConfig, outOrientGraphUri, configName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument listConfigurations(OServer server) throws Exception {
        ODocument database2Configs = new ODocument();
        File serverDBHome = new File(server.getDatabaseDirectory());
        File[] dbDirectories = serverDBHome.listFiles();
        for (int i = 0; i < dbDirectories.length; ++i) {
            String dbName = dbDirectories[i].getName();
            File currentETLConfigDir = new File(dbDirectories[i].getAbsolutePath() + "/etl-config/");
            if (!currentETLConfigDir.exists()) continue;
            LinkedList<ODocument> configs = new LinkedList<ODocument>();
            File[] currentDBConfigs = currentETLConfigDir.listFiles();
            for (int k = 0; k < currentDBConfigs.length; ++k) {
                String currentConfigName = currentDBConfigs[k].getName();
                if (!currentConfigName.endsWith(".json")) continue;
                ODocument currentConfig = new ODocument();
                currentConfig.field("configName", (Object)currentConfigName);
                String configText = null;
                try (Scanner scanner = null;){
                    scanner = new Scanner(currentDBConfigs[k]);
                    configText = scanner.useDelimiter("\\A").next();
                }
                currentConfig.field("config", configText);
                configs.add(currentConfig);
            }
            database2Configs.field(dbName, configs);
        }
        return database2Configs;
    }
}

