/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.extractor;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLProcessor;
import com.orientechnologies.orient.etl.OExtractedItem;
import com.orientechnologies.orient.etl.extractor.OAbstractExtractor;
import com.orientechnologies.orient.etl.extractor.OExtractorException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class OJDBCExtractor
extends OAbstractExtractor {
    protected String url;
    protected String userName;
    protected String userPassword;
    protected String query;
    protected String queryCount;
    protected String driverClass;
    protected Connection conn;
    protected Statement stm;
    protected ResultSet rs;
    protected boolean didNext = false;
    protected boolean hasNext = false;
    protected int rsColumns;
    protected List<String> columnNames = null;
    protected List<OType> columnTypes = null;
    protected int fetchSize = 10000;

    @Override
    public void configure(OETLProcessor iProcessor, ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iProcessor, iConfiguration, iContext);
        this.driverClass = (String)this.resolve(iConfiguration.field("driver"));
        this.url = (String)this.resolve(iConfiguration.field("url"));
        this.userName = (String)this.resolve(iConfiguration.field("userName"));
        this.userPassword = (String)this.resolve(iConfiguration.field("userPassword"));
        this.query = (String)this.resolve(iConfiguration.field("query"));
        this.queryCount = (String)this.resolve(iConfiguration.field("queryCount"));
        if (iConfiguration.containsField("fetchSize")) {
            this.fetchSize = (Integer)this.resolve(iConfiguration.field("fetchSize"));
        }
        try {
            Class.forName(this.driverClass).newInstance();
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OConfigurationException("[JDBC extractor] JDBC Driver " + this.driverClass + " not found"), (Throwable)e);
        }
        try {
            this.conn = DriverManager.getConnection(this.url, this.userName, this.userPassword);
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OConfigurationException("[JDBC extractor] error on connecting to JDBC url '" + this.url + "' using user '" + this.userName + "' and the password provided"), (Throwable)e);
        }
    }

    @Override
    public void begin() {
        try {
            this.stm = this.conn.createStatement(1003, 1007);
            this.stm.setFetchSize(this.fetchSize);
            if (this.queryCount != null) {
                ResultSet countRs = this.stm.executeQuery(this.query);
                try {
                    if (countRs != null && countRs.next()) {
                        this.total = countRs.getInt(1);
                    }
                }
                finally {
                    if (countRs != null) {
                        try {
                            countRs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
            this.rs = this.stm.executeQuery(this.query);
            this.rsColumns = this.rs.getMetaData().getColumnCount();
            this.columnNames = new ArrayList<String>(this.rsColumns);
            this.columnTypes = new ArrayList<OType>(this.rsColumns);
            for (int i = 1; i <= this.rsColumns; ++i) {
                String colName = this.rs.getMetaData().getColumnLabel(i);
                this.columnNames.add(colName);
                OType type = OType.ANY;
                int sqlType = this.rs.getMetaData().getColumnType(i);
                switch (sqlType) {
                    case -7: 
                    case 16: {
                        type = OType.BOOLEAN;
                        break;
                    }
                    case 5: {
                        type = OType.SHORT;
                        break;
                    }
                    case 4: {
                        type = OType.INTEGER;
                        break;
                    }
                    case 6: {
                        type = OType.FLOAT;
                        break;
                    }
                    case 8: {
                        type = OType.DOUBLE;
                        break;
                    }
                    case -5: {
                        type = OType.LONG;
                        break;
                    }
                    case 3: {
                        type = OType.DECIMAL;
                        break;
                    }
                    case 91: {
                        type = OType.DATE;
                        break;
                    }
                    case 93: {
                        type = OType.DATETIME;
                        break;
                    }
                    case -16: 
                    case -1: 
                    case 12: {
                        type = OType.STRING;
                        break;
                    }
                    case -2: 
                    case 2004: {
                        type = OType.BINARY;
                        break;
                    }
                    case -6: 
                    case 1: {
                        type = OType.BYTE;
                    }
                }
                this.columnTypes.add(type);
            }
        }
        catch (SQLException e) {
            throw new OExtractorException("[JDBC extractor] error on executing query '" + this.query + "'", e);
        }
    }

    @Override
    public void end() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.stm != null) {
            try {
                this.stm.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void extract(Reader iReader) {
    }

    @Override
    public String getUnit() {
        return "records";
    }

    @Override
    public boolean hasNext() {
        try {
            if (!this.didNext) {
                this.hasNext = this.rs.next();
                ++this.current;
                this.didNext = true;
            }
            return this.hasNext;
        }
        catch (SQLException e) {
            throw new OExtractorException("[JDBC extractor] error on moving forward in resultset of query '" + this.query + "'. Previous position was " + this.current, e);
        }
    }

    @Override
    public OExtractedItem next() {
        try {
            if (!this.didNext && !this.rs.next()) {
                throw new NoSuchElementException("[JDBC extractor] previous position was " + this.current);
            }
            this.didNext = false;
            ODocument doc = new ODocument();
            for (int i = 0; i < this.rsColumns; ++i) {
                Object fieldValue = this.rs.getObject(i + 1);
                doc.field(this.columnNames.get(i), fieldValue);
            }
            return new OExtractedItem(this.current++, doc);
        }
        catch (SQLException e) {
            throw new OExtractorException("[JDBC extractor] error on moving forward in resultset of query '" + this.query + "'. Previous position was " + this.current, e);
        }
    }

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[{driver:{optional:false,description:'JDBC Driver class'}},{url:{optional:false,description:'Connection URL'}},{userName:{optional:false,description:'User name'}},{userPassword:{optional:false,description:'User password'}},{fetchSize:{optional:true,description:'JDBC cursor fetch size. Default is 10000'}},{query:{optional:false,description:'Query that extract records'}},{queryCount:{optional:true,description:'Query that returns the count to have a correct progress status'}}],output:'ODocument'}");
    }

    @Override
    public String getName() {
        return "jdbc";
    }
}

