/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.context;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.etl.context.OETLMessageHandler;
import com.orientechnologies.orient.output.OPluginMessageHandler;
import java.io.PrintWriter;
import java.io.StringWriter;

public class OETLContext
extends OBasicCommandContext {
    private OPluginMessageHandler messageHandler = new OETLMessageHandler(0);

    public OPluginMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(OPluginMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public String printExceptionMessage(Exception e, String message, String level) {
        message = e.getMessage() != null ? message + "\n" + e.getClass().getName() + " - " + e.getMessage() : message + "\n" + e.getClass().getName();
        switch (level) {
            case "debug": {
                this.messageHandler.debug((Object)this, message);
                break;
            }
            case "info": {
                this.messageHandler.info((Object)this, message);
                break;
            }
            case "warn": {
                this.messageHandler.warn((Object)this, message);
                break;
            }
            case "error": {
                this.messageHandler.error((Object)this, message);
            }
        }
        return message;
    }

    public String printExceptionStackTrace(Exception e, String level) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String s = ((Object)writer).toString();
        switch (level) {
            case "debug": {
                this.messageHandler.debug((Object)this, "\n" + s + "\n");
                break;
            }
            case "info": {
                this.messageHandler.info((Object)this, "\n" + s + "\n");
                break;
            }
            case "warn": {
                this.messageHandler.warn((Object)this, "\n" + s + "\n");
                break;
            }
            case "error": {
                this.messageHandler.error((Object)this, "\n" + s + "\n");
            }
        }
        return s;
    }
}

