/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.thread.OThreadPoolExecutorWithLogging;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLComponent;
import com.orientechnologies.orient.etl.OETLComponentFactory;
import com.orientechnologies.orient.etl.OETLPipeline;
import com.orientechnologies.orient.etl.OETLProcessHaltedException;
import com.orientechnologies.orient.etl.OExtractedItem;
import com.orientechnologies.orient.etl.block.OBlock;
import com.orientechnologies.orient.etl.context.OETLContext;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.extractor.OExtractor;
import com.orientechnologies.orient.etl.loader.OLoader;
import com.orientechnologies.orient.etl.source.OSource;
import com.orientechnologies.orient.etl.transformer.OTransformer;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public class OETLProcessor {
    protected final OETLComponentFactory factory = new OETLComponentFactory();
    protected final OETLProcessorStats stats = new OETLProcessorStats();
    protected List<OBlock> beginBlocks;
    protected List<OBlock> endBlocks;
    protected OSource source;
    protected OExtractor extractor;
    protected OLoader loader;
    protected List<OTransformer> transformers;
    protected Collection<ODocument> transformersRaw;
    protected OCommandContext context;
    protected long startTime;
    protected long elapsed;
    protected TimerTask dumpTask;
    protected LOG_LEVELS logLevel = LOG_LEVELS.INFO;
    protected boolean haltOnError = true;
    protected int maxRetries = 10;
    protected int workers = 1;
    private boolean parallel = false;
    private ExecutorService executor;
    private LinkedBlockingQueue<OExtractedItem> queue;

    public OETLProcessor(List<OBlock> iBeginBlocks, OSource iSource, OExtractor iExtractor, List<OTransformer> iTransformers, OLoader iLoader, List<OBlock> iEndBlocks, OCommandContext ctx) {
        this.beginBlocks = iBeginBlocks;
        this.source = iSource;
        this.extractor = iExtractor;
        this.transformers = iTransformers;
        this.loader = iLoader;
        this.endBlocks = iEndBlocks;
        this.context = ctx;
        OETLContextWrapper.newInstance().setContext(this.context);
        this.init();
    }

    public OETLProcessor() {
        this.context = OETLProcessor.createDefaultContext();
        OETLContextWrapper.newInstance().setContext(this.context);
    }

    public static void main(String[] args) {
        System.out.println("OrientDB etl v." + OConstants.getVersion() + " " + "https://www.orientdb.com");
        if (args.length == 0) {
            System.out.println("Syntax error, missing configuration file.");
            System.out.println("Use: oetl.sh <json-file>");
            System.exit(1);
        }
        OETLProcessor processor = OETLProcessor.parseConfigAndParameters(args);
        processor.execute();
    }

    public static OETLProcessor parseConfigAndParameters(String[] args) {
        OCommandContext context = OETLProcessor.createDefaultContext();
        ODocument configuration = new ODocument().fromJSON("{}");
        for (String arg : args) {
            if (arg.charAt(0) == '-') continue;
            try {
                String config = OIOUtils.readFileAsString((File)new File(arg));
                configuration.merge(new ODocument().fromJSON(config, "noMap"), true, true);
                ODocument cfgGlobal = (ODocument)configuration.field("config");
                if (cfgGlobal == null) continue;
                for (String f : cfgGlobal.fieldNames()) {
                    context.setVariable(f, cfgGlobal.field(f));
                }
            }
            catch (IOException e) {
                throw OException.wrapException((OException)new OConfigurationException("Error on loading config file: " + arg), (Throwable)e);
            }
        }
        for (String arg : args) {
            if (arg.charAt(0) != '-') continue;
            String[] parts = arg.substring(1).split("=");
            context.setVariable(parts[0], (Object)parts[1]);
        }
        return new OETLProcessor().parse(configuration, context);
    }

    protected static OCommandContext createDefaultContext() {
        OETLContext context = new OETLContext();
        context.setVariable("dumpEveryMs", 1000);
        return context;
    }

    protected void init() {
        int cores;
        Object parallelSetting;
        Boolean cfgHaltOnError;
        String cfgLog = (String)this.context.getVariable("log");
        if (cfgLog != null) {
            this.logLevel = LOG_LEVELS.valueOf(cfgLog.toUpperCase(Locale.ENGLISH));
        }
        if ((cfgHaltOnError = (Boolean)this.context.getVariable("haltOnError")) != null) {
            this.haltOnError = cfgHaltOnError;
        }
        if ((parallelSetting = this.context.getVariable("parallel")) != null) {
            this.parallel = (Boolean)parallelSetting;
        }
        if (this.parallel && (cores = Runtime.getRuntime().availableProcessors()) >= 2) {
            this.workers = cores - 1;
        }
    }

    public OETLProcessor parse(ODocument cfg, OCommandContext ctx) {
        return this.parse((Collection)cfg.field("begin"), (ODocument)cfg.field("source"), (ODocument)cfg.field("extractor"), (Collection)cfg.field("transformers"), (ODocument)cfg.field("loader"), (Collection)cfg.field("end"), ctx);
    }

    public OETLProcessor parse(Collection<ODocument> iBeginBlocks, ODocument iSource, ODocument iExtractor, Collection<ODocument> iTransformers, ODocument iLoader, Collection<ODocument> iEndBlocks, OCommandContext ctx) {
        if (iExtractor == null) {
            throw new IllegalArgumentException("No Extractor configured");
        }
        this.context = ctx != null ? ctx : OETLProcessor.createDefaultContext();
        this.init();
        try {
            this.configureBeginBlocks(iBeginBlocks, ctx);
            this.configureSource(iSource, ctx);
            this.configureExtractors(iExtractor, ctx);
            this.copySkipDuplicatestoLoaderConf(iTransformers, iLoader);
            this.configureLoader(iLoader, ctx);
            if (iLoader.containsField("cluster")) {
                for (ODocument aTransformer : iTransformers) {
                    aTransformer.field("cluster", iLoader.field("cluster"));
                }
            }
            this.transformers = this.configureTransformers(iTransformers, ctx);
            this.transformersRaw = iTransformers;
            this.configureEndBlocks(iEndBlocks, ctx);
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OConfigurationException("Error on creating ETL processor"), (Throwable)e);
        }
        return this;
    }

    private void copySkipDuplicatestoLoaderConf(Collection<ODocument> iTransformers, ODocument iLoader) {
        if (iTransformers != null) {
            for (ODocument transformer : iTransformers) {
                ODocument vertexConf;
                if (!transformer.containsField("vertex") || !(vertexConf = (ODocument)transformer.field("vertex")).containsField("skipDuplicates")) continue;
                ODocument loaderConf = (ODocument)iLoader.field(iLoader.fieldNames()[0]);
                loaderConf.field("skipDuplicates", vertexConf.field("skipDuplicates"));
            }
        }
    }

    private void configureEndBlocks(Collection<ODocument> iEndBlocks, OCommandContext ctx) throws IllegalAccessException, InstantiationException {
        this.endBlocks = new ArrayList<OBlock>();
        if (iEndBlocks != null) {
            for (ODocument block : iEndBlocks) {
                String name = block.fieldNames()[0];
                OBlock b = this.factory.getBlock(name);
                this.endBlocks.add(b);
                this.configureComponent(b, (ODocument)block.field(name), ctx);
            }
        }
    }

    private List<OTransformer> configureTransformers(Collection<ODocument> iTransformers, OCommandContext ctx) throws IllegalAccessException, InstantiationException {
        ArrayList<OTransformer> transformers = new ArrayList<OTransformer>();
        if (iTransformers != null) {
            for (ODocument t : iTransformers) {
                String name = t.fieldNames()[0];
                OTransformer tr = this.factory.getTransformer(name);
                transformers.add(tr);
                this.configureComponent(tr, (ODocument)t.field(name), ctx);
            }
        }
        return transformers;
    }

    private void configureLoader(ODocument iLoader, OCommandContext ctx) throws IllegalAccessException, InstantiationException {
        if (iLoader != null) {
            String name = iLoader.fieldNames()[0];
            this.loader = this.factory.getLoader(name);
            this.configureComponent(this.loader, (ODocument)iLoader.field(name), ctx);
        } else {
            this.loader = this.factory.getLoader("output");
        }
    }

    private void configureExtractors(ODocument iExtractor, OCommandContext ctx) throws IllegalAccessException, InstantiationException {
        String name = iExtractor.fieldNames()[0];
        this.extractor = this.factory.getExtractor(name);
        this.configureComponent(this.extractor, (ODocument)iExtractor.field(name), ctx);
    }

    private void configureSource(ODocument sourceConf, OCommandContext ctx) throws IllegalAccessException, InstantiationException {
        if (sourceConf != null) {
            String name = sourceConf.fieldNames()[0];
            this.source = this.factory.getSource(name);
            this.configureComponent(this.source, (ODocument)sourceConf.field(name), ctx);
        } else {
            this.out(LOG_LEVELS.INFO, "source element is not configured, falling back to system input source reader", new Object[0]);
            this.source = this.factory.getSource("input");
        }
    }

    private void configureBeginBlocks(Collection<ODocument> iBeginBlocks, OCommandContext ctx) throws IllegalAccessException, InstantiationException {
        this.beginBlocks = new ArrayList<OBlock>();
        if (iBeginBlocks != null) {
            for (ODocument block : iBeginBlocks) {
                String name = block.fieldNames()[0];
                OBlock b = this.factory.getBlock(name);
                this.beginBlocks.add(b);
                this.configureComponent(b, (ODocument)block.field(name), ctx);
                b.execute();
            }
        }
    }

    public OETLComponentFactory getFactory() {
        return this.factory;
    }

    public void out(LOG_LEVELS iLogLevel, String iText, Object ... iArgs) {
        if (this.logLevel.ordinal() >= iLogLevel.ordinal()) {
            System.out.println(String.format(iText, iArgs));
        }
    }

    public OETLProcessorStats getStats() {
        return this.stats;
    }

    public OExtractor getExtractor() {
        return this.extractor;
    }

    public OSource getSource() {
        return this.source;
    }

    public OLoader getLoader() {
        return this.loader;
    }

    public List<OTransformer> getTransformers() {
        return this.transformers;
    }

    public LOG_LEVELS getLogLevel() {
        return this.logLevel;
    }

    public OCommandContext getContext() {
        return this.context;
    }

    protected void execute() {
        this.begin();
        this.runExtractorAndPipeline();
        this.end();
    }

    private void runExtractorAndPipeline() {
        this.executor = new OThreadPoolExecutorWithLogging(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue());
        try {
            OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "Started execution with %d worker threads", new Object[]{this.workers});
            this.extractor.extract(this.source.read());
            this.queue = new LinkedBlockingQueue(this.workers * 500);
            AtomicLong counter = new AtomicLong();
            ArrayList<Future<Boolean>> tasks = new ArrayList<Future<Boolean>>();
            for (int i = 0; i < this.workers; ++i) {
                OETLPipeline pipeline = new OETLPipeline(this, this.configureTransformers(this.transformersRaw, this.context), this.loader, this.logLevel, this.maxRetries, this.haltOnError);
                pipeline.begin();
                OETLPipelineWorker oETLPipelineWorker = new OETLPipelineWorker(this.queue, pipeline);
                tasks.add(this.executor.submit(oETLPipelineWorker));
            }
            Future<Boolean> extractorFuture = this.executor.submit(new OETLExtractorWorker(this.queue, counter));
            for (Future future : tasks) {
                Boolean result = (Boolean)future.get();
                OETLContextWrapper.getInstance().getMessageHandler().debug((Object)this, "Pipeline worker done without errors: " + result);
            }
        }
        catch (OETLProcessHaltedException e) {
            OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "ETL process halted: %s", new Object[]{e});
            this.executor.shutdownNow();
        }
        catch (Exception e) {
            OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "ETL process has problem: %s", new Object[]{e});
            this.executor.shutdownNow();
        }
        this.executor.shutdown();
    }

    protected void begin() {
        Integer dumpEveryMs;
        OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "BEGIN ETL PROCESSOR");
        Integer cfgMaxRetries = (Integer)this.context.getVariable("maxRetries");
        if (cfgMaxRetries != null) {
            this.maxRetries = cfgMaxRetries;
        }
        if ((dumpEveryMs = (Integer)this.context.getVariable("dumpEveryMs")) != null && dumpEveryMs > 0) {
            this.dumpTask = new TimerTask(){

                @Override
                public void run() {
                    OETLProcessor.this.dumpProgress();
                }
            };
            Orient.instance().scheduleTask(this.dumpTask, (long)dumpEveryMs.intValue(), (long)dumpEveryMs.intValue());
            this.startTime = System.currentTimeMillis();
        }
        for (OBlock t : this.beginBlocks) {
            t.begin();
            t.execute();
            t.end();
        }
        if (this.source != null) {
            this.source.begin();
        }
        this.extractor.begin();
    }

    protected void end() {
        for (OTransformer oTransformer : this.transformers) {
            oTransformer.end();
        }
        if (this.source != null) {
            this.source.end();
        }
        this.extractor.end();
        this.loader.end();
        for (OBlock oBlock : this.endBlocks) {
            oBlock.begin();
            oBlock.execute();
            oBlock.end();
        }
        this.elapsed = System.currentTimeMillis() - this.startTime;
        if (this.dumpTask != null) {
            this.dumpTask.cancel();
        }
        OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "END ETL PROCESSOR");
        this.dumpProgress();
    }

    protected void configureComponent(OETLComponent iComponent, ODocument iCfg, OCommandContext ctx) {
        iComponent.configure(this, iCfg, ctx);
    }

    protected void dumpProgress() {
        String extractorTotalFormatted;
        long now = System.currentTimeMillis();
        long extractorProgress = this.extractor.getProgress();
        long extractorTotal = this.extractor.getTotal();
        long extractorItemsSec = (long)((float)(extractorProgress - this.stats.lastExtractorProgress) * 1000.0f / (float)(now - this.stats.lastLap));
        String extractorUnit = this.extractor.getUnit();
        long loaderProgress = this.loader.getProgress();
        long loaderItemsSec = (long)((float)(loaderProgress - this.stats.lastLoaderProgress) * 1000.0f / (float)(now - this.stats.lastLap));
        String loaderUnit = this.loader.getUnit();
        String string = extractorTotalFormatted = extractorTotal > -1L ? String.format("%,d", extractorTotal) : "?";
        if (extractorTotal == -1L) {
            OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "+ extracted %,d %s (%,d %s/sec) - %,d %s -> loaded %,d %s (%,d %s/sec) Total time: %s [%d warnings, %d errors]", new Object[]{extractorProgress, extractorUnit, extractorItemsSec, extractorUnit, this.extractor.getProgress(), this.extractor.getUnit(), loaderProgress, loaderUnit, loaderItemsSec, loaderUnit, OIOUtils.getTimeAsString((long)(now - this.startTime)), this.stats.warnings.get(), this.stats.errors.get()});
        } else {
            float extractorPercentage = (float)extractorProgress * 100.0f / (float)extractorTotal;
            OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "+ %3.2f%% -> extracted %,d/%,d %s (%,d %s/sec) - %,d %s -> loaded %,d %s (%,d %s/sec) Total time: %s [%d warnings, %d errors]", new Object[]{Float.valueOf(extractorPercentage), extractorProgress, extractorTotal, extractorUnit, extractorItemsSec, extractorUnit, this.extractor.getProgress(), this.extractor.getUnit(), loaderProgress, loaderUnit, loaderItemsSec, loaderUnit, OIOUtils.getTimeAsString((long)(now - this.startTime)), this.stats.warnings.get(), this.stats.errors.get()});
        }
        this.stats.lastExtractorProgress = extractorProgress;
        this.stats.lastLoaderProgress = loaderProgress;
        this.stats.lastLap = now;
    }

    protected void analyzeFlow() {
        if (this.extractor == null) {
            throw new OConfigurationException("extractor is null");
        }
        if (this.loader == null) {
            throw new OConfigurationException("loader is null");
        }
        OETLComponent lastComponent = this.extractor;
        for (OTransformer t : this.transformers) {
            this.checkTypeCompatibility(t, lastComponent);
            lastComponent = t;
        }
        this.checkTypeCompatibility(this.loader, lastComponent);
    }

    protected void checkTypeCompatibility(OETLComponent iCurrentComponent, OETLComponent iLastComponent) {
        List ins;
        String out;
        try {
            out = (String)iLastComponent.getConfiguration().field("output");
            if (out == null) {
                return;
            }
            ins = (List)iCurrentComponent.getConfiguration().field("input");
            if (ins == null) {
                return;
            }
            Class outClass = this.getClassByName(iLastComponent, out);
            for (String in : ins) {
                Class inClass = this.getClassByName(iCurrentComponent, in);
                if (!inClass.isAssignableFrom(outClass)) continue;
                return;
            }
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OConfigurationException("Error on checking compatibility between components '" + iLastComponent.getName() + "' and '" + iCurrentComponent.getName() + "'"), (Throwable)e);
        }
        throw new OConfigurationException("Component '" + iCurrentComponent.getName() + "' expects one of the following inputs " + ins + " but the 'output' for component '" + iLastComponent.getName() + "' is: " + out);
    }

    protected Class getClassByName(OETLComponent iComponent, String iClassName) {
        Class inClass;
        if (iClassName.equals("ODocument")) {
            inClass = ODocument.class;
        } else if (iClassName.equals("String")) {
            inClass = String.class;
        } else if (iClassName.equals("Object")) {
            inClass = Object.class;
        } else if (iClassName.equals("OrientVertex")) {
            inClass = OrientVertex.class;
        } else if (iClassName.equals("OrientEdge")) {
            inClass = OrientEdge.class;
        } else {
            try {
                inClass = Class.forName(iClassName);
            }
            catch (ClassNotFoundException e) {
                throw OException.wrapException((OException)new OConfigurationException("Class '" + iClassName + "' declared as 'input' of ETL Component '" + iComponent.getName() + "' was not found."), (Throwable)e);
            }
        }
        return inClass;
    }

    private class OETLExtractorWorker
    implements Callable<Boolean> {
        private final BlockingQueue<OExtractedItem> queue;
        private final AtomicLong counter;

        public OETLExtractorWorker(BlockingQueue<OExtractedItem> queue, AtomicLong counter) {
            this.queue = queue;
            this.counter = counter;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                OETLProcessor.this.out(LOG_LEVELS.DEBUG, "Start extracting", new Object[0]);
                while (OETLProcessor.this.extractor.hasNext()) {
                    OExtractedItem current = (OExtractedItem)OETLProcessor.this.extractor.next();
                    this.queue.put(current);
                    this.counter.incrementAndGet();
                }
                OETLProcessor.this.out(LOG_LEVELS.DEBUG, "Extraction completed", new Object[0]);
                this.queue.put(new OExtractedItem(true));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "Error during extraction: " + e);
                return Boolean.FALSE;
            }
        }
    }

    public class OETLProcessorStats {
        public long lastExtractorProgress = 0L;
        public long lastLoaderProgress = 0L;
        public long lastLap = 0L;
        public AtomicLong warnings = new AtomicLong();
        public AtomicLong errors = new AtomicLong();

        public long incrementWarnings() {
            return this.warnings.incrementAndGet();
        }

        public long incrementErrors() {
            return this.errors.incrementAndGet();
        }
    }

    private static final class OETLPipelineWorker
    implements Callable<Boolean> {
        private final BlockingQueue<OExtractedItem> queue;
        private final OETLPipeline pipeline;

        public OETLPipelineWorker(BlockingQueue<OExtractedItem> queue, OETLPipeline pipeline) {
            this.queue = queue;
            this.pipeline = pipeline;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            OExtractedItem content;
            this.pipeline.getDocumentDatabase();
            try {
                while (true) {
                    content = this.queue.take();
                    if (!content.finished) {
                        this.pipeline.execute(content);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "ETL process interrupted: " + e);
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            catch (OETLProcessHaltedException e) {
                OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "ETL process halted: " + (Object)((Object)e));
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            finally {
                this.pipeline.end();
            }
            this.queue.put(content);
            return Boolean.TRUE;
        }
    }

    public static enum LOG_LEVELS {
        NONE(Level.OFF),
        ERROR(Level.SEVERE),
        INFO(Level.INFO),
        DEBUG(Level.FINE);

        private final Level julLevel;

        private LOG_LEVELS(Level julLevel) {
            this.julLevel = julLevel;
        }

        public Level toJulLevel() {
            return this.julLevel;
        }
    }
}

